package antipatterns;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.directory.*;
import java.util.*;

public class MakeRoot {
        final static String ldapServerName = "localhost";
        final static String rootdn = "cn=Manager, o=jndiTest";
        final static String rootpass = "secret";
        final static String rootContext = "o=jndiTest";
        
        public static void main( String[] args ) {
                // konfiguruje rodowisko dostpu do serwera
                
                Properties env = new Properties();
                
                env.put( Context.INITIAL_CONTEXT_FACTORY,
                         "com.sun.jndi.ldap.LdapCtxFactory" );
                env.put( Context.PROVIDER_URL, "ldap://" + ldapServerName + "/" );
                env.put( Context.SECURITY_PRINCIPAL, rootdn );
                env.put( Context.SECURITY_CREDENTIALS, rootpass );
                
                try {
                        // pobiera pocztkowy kontekst katalogu ze rodowiska
                        DirContext ctx = new InitialDirContext( env );
                        
                        // i tworzy jego kontekst podrzdny
                        ctx.createSubcontext( rootContext );
                } catch ( NameAlreadyBoundException nabe ) {
                        System.err.println( rootContext + " jest ju powizany!" );
                } catch ( Exception e ) {
                        System.err.println( e );
                }
        }
}

