package cfexample.controller;

import java.io.*;
import java.net.*;
import java.util.*;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/**
 * Filtr buforujcy strony po ich wygenerowaniu.
 */
public class CacheFilter implements Filter {
    /** konfiguracja filtra 
    private FilterConfig filterConfig = null;
    
    /** buforowane dane */
    private HashMap cache;
    
    /**
     * Konstruktor
     */
    public CacheFilter() {
    }
    
    /**
     * Wykonuje waciwe buforowanie.  Jeli klucz dostpny jest w buforze,
     * to zwraca go natychmiast.  Jeli nie, to buforuje wynik za pomoc
     * obiektu CacheResponseWrapper.
     */
    public void doFilter(ServletRequest request, 
                         ServletResponse response,
                         FilterChain chain)
        throws IOException, ServletException
    {
        HttpServletRequest req = (HttpServletRequest) request;
        HttpServletResponse res = (HttpServletResponse) response;
       
        // klucz tworzony jest nastpujco: URI + acuch zapytania
        String key = req.getRequestURI() + "?" + req.getQueryString();
        
        // buforuje jedynie te dania GET, ktre zawieraj dane 
        // nadajce si do buforowania
        if (req.getMethod().equalsIgnoreCase("get") && isCacheable(key)) {
            // prbuje pobra dane z bufora
            byte[] data = (byte[]) cache.get(key);
            
            // jeli danych nie ma w buforze, to generuje wynik w zwyky sposb   
            // i dodaje go do bufora
            if (data == null) {
                CacheResponseWrapper crw = new CacheResponseWrapper(res);
                chain.doFilter(request, crw);
                data = crw.getBytes();
                cache.put(key, data);
            } 
            
            // jeli dane zostay odnalezione, to uywa ich 
            // do wygenerowania wyniku
            if (data != null) {
                res.setContentType("text/html");
                res.setContentLength(data.length);
                
                try {
                    OutputStream os = res.getOutputStream();
                    os.write(data);
                    os.flush();
                    os.close();
                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            // generuje dane w zwyky sposb
            // (gdy nie s buforowane)
            chain.doFilter(request, response);
        }
    }
    
    /**
     * Sprawdza czy kombinacja URI + acuch zapytania nadaje si 
     * do buforowania. Prawdziwa implementacja powinna stosowa tutaj
     * pewn polityk.
     */
    private boolean isCacheable(String key) {
        return true;
    }
    
    /**
     * Inicjuje bufor
     */
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        
        cache = new HashMap();
    }
    /**
     * Usuwa bufor
     */
    public void destroy() {
        cache.clear();
        
        cache = null;
        filterConfig = null;
    }
}

