package s2wexample.model;

/**
 * Bardzo prosta implementacja interfejsu UserBean.  Przechowuje
 * odpowiednie wartoci jedynie w pamici.  
 */
public class UserBeanImpl implements UserBean {
    /** nazwa uytkownika */
    private String username;
    
    /** haso */
    private String password;
    
    /** preferowany jzyk */
    private String language;
    
    /** uytkownik zalogowany? */
    private boolean loggedIn = false;
    
    /**
     * Konstruktor.
     */
    public UserBeanImpl() {
    }
    
    /**
     * Metoda biznesowa logowania
     */
    public boolean doLogin() {
        loggedIn = false;
       
        // Sprawdza, czy okrelone zostao haso
        // dusze ni trzy znaki. Prawdziwa wersja tej metody powinna korzysta
        // z odpowiedniego mechanizmu uwiarygadniania uytkownika.

        if((username != null) && (username.length() > 0) &&
           (password != null) && (password.length() > 3)) {
            loggedIn = true;
        }
        
        return loggedIn;
    }
    
    /**
     * Zwraca jzyk preferowany przez uytkownika
     */
    public String getLanguage() {
        return language;
    }
    
    /**
     * Okrela jzyk preferowany przez uytkownika
     */
    public void setLanguage(String language) {
        this.language = language;
    }
    
    /**
     * Zwraca nazw uytkownika
     */
    public String getUsername() {
        return username;
    }
    
    /**
     * Okrela nazw uytkownika
     */
    public void setUsername(String username) {
        this.username = username;
    }
    
    /** 
     * Okrela haso
     */
    public void setPassword(String password) {
        this.password = password;
    }
    
    
    /** 
     * Sprawdza czy uytkownik jest zalogowany
     */
    public boolean isLoggedIn() {
        return loggedIn;
    }
}

