package cvexample.controller;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

/**
 * Dyspozytor widokw zoonych.  Uywa atrybutw dania w celu wyboru strony
 * opisanej w pliku views.xml i generuje widok zoony.
 */
public class CompositeDispatcher implements Dispatcher {
    /** znaczniki w pliku views.xml */
    private static final String VIEWS_TAG = "views";
    private static final String VIEW_TAG = "view";
    private static final String CONTAINER_TAG = "container";
    private static final String INCLUDE_TAG = "include";
    
    /** atrybuty w pliku views.xml */
    private static final String TEMPLATE_ATTR = "template"; 
    private static final String NAME_ATTR = "name";
    private static final String URL_ATTR = "url";
    private static final String PAGE_ATTR = "page";
    
    /** atrybut uywany przez znacznik uytkownika */
    private static final String VIEW_ATTR = "view";
    
    /** nazwa domylnego widoku */
    private static final String DEFAULT_VIEW_NAME = "default";
    
    /** kontekst serwletu */
    private ServletContext context;
    
    /** odwzorowanie nazw na widoki */
    private HashMap views;
      
    /**
     * Wywoywana przez wysunity kontroler w celu okrelenia kontekstu
     * dyspozytora.  Parsuje plik views.xml.
     */
    public void setContext(ServletContext context) throws IOException {
        this.context = context;
       
        // wczytuje plik views.xml i parsuje go
        InputStream is = context.getResourceAsStream("/views.xml");
        try {
            views = parseXML(is);
        } catch(Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }
    
    /**
     * Zwraca nastpn stron na podstawie atrybutu dania
     * i odpowiadajcej mu strony w pliku views.xml
     */
    public String getNextPage(HttpServletRequest req) {
        // odczytuje atrybut dania
        String page = (String) req.getParameter(PAGE_ATTR);
        
        // pobiera widok
        View v = (View) views.get(page);
        
        // jeli widoki nie zostay skonfigurowane, to uywa domylnego
        if (v == null) {
            v = (View) views.get(DEFAULT_VIEW_NAME);
        }
        
        // umieszcza biecy widok w daniu; bdzie on
        // wykorzystany przez znaczniki uytkownika
        req.setAttribute(VIEW_ATTR, v);
        return (v.getTemplate());
    }
    
    /** 
     * Parse the views.xml file
     */
    private HashMap parseXML(InputStream is) throws Exception {
        // parsuje plik XML
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder(); 
        Document doc = builder.parse(is);
       
        // znajduje wszystkie znaczniki widokw
        NodeList viewList = doc.getElementsByTagName(VIEW_TAG);
        HashMap viewMap = new HashMap();
     
        // parsuje kady znacznik
        for(int i = 0; i < viewList.getLength(); i++) {
            Element curView = (Element)viewList.item(i);
            String template = curView.getAttribute(TEMPLATE_ATTR);
            String curName = curView.getAttribute(NAME_ATTR);
            
            // tworzy widok
            View newView = new View(template);
            viewMap.put(curName, newView);
            if (i == 0) {
                // pierwszym jest widok domylny
                viewMap.put(DEFAULT_VIEW_NAME, newView);
            }
            
            // parsuje wszystkie kontenery widoku
            NodeList containerList = curView.getElementsByTagName(CONTAINER_TAG);
            for(int k = 0; k < containerList.getLength(); k++) {
                Element curCont = (Element)containerList.item(k);
                String contName = curCont.getAttribute(NAME_ATTR);
                
                // parsuje wszystkie znaczniki include w kontenerze
                NodeList includeList = curView.getElementsByTagName(INCLUDE_TAG);
                for(int l = 0; l < includeList.getLength(); l++) {
                    Element curInclude = (Element)includeList.item(l);
                    
                    String iName = curInclude.getAttribute(NAME_ATTR);
                    String iUrl = curInclude.getAttribute(URL_ATTR);
                    
                    // i dodaje je do widoku
                    newView.addInclude(contName, iName, iUrl);
                }
            }
        }
        
        return viewMap;
    }
}
