// Listing 8.3: PatientDAOFactory.java

package com.oreilly.patterns.chapter8;

public class PatientDAOFactory {

    private static final int DAO_ORACLE = 1;
    private static final int DAO_DB2 = 2;
    private static final int DAO_SYBASE = 3;
    private static final int DAO_LDAP = 4;
    private static final int DAO_NONE = -1;

    private int mode = DAO_NONE;

    public PatientDAOFactory() {
        String dataSource = System.getProperty("app.datasource");
        if ("oracle".equalsIgnoreCase(dataSource))
            mode = DAO_ORACLE;
        else if ("db2".equalsIgnoreCase(dataSource))
            mode = DAO_DB2;
        else if ("sybase".equalsIgnoreCase(dataSource))
            mode = DAO_SYBASE;
        else if ("ldap".equalsIgnoreCase(dataSource))
            mode = DAO_LDAP;
    }

    public PatientDAO getPatientDAO() {
        switch (mode) {
            case DAO_ORACLE:
                return new PatientDatabaseDAO(); // oglny, dziaa z Oracle
            case DAO_DB2:
                return new PatientDatabaseDAO(); // ale rwnie z DB2
                // case DAO_SYBASE:   // Nie zosta zaimplementowany.
                //  return new PatientSybaseDAO(); // Sybase wymaga innego obiektu
                // case DAO_LDAP:
                //   return new PatientLDAPDAO(); // a jeszcze innego LDAP
            default:
                throw new DAOCreationException("Mechanizm dostpu do danych nie zosta zkonfigurowany");
        }
    }
}
