// Example 11-2: Stand-Alone MailMonitor

package com.oreilly.patterns.chapter11;

import javax.mail.*;
import javax.mail.internet.*;
import java.io.*;

public class MailMonitor extends Thread {
  boolean interupted = false;
  BlockingMailHandler handler = null;
  private static String username = "contentmail";
  private static String password = "poppasswd";
  private static String mailServer = "mail.company.com";
  
  public MailMonitor(BlockingMailHandler mh) {
    handler = mh;
  }

  public void stopRunning() {
    interupted = true;
  }
  
  public void run() {
    Session session = Session.getDefaultInstance(System.getProperties());
    Store store = null;
    try	 {
      store = session.getStore("pop3");
    } catch (NoSuchProviderException nspe) {
      nspe.printStackTrace();
      return;
    }

    while(!interupted) {
      System.out.println("Ptla pobierania wiadomoci");
      try {
        if (!store.isConnected()) // zawsze powinno by true
          store.connect(mailServer, -1, username, password);
        System.out.println("Poczony");  
        Folder folder = store.getDefaultFolder();
        folder = folder.getFolder("INBOX");
        if (folder == null) {
          System.out.println("Nie mona otworzy folderu INBOX");
          return;
        }

      System.out.println("Otwieram foldery");
      // Prbuje otworzy w trybie read/write. 
      // Jeli si nie powiedzie, to tylko w trybie read-only.
      try {
        folder.open(Folder.READ_WRITE);
      } catch (MessagingException ex) {
        folder.open(Folder.READ_ONLY);
      }

      int totalMessages = folder.getMessageCount();
      int newMessages = folder.getNewMessageCount();
      System.out.println("Liczba wiadomoci: " + totalMessages);
      try {
        Message messages[] = null;
        messages = folder.getMessages(1, totalMessages);

        for (int i = 0, n = messages.length; i < n; i++) {
          boolean mbDelete = handler.handleMessage(messages[i]);									
          // Usuwa wiadomo
          if (mbDelete) {
            messages[i].setFlag(Flags.Flag.DELETED, true);
          }
        } // koniec ptli for
      } catch (MessagingException e) {
        System.out.println("Nie mona pobrac wiadomoci.");
      }

      // Zamyka folder i skrzynk
      folder.close(true);
      store.close();

      } catch (MessagingException e) {
        System.out.println(e.toString());
        return;
      } 
      
      try {
        this.sleep(10000);
      } catch (InterruptedException e) {
        System.out.println("Koniec dziaania");
        return;
      }
    }
  }
}
