package cfexample.controller;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * Klasa obudowujca obiekt ServletResponse w celu buforowania
 */
public class CacheResponseWrapper extends HttpServletResponseWrapper {
    /** buforowany strumie */
    private CacheOutputStream outStream;
    
    /** zastpczy strumie wyjcia i obiekt zapisu */
    private ServletOutputStream stream;
    private PrintWriter writer;
    
    /**
     * Klasa obudowujca ByteArrayOutputStream jako strumie
     * wyjciowy serwletu
     */
    class CacheOutputStream extends ServletOutputStream {
        /** strumie wyjciowy dla tablic bajtowych */
        private ByteArrayOutputStream bos;
        
        /**
         * Konstruktor.
         */
        CacheOutputStream() {
            bos = new ByteArrayOutputStream();
        }
        
        /**
         * Zapisuje dane do strumienia wyjciowego typu ByteArrayOutputStream
         */
        public void write(int param) throws IOException {
            bos.write(param);
        }
        
        /**
         * Zapisuje dane do strumienia wyjciowego typu ByteArrayOutputStream
         */
        public void write(byte[] b, int off, int len) throws IOException {
            bos.write(b, off, len);
        }
        
        /**
         * Zwraca zapisane dane jako tablic bajtow
         */
        protected byte[] getBytes() {
            return bos.toByteArray();
        }
    }
    
    /** 
     * Konstruktor 
     */
    public CacheResponseWrapper(HttpServletResponse original) {
        super(original);
    }
    
    /**
     * Tworzy instancj CacheOutputStream
     */
    protected ServletOutputStream createOutputStream() 
        throws IOException
    {
        outStream = new CacheOutputStream();
        return outStream;
    }
    
    /**
     * Zwraca zastpczy strumie wyjciowy
     */
    public ServletOutputStream getOutputStream()
        throws IOException 
    {
        if (stream != null) {
            return stream;
        }
        
        // sprawdza, czy obiekt zapisu nie zosta ju zainicjowany
        if (writer != null) {
            throw new IOException("Obiekt zapisu jest ju uywany");
        }
        
        stream = createOutputStream();
        return stream;
    }
    
    /**
     * Zwraca zastpczy obiekt zapisu
     */
    public PrintWriter getWriter() throws IOException {
        if (writer != null) {
            return writer;
        }
        
        // sprawdza, czy strumie wyjciowy nie zosta ju zainicjowany
        if (stream != null) {
            throw new IOException("Strumie wyjciowy jest ju uywany");
        }
        
        writer = new PrintWriter(new OutputStreamWriter(createOutputStream()));
        return writer;
    }
    
    /**
     * Zwraca buforowane dane ze strumienia
     */
    protected byte[] getBytes() throws IOException {
        if (outStream != null) {
            return outStream.getBytes();
        }
        
        return null;
    }
}

