//
//  ICFContentHighligtingViewController.m
//  TextKit
//
//  Created by Kyle Richter on 7/21/13.
//  Copyright (c) 2013 Kyle Richter. All rights reserved.
//

#import "ICFContentHighligtingViewController.h"
#import "ICFDynamicTextStorage.h"

@interface ICFContentHighligtingViewController ()

@end

@implementation ICFContentHighligtingViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];

    ICFDynamicTextStorage *textStorage = [[ICFDynamicTextStorage alloc] init];

    NSLayoutManager *layoutManager = [[NSLayoutManager alloc] init];
    
    NSTextContainer *container = [[NSTextContainer alloc] initWithSize:CGSizeMake(myTextView.frame.size.width, CGFLOAT_MAX)];
    container.widthTracksTextView = YES;
    [layoutManager addTextContainer:container];
    [textStorage addLayoutManager:layoutManager];

    myTextView = [[UITextView alloc] initWithFrame:self.view.frame textContainer:container];
    myTextView.autoresizingMask = UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleWidth;
    myTextView.scrollEnabled = YES;
    myTextView.keyboardDismissMode = UIScrollViewKeyboardDismissModeOnDrag;
    
    [self.view addSubview:myTextView];
    
    

    textStorage.tokens = @{ @"Wlazł" : @{ NSForegroundColorAttributeName : [UIColor redColor] },
                            @"kotek" : @{ NSForegroundColorAttributeName : [UIColor blueColor] },
                            @"na" : @{ NSUnderlineStyleAttributeName : @1 },
                            @"płotek" : @{ NSBackgroundColorAttributeName : [UIColor yellowColor] },
                            @"murek" : @{ NSFontAttributeName : [UIFont fontWithName:@"Chalkduster" size:14.0f] },
                            @"kurek" : @{ NSStrikethroughStyleAttributeName : @1 },
                            @"piosnek" : @{ NSStrokeWidthAttributeName : @5 },
                            @"się" : @{ NSFontAttributeName : [UIFont fontWithName:@"Palatino-Bold" size:10.0f], NSForegroundColorAttributeName : [UIColor purpleColor], NSUnderlineStyleAttributeName : @1},
                            defaultTokenName : @{ NSForegroundColorAttributeName : [UIColor blackColor],
                                                  NSFontAttributeName: [UIFont systemFontOfSize:14.0f],
                                                  NSUnderlineStyleAttributeName : @0,
                                                  NSBackgroundColorAttributeName : [UIColor whiteColor],
                                                  NSStrikethroughStyleAttributeName : @0,
                                                  NSStrokeWidthAttributeName : @0}};

    
    NSString *maryText = @"Wlazł kotek na płotek i mruga,\npiękna to piosneczka niedługa.\nWlazł kurek na murek i pieje;\nniech się nikt z tych piosnek nie śmieje.";
    
    [myTextView setText:[NSString stringWithFormat:@"%@\n\n%@\n\n%@", maryText, maryText, maryText]];

}



@end
