//
//  ICFViewController.m
//  WhackACac
//
//  Created by Kyle Richter on 7/2/12.
//  Copyright (c) 2012 Dragon Forged Software. All rights reserved.
//

#import "ICFViewController.h"
#import "ICFGameViewController.h"

@interface ICFViewController ()

@end

@implementation ICFViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [[ICFGameCenterManager sharedManager] setDelegate: self];
    
    //Depending upon OS requirements either method may be used. 
    
    [[ICFGameCenterManager sharedManager] authenticateLocalUser];
    //[[ICFGameCenterManager sharedManager] authenticateLocalUseriOSSix];
}

-(void) viewDidAppear:(BOOL)animated
{
    [super viewDidAppear: animated];
    
    [[ICFGameCenterManager sharedManager] setDelegate: self];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

#pragma mark -
#pragma mark Actions

- (IBAction)play:(id)sender 
{
    
    ICFGameViewController *gameVC = [[ICFGameViewController alloc] init];
    [self.navigationController pushViewController:gameVC animated:YES];
    
}



- (IBAction)leaderboards:(id)sender 
{
    GKLeaderboardViewController *leaderboardViewController = [[GKLeaderboardViewController alloc] init];
    if(leaderboardViewController == nil)
    {
        NSLog(@"Nie można utworzyć kontrolera widoku tablic wyników");
        return;
    }
    
    leaderboardViewController.category = @"com.dragonforged.whackacac.leaderboard";
    leaderboardViewController.timeScope = GKLeaderboardTimeScopeAllTime;
    leaderboardViewController.leaderboardDelegate = self;
    
    [self presentModalViewController:leaderboardViewController animated:YES];
    
    
}

- (IBAction)achievements:(id)sender
{
    GKAchievementViewController *achievementViewController = [[GKAchievementViewController alloc] init];
    
    if(achievementViewController == nil)
    {
        NSLog(@"Nie można utworzyć kontrolera widoku osiągnięć");
        return;
    }
    
    achievementViewController.achievementDelegate = self;
    
    [self presentModalViewController:achievementViewController animated:YES];
    
}


#pragma mark -
#pragma mark GKAchievementViewControllerDelegate

- (void)achievementViewControllerDidFinish:(GKAchievementViewController *)viewController
{
    [self dismissModalViewControllerAnimated: YES];
}

#pragma mark -
#pragma mark GKLeaderboardViewControllerDelegate

- (void)leaderboardViewControllerDidFinish:(GKLeaderboardViewController *)viewController
{
    [self dismissModalViewControllerAnimated: YES];
}

#pragma mark -
#pragma mark GameCenterManagerDelegate

- (void)gameCenterLoggedIn:(NSError*)error
{
    if(error != nil)
    {
		NSLog(@"W trakcie logowania do Game Center wystąpił błąd: %@", [error localizedDescription]);
    }

    else
    {
        NSLog(@"Zalogowano do Game Center!");
    }
}

-(void)gameCenterScroreReported:(NSError *)error;
{
    if(error != nil)
    {
		NSLog(@"W trakcie wysyłania wyniku do Game Center wystąpił błąd: %@", [error localizedDescription]);
    }
    
    else
    {
        NSLog(@"Wysłano wynik!");
    }
}

-(void)gameCenterAchievementReported:(NSError *)error;
{
    if(error != nil)
    {
		NSLog(@"W trakcie zgłaszania osiągnięcia do Game Center wystąpił błąd: %@", [error localizedDescription]);
    }
    
    else
    {
        NSLog(@"Zaktualizowano osiągnięcie!");
    }
}

@end
