/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */


#import <UIKit/UIKit.h>
#import <QuartzCore/QuartzCore.h>

// Istnieje błąd pojawiający się podczas tworzenia obrazów CI z PNG lub JPEG.
// To jest rozwiązanie problemu.
CIImage *ciImageFromPNG(NSString *pngFileName);

// Przesunięcie RGBA.
NSUInteger alphaOffset(NSUInteger x, NSUInteger y, NSUInteger w);
NSUInteger redOffset(NSUInteger x, NSUInteger y, NSUInteger w);
NSUInteger greenOffset(NSUInteger x, NSUInteger y, NSUInteger w);
NSUInteger blueOffset(NSUInteger x, NSUInteger y, NSUInteger w);

// Zrzuty obrazów.
UIImage *imageFromView(UIView *theView);
UIImage *screenShot();

@interface UIImage (Utilities)
// EWyodrębnienie podobrazu.
- (UIImage *) subImageWithBounds:(CGRect) rect;

// Miniaturki.
- (UIImage *) fitInSize: (CGSize) viewsize;
- (UIImage *) centerInSize: (CGSize) viewsize;
- (UIImage *) fillSize: (CGSize) viewsize;

// Utworzenie obrazu rastrowego.
- (UInt8 *) createBitmap;

// Podstawowy algorytm Canny.
- (UIImage *) convolveImageWithEdgeDetection;

// To ominięcie błędu pojawiającego się podczas tworzenia obrazu UIImage z CIImage.
+ (UIImage *) imageWithCIImage: (CIImage *) aCIImage orientation: (UIImageOrientation) anOrientation;

// Utworzenie obrazu na podstawie danych.
+ (UIImage *) imageWithBits: (UInt8 *) bits withSize: (CGSize) size;
@end
