#!/bin/bash

#Ten plik zawiera kod z listingów od 5.1 do 5.5
#Należy uruchomić go w pokazanej postaci, jeśli instrukcje będą wykonywane
#w katalogu, w któym znajduje się plik train_vw_file i lokalizacja plików
#pakietu vowpal_wabbit jest właściwa.
#Aby uzyskać plik train_vw_file, wykonaj skrypt ch5-criteo-process.py 
#na pliku train.txt pobranego z pełnego konkursowego zbioru danych Criteo.

#!5.1
#echo 'Uruchamianie listingu 5.1'
wc -l train_vw_file
grep -c '^-1' train_vw_file
grep -c '^1' train_vw_file

#!5.2
#echo 'Uruchamianie listingu 5.2'
grep '^-1' train_vw_file | sort -R  > negative_examples.dat
grep '^1' train_vw_file | sort -R > positive_examples.dat	
awk 'NR % 3 == 0' negative_examples.dat > negative_examples_downsampled.dat

cat negative_examples_downsampled.dat > all_examples.dat
cat positive_examples.dat >> all_examples.dat

cat all_examples.dat | sort -R  > all_examples_shuffled.dat
awk 'NR % 10 == 0' all_examples_shuffled.dat > all_examples_shuffled_down.dat

#!5.3
echo 'Uruchamianie listingu 5.3'
vw all_examples_shuffled_down.dat --loss_function=logistic -c -b 22 --passes=3 -f model.vw
vw all_examples_shuffled_down.dat -t -i model.vw --invert_hash readable.model
cat readable.model | awk 'NR > 9 {print}' | sort -r -g -k 3 -t : | head -1000 > readable_model_sorted_top

#!5.4
#Tylko dane wyjściowe

#!5.5
echo 'Uruchamianie listingu 5.5'
vw -d test_vw_file -t -i model.vw --loss_function=logistic -r predictions.out
~/dev/vowpal_wabbit/utl/logistic -0 predictions.out > probabilities.out
cut -d ' ' -f 1 test_vw_file | sed -e 's/^-1/0/' > ground_truth.dat


