//START:includes
#include <SPI.h>
#include <Ethernet.h>
//END:includes

//START:defines
#define FLEX_TOO_HI   475
#define FLEX_TOO_LOW  465
#define ONBOARD_LED    13
#define FLEX_SENSOR     0
//END:defines

//START:variables
int bend_value  = 0;
byte bend_state = 0;
//END: variables

//START:network_variables
// konfiguracja parametrw moduu sieciowego
byte MAC[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xEF };

// ten adres IP moduu sieciowego naley zastpi adresem
// nalecym do przedziau dostpnego w danej sieci
byte IPADDR[]  = { 192, 168, 1, 230 }; 

// ten adres naley zastpi adresem bramy (routera)
byte GATEWAY[] = { 192, 168, 1, 1 };

// ten adres naley zastpi mask podsieci
byte SUBNET[]  = { 255, 255, 255, 0 };

// ten adres IP naley zastpi adresem IP serwera PHP
byte PHPSVR[] = {???, ???, ???, ???};

// inicjalizuje obiekt typu Client i przypisuje go do adresu IP
// serwera PHP (zastosowano standardowy port nr 80 protokou HTTP)
Client client(PHPSVR, 80);
//END:network_variables

//START:setup
void setup() 
{
    // na potrzeby komunikatw diagnostycznych w oknie portu szeregowego
    Serial.begin(9600);

    // konfiguruje wbudowan diod LED na wtyku nr 13
    pinMode(ONBOARD_LED, OUTPUT);

    // inicjalizuje modu sieciowy przy uyciu zdefiniowanych wczeniej adresw MAC i IP
    Ethernet.begin(MAC, IPADDR, GATEWAY, SUBNET);
    // czeka na inicjalizacj moduu sieciowego
    delay(1000);
}
//END:setup

//START:ContactWebServer
void ContactWebServer(int bend_value, int bend_state)
{
    Serial.println("Nawizywanie poczenia z serwerem WWW celu wysania ostrzeenia...");

    if (client.connect()) 
    {
        Serial.println("Poczono z serwerem PHP");
        // generuje danie protokou HTTP
        client.print("GET /wateralert.php?alert=");
        client.print(bend_state);
        client.print("&flex=");
        client.print(bend_value);
        client.println(" HTTP/1.0");
        client.println();
        client.stop();
    } 
    else 
    {
        Serial.println("Prba poczenia z serwerem WWW zakoczya si niepowodzeniem");
    }
}
//END:ContactWebServer

//START:SendWaterAlert
void SendWaterAlert(int bend_value, int bend_state)
{
    digitalWrite(ONBOARD_LED, bend_state ? HIGH : LOW);
    if (bend_state)
        Serial.print("Poziom wody przekroczy prg, bend_value=");
    else
        Serial.print("Poziom wody wrci do normalnego stanu bend_value=");
    Serial.println(bend_value);
    ContactWebServer(bend_value, bend_state);
}
//END:SendWaterAlert

//START:main_loop
void loop() 
{
    // czeka sekund w kadej iteracji ptli
    delay(1000);

    // sprawdza napicie na wtyku FLEX_SENSOR
    bend_value = analogRead(FLEX_SENSOR);

    // wysya warto zmiennej bend_value do portu szeregowego w celu wyznaczenia wartoci bazowej
    // ten wiersz naley zamieni w komentarz po wyznaczeniu wartoci bazowej
    // limity zostay zdefiniowane
    Serial.print("bend_value=");
    Serial.println(bend_value);

    switch (bend_state)
    {
    case 0: // warto zmiennej bend_value nie przekracza grnego ani dolnego progu
        if (bend_value >= FLEX_TOO_HI || bend_value <= FLEX_TOO_LOW)
        {
            bend_state = 1;
            SendWaterAlert(bend_value, bend_state);
        }
        break;

    case 1: // warto zmiennej bend_value przekracza grny lub dolny prg
        if (bend_value < FLEX_TOO_HI && bend_value > FLEX_TOO_LOW)
        {
            bend_state = 0;
            SendWaterAlert(bend_value, bend_state);
        }
        break;
    }
}
//END:main_loop