$(function(){

    var interval = 60;
    var cnt = 60;
    var timeRefresh = 60000;
    var counter = 0;
    var interval1;
    var interval2

    $("#loadDataBtn span").hide();
    $("#drawChartBtn span").hide();
    $("#progress-bar").hide();
    $("#chartData").hide();

    function decodeData(data, cnt) {        
        
        if(typeof data[0] !== "undefined"){

            var temp = [];
            var hmd = [];
            var date = [];
            var date_chart = [];

            for (var i = 0; i < data.length; i++){               
                temp[i] = data[i].temp;
                hmd[i] = data[i].hmd;
                date[i] = data[i].date;
                
                d = data[i].date;
                d = d.split(" ")[1];
                d = d.split(":");
                date_chart[i] = d[0]+':'+d[1];
            }
        } else {

            $("#message").text("Brak danych.");
            $("#message").slideDown();
            setTimeout(function(){
                $("#message").slideUp();
            }, 3000);
            return false;
        }
        return [temp, hmd, date, date_chart];
    }    

    $("#loadDataBtn").click(function(){
        var board_id = $("#board_id").val();

        $("#spinner").show();

        $.getJSON("/data.php?board_id="+board_id, function(data) 
        {
            $("#spinner").hide();
            $("#loadDataBtn").blur();

            if((val = decodeData(data, cnt)) !== false){
                $("#nameLocation").text($("#board_id option:selected").text());
                $("#loadTime").text(val[2][0]);
                $("#temperature").text(val[0][0].toFixed(1));
                $("#humidity").text(val[1][0].toFixed(1));
            }
        });
    });

    $("#loadDataBtn").trigger("click");

    function autoRefresh() {
        progressBar();
        interval2 = setInterval(function(){
            clearInterval(interval1);
            counter = 0;
            updateProgressBar(counter);
            $("#loadDataBtn").trigger("click");
            progressBar();
        }, timeRefresh);
    }

    function updateProgressBar(i) {
        $(".progress-bar").css("width", i+'%').attr("aria-valuenow", i);
    }

    function progressBar() {
        $("#progress-bar").show();
        interval1 = setInterval(function(){
            if(counter < 100) {
                counter++;
                updateProgressBar(counter)
            }
        }, timeRefresh/100);
    }

    $("#autoRefresh").click(function(){
        if($(this).prop("checked")){
            counter = 0;
            updateProgressBar(counter);
            $("#progress-bar").show();
            autoRefresh();
        } else {
            $("#progress-bar").hide();
            clearInterval(interval1);
            clearInterval(interval2);
        }
    });

    $("#board_id").on("change", function(){
        $("#nameLocation").text($("#board_id option:selected").text());
        $("#chartData button").trigger("click");
        $("#loadDataBtn").trigger("click");
    });

    $("#drawChartBtn").click(function(){
        if ($("#chartData").is(":visible")){
            chartShow.destroy();
        }
        drawChart();
    });

    $("#chartData button").click(function(){
        $("#chartData").hide();
        try {
            chartShow.destroy();
        } catch {}
    });

    var ctx = document.getElementById("chartShow").getContext("2d");
    var chartShow;

    function drawChart(){
        var board_id = $("#board_id").val();
        
        $("#spinner").show();

        $.getJSON("/data.php?board_id="+board_id+"&interval="+interval+"&cnt="+cnt, function(data){

            $("#spinner").hide();
            $("#drawChartBtn").blur();
            
            if ((val = decodeData(data, cnt)) !== false){

                $("#chartData").show();

                var temp = val[0] || [];
                var hmd = val[1] || [];                
                var date = val[2] || [];
                var date_chart = val[3] || [];              

                chartShow = new Chart(ctx, {
                    type: "line",
                    data: {
                        labels: date_chart,
                        datasets: [
                        {
                            label: "Temperatura",
                            data: temp,
                            backgroundColor: "rgba(5, 158, 138, 0.6)",
                            fill: true,
                            tension: 0.1
                        },
                        {
                            label: "Wilgotność",
                            data: hmd,
                            backgroundColor: "rgba(0, 173, 214, 0.6)",
                            fill: true,
                            tension: 0.1
                        }
                        ]
                    },
                    options: {
                        responsive: true
                    }      
                    });
            }
        });
    }

    var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
    var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
        return new bootstrap.Popover(popoverTriggerEl)
    })    
});