// dołącz obsługę WiFi w zależności od zastosowanego układu ESP
#if defined(ESP8266)
  #include <ESP8266WiFi.h>       // funkcje sieciowe dla układu ESP8266
  #include <ESP8266WebServer.h>  // serwer WWW z obsługą żądań HTTP GET i POST
  #include <ESP8266mDNS.h>       // włącz obsługę multicast DNS
#elif defined(ESP32)
  #include <WiFi.h>              // funkcje sieciowe dla układu ESP32
  #include <WebServer.h>         // serwer WWW z obsługą żądań HTTP GET i POST
  #include <ESPmDNS.h>           // włącz obsługę multicast DNS
#endif

#include <ElegantOTA.h>          // dołącz bibliotekę ElegantOTA
#include <LittleFS.h>            // dołącz obsługę systemu plików LittleFS

// utwórz obiekt serwera WWW na porcie 80
#if defined(ESP8266)
  ESP8266WebServer Server(80);
#elif defined(ESP32)
  WebServer Server(80);
#endif

// dostęp do sieci WiFi
char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define serialSpeed 115200 // prędkość transmisji UART
#define mDNS_host "esp-01" // nazwa urządzenia w sieci lokalnej - http://esp-01.local

void setup()
{
  Serial.begin(serialSpeed);

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  // aktywuj usługę multicast DNS
  if (MDNS.begin(mDNS_host)) { 
    Serial.println(F("Usługa mDNS aktywna."));
  }

  // aktywuj obsługę systemu plików LittleFS
  Serial.print(F("Inicjalizacja systemu plików LittleFS ..."));
  if (LittleFS.begin()){
    Serial.println(F(" gotowe!"));
  } else {
    Serial.println(F(" coś poszło nie tak :("));
  }

  // obsługa wywołania URL strony głównej
  Server.on("/", HTTP_GET, []() {
    Serial.println(F("=> Odebrano żądanie GET /"));
    Server.sendHeader("Connection", "close");
    Server.send(200, "text/html", 
    F("Serwer WWW uruchomiony!<br><a href='/update'>Aktualizacja</a>"));
  });

  ElegantOTA.setID(mDNS_host); // ID urządzenia
  ElegantOTA.begin(&Server);   // dołącz obsługę OTA do serwera WWW
  Server.begin();              // uruchom serwer WWW z obsługą OTA
  MDNS.addService("http", "tcp", 80);
  
  Serial.println(F("Serwer WWW uruchomiony."));
  Serial.println(F("Otwórz w przeglądarce jeden z poniższych adresów URL:"));
  Serial.print(F("=> http://"));
  Serial.println(WiFi.localIP());
  Serial.print(F("=> http://"));
  Serial.print(mDNS_host);
  Serial.println(F(".local"));  
}

void loop() 
{
  Server.handleClient(); // czekaj na połączenia klientów
  #if defined(ESP8266)
    MDNS.update();       // aktualizuj nazwę urządzenia w sieci lokalnej
  #endif
}
