<?php
namespace net\xmp\phpbook; 
require './ExchangeSoapClient.php'; 
require './HTMLPage.php'; 
 
$page = new HTMLPage('Decline meeting request'); 
$options = array('login' => 'tony', 'password' => 'confidential', 
                 'CACert' => './my-ca.cer'); 
$client = new ExchangeSoapClient('./Services.wsdl', $options); 
// Wyszukiwanie w skrzynce odbiorczej.
$param = array('Traversal' => 'Shallow', 
    'ItemShape' => array('BaseShape' => 'IdOnly'), 
    'ParentFolderIds' => array('DistinguishedFolderId' => array('Id' => 'inbox'))); 
$response = $client->FindItem($param); 
 
// Wybranie pierwszego zaproszenia na spotkanie
$item = $response->ResponseMessages->FindItemResponseMessage->RootFolder 
                 ->Items->MeetingRequest;
$item = $item[0]; 
 
// Pobranie wybranego zaproszenia na spotkanie 
$param = array('ItemShape' => array('BaseShape' => 'Default'), 
    'ItemIds' => array('ItemId' => array('Id' => $item->ItemId->Id, 
                                         'ChangeKey' => $item->ItemId->ChangeKey))); 
$response = $client->GetItem($param); 
$item = $response->ResponseMessages->GetItemResponseMessage->Items->MeetingRequest;
 
// Wywietlenie zaproszenia na spotkanie
$table = array(array('Field', 'value')); 
$table[] = array('Subject', $item->Subject); 
$table[] = array('Start time', $item->Start); 
$table[] = array('End time', $item->End); 
$table[] = array('Location', $item->Location); 
$table[] = array('Organizer', $item->Organizer->Mailbox->Name); 
$table[] = array('ItemID (before): ', splitString($item->ItemId->Id)); 
$table[] = array('CalendarItemID (before): ', splitString($item-
>AssociatedCalendarItemId->Id)); 
$page->addTable($table); 
 
// Wysanie komunikatu zaproszenia
$param = array('MessageDisposition' => 'SendOnly', 
    'Items' => array('DeclineItem' => array( 
            'ReferenceItemId' => array('Id' => $item->ItemId->Id, 
                                       'ChangeKey' => $item->ItemId->ChangeKey), 
            'Body' => array('BodyType' => 'Text', 
                            '_' => 'Musz nakarmi swoje krliki.')))); 
$response = $client->CreateItem($param); 
 
// Wywietlenie odpowiedzi
$page->addElement('h2', 'Komunikat odpowiedzi SOAP'); 
$items = $response->ResponseMessages->CreateItemResponseMessage->Items; 
$table = array(array('Pole', 'Warto')); 
$table[] = array('ItemID (po): ', splitString($items->MeetingRequest->ItemId->Id));
$table[] = array('CalendarItemID (po): ',  
                  splitString($items->CalendarItem->ItemId->Id)); 
$page->addTable($table); 
$page->printPage(); 
 
// Funkcja pomocnicza: wstawia spacj pozwalajc na amanie wierszy
function splitString($str) { 
   return preg_replace('/(.{33})/', '$1  ', $str); 
}
?>
