﻿<?php
//namespace net\xmp\phpbook;
require './DatabaseConnection.php';
require './HTMLPage.php';
require './update_salesorder_db.php';

// Zdefiniowane wyłącznie dla celów przykładu
$updateOrderHeader = 71915;
$updateOrders = array(array(113089, 6, 0.10), array(113090, 1, 0.0),
                      array(113091, 10, 0.20), array(113093, 3, 0.035));
$html = new HTMLPage('AdventureWorks : Zmiana wielkości zamówienia i zniżki');
$db = new DatabaseConnection();
$db->connect();
$orders = new UpdateOrders($db);

// Wczytanie i wyświetlenie danych przed zmianą
$before = $orders->getByHeader($updateOrderHeader);
$html->addHTML('<div style="position:absolute;top:4em">');
$html->addElement('h2', 'Przed zmianą');
$html->addTable($before);

// Przygotwanie zapytania i wykonanie go kilka razy
$orders->prepare();
foreach ($updateOrders as $order) {
    list($id, $qty, $discount) = $order;
    $orders->update($id, $qty, $discount);
}
$orders->free();

// Wczytanie i wyświetlenie danych po zmianie
$after = $orders->getByHeader($updateOrderHeader);
$html->addHTML('</div><div style="position:absolute;top:4em;left:15em">');
$html->addElement('h2', 'Po zmianie');
$html->addTable($after);
$html->addHTML('</div>');
$db->close();
$html->printPage();
?>
