/**
 * Zwraca dodatkowe dane dla UserAccountControl. 
 * @param int $ac Warto UserAccountControl 
 */ 
function accountControl2str($ac) { 
    // Lista kilku znacznikw, nie jest kompletna
    static $flags = array( 
        'ACCOUNTDISABLE' => 0x0002, 
        'LOCKOUT' => 0x0010, 
        'PASSWD_NOTREQD' => 0x0020, 
        'PASSWD_CANT_CHANGE' => 0x0040, 
        'NORMAL_ACCOUNT' => 0x0200, 
        'INTERDOMAIN_TRUST_ACCOUNT' => 0x0800, 
        'WORKSTATION_TRUST_ACCOUNT' => 0x1000, 
        'SERVER_TRUST_ACCOUNT' => 0x2000, 
        'DONT_EXPIRE_PASSWORD' => 0x10000, 
        'PASSWORD_EXPIRED' => 0x800000); 
    $info = array(); 
    foreach ($flags as $name => $value) { 
        if ($ac & $value) { 
            $info[] = $name; 
        } 
    } 
    return dec2hex($ac) . ' (' . join(', ', $info) . ')'; 
}
