/**
 * Konwertuje binarny SID na posta tekstow
 * @param string $sid binarny SID 
 */ 
function sid2str($sid) { 
    $v = unpack('Crev/Ccnt/Sx/Nauth/V*sub', $sid); 
    $str = "S-$v[rev]-$v[auth]"; 
    for ($i = 1; $i <= $v['cnt']; $i++) { 
        $str .= '-' . $v["sub$i"]; 
    } 
    return $str; 
} 
 
/** 
 * Konwertuje cig znakw na binarny SID 
 * @param string $sidstr SID jako cig znakw 
 */ 
function str2sid($sidstr) { 
    $v = explode('-', $sidstr); 
    $cnt = count($v) - 3; 
    $sid = pack('CCSN', $v[1], $cnt, 0, $v[2]); 
    for ($i = 0; $i < $cnt; $i++) { 
        $sid .= pack('V', $v[$i + 3]); 
    } 
    return $sid; 
}
