/**
 * Odczytuje jeden obiekt z wyniku wyszukiwania i formatuje go w celu wywietlenia
 */ 
function listSingleEntry($ad, $result, $class) { 
    $entry = ldap_first_entry($ad->handle, $result); 
    if (!$entry) { 
        $ad->exitWithError('Nieudany odczyt obiektu LDAP.'); 
    } 
    $attr = ldap_get_attributes($ad->handle, $entry); 
    $ef = new LDAPEntryFormatter($attr, $class, 'browse_ldap.php'); 
    $table = $ef->getAttributes(); 
    $title = $class . ': ' . ldap_get_dn($ad->handle, $entry); 
    return array($title, $table); 
} 
?>
