﻿# kodowanie: ASCII-8BIT
#!/usr/bin/env ruby
require 'metasm'
include Metasm

# Tworzy kod x86.
sc = Metasm::Shellcode.assemble(Metasm::Ia32.new, <<EOS)
add eax, 0x1234
mov [eax], 0x1234
ret
EOS

dasm = sc.init_disassembler

# kod procedury deasemblera
dasm.disassemble(0)

# Pobierz odkodowane instrukcje z adresu 0,
# a następnie jej podstawowy blok.
bb = dasm.di_at(0).block

# Wyświetl kod poddany działaniu deasemblera:
puts "\n[+] wygenerowany kod:"
puts bb.list

# Przejrzyj odkodowane instrukcje podstawowego bloku.
bb.list.each{|di|
    puts "\n[+] #{di.instruction}"
    sem = di.backtrace_binding()

    puts " przeplyw danych:"
    sem.each{|key, value| puts "  * #{key} => #{value}"}

    # Czy instrukcja modyfikuje wskaźnik instrukcji?
    if di.opcode.props[:setip]
        puts " przeplyw sterowania:"
        # Następnie wyświetl semantykę przepływu sterowania.
        puts "  * #{dasm.get_xrefs_x(di)}"
    end
}
