# kodowanie: ASCII-8BIT
#!/usr/bin/env ruby

require 'metasm'
include Metasm

$SPAWN_GUI = false
CODE_BASE_ADDR = 0x10000000
HTABLE_BASE_ADDR = 0x18000000
NATIVE_REGS = [:eax, :edx, :ecx, :ebx, :esp, :ebp, :esi, :edi]

def display(bd)
  bd.each{|key,value| puts "  #{Expression[key]} => #{Expression[value]}"}
end

# generuj kod procedury przeznaczony dla architektury x86
sc = Shellcode.assemble(Ia32.new, <<EOS)
mov eax, [edi+0x1C]
mov edx, [edi+0x14]
xor eax, edx
mov [edi+0x1c], eax
add ebp, 0x13C
jmp [#{HTABLE_BASE_ADDR}+ebp*4]
EOS

handler = sc.encode_string

# dodaj sekcj kodu
dasm = sc.init_disassembler
dasm.add_section(EncodedData.new(handler), CODE_BASE_ADDR)

# deasembluj kod procedury
dasm.disassemble_fast_deep(CODE_BASE_ADDR)

if $SPAWN_GUI
  Gui::DasmWindow.new("metasm - symbolic-execution-lvl1", dasm, [CODE_BASE_ADDR])
  dasm.load_plugin('hl_opcode') # hilight jmp/call instrs
  dasm.gui.focus_addr(dasm.gui.curaddr, :graph) # start in graph mode
  Gui.main
end

=begin

Pytanie 1:

Okrel semantyk procedury.

Wskazwki (Metasm):
- Klasa deasemblera: code_binding method

=end

# Okrel semantyk procedury.

puts "\n=== Pytanie 1 ==="


=begin

Pytanie 2:

Podczas rozruchu maszyny wirtualnej, jej kontekst (odwouje si do niego rejestr EDI) jest inicjalizowany za pomoc:
  pushad
  mov edi, esp

Dyspozytor maszyny wirtualnej zapisuje numer nastpnej procedury w rejestrze EBP.

Okrel symboliczne mapowanie kontekstu maszyny wirtualnej i kodu asemblera.

Wskazwki (Metasm):
- Klasa porednioci: Indirection[Expression, size, origin]
- klasa wyraenia: Expression[e1, (op), (e2)],  zwi i zredukuj metody _rec

=end

puts "\n=== Question 2 ==="


=begin

Pytanie 3:

Kontekst maszyny wirtualnej przed uruchomieniem procedury:
context = {
    :nhandler => 0x84,
    virt_eax => 0xffeeffee,
    virt_ecx => 0,
    virt_edx => 0x41414141,
    virt_ebx => 1,
    :virt_edi => :virt_edi,
    :virt_esi => :virt_esi,
}

Okrel efekt uruchomienia procedury.

=end

puts "\n=== Pytanie 3 ==="

