  
var arcanoidGame = {
    canvas       : null,

    blockMarginX : 3,
    blockMarginY : 2,
    minMatrixMarginX: 30,
    minMatrixMarginY: 30,
    blockWidth   : 0,
    blockHeight  : 0,
    blocksAr     : [],
    
    active       : false,
    firstGame    : false,
    keyLock      : true,

    blockOrigin  : null,
    flashLayer   : null,
    interfaceLayer: null,
    interfaceBg: null,
    blockOriginsLayer: null,
    scoreInfoArea : null,
    levelInfoArea : null,
    menuArea      : null,

    cntWidth      : null,
    cntHeight     : null,
    startSpeedGame: 1,
    speedGame     : 0,
    score         : 0,
    level         : 1,
    
    /* Draw game interface */
    drawInterface : function () {
        var cn = this.canvas;

        cn.drawRectangle({fill: "#66CCFF", width: this.cntWidth, height: this.cntHeight});
        cn.setDefaultProp("text", {fill: "#FFF", size: 11, family: "Arial", weight: "bold", top: 16, left: 10});

        var bgRadius = 10, bgStrokeWidth = 5,
        _interface = cn.inject([
            {elem: "layer", ref: "interfaceLayer", attrs: {display: "inline"}, code: [
                {elem: "rectangle", ref: "bg", attrs: {fill: "#6d6d6d", left: bgStrokeWidth/2, top: bgStrokeWidth/2, width: this.cntWidth-bgStrokeWidth, height: this.cntHeight-bgStrokeWidth, radiusX: bgRadius, stroke: "#000", strokeWidth: bgStrokeWidth}},
                {elem: "layer", ref: "blockOriginsLayer"},                
                {elem: "layer", ref: "leftCornerLayer", code:[
                    {elem: "path", attrs: {fill: "#000", data: "M 0 25 L 0 10 A 10 10 0 0 1 10 0 L 100 0 L 100 15 A 10 10 0 0 1 90 25 Z"}},
                    {elem: "text", txt: "Score: "},
                    {elem: "text", txt: this.score.toString(), ref: "scoreInfoArea", attrs: {left:65}}
                    ]},
                {elem: "layer", ref: "rightCornerLayer", beforeInject: function() {cn.translate(this, arcanoidGame.cntWidth-100)}, code:[
                    {elem:"path", attrs: {fill: "#000",data: "m 100,25 0,-15 A 10,10 0 0 0 90,0 L 0,0 0,15 a 10,10 0 0 0 10,10 z"}},
                    {elem:"text", txt: "Level: "},
                    {elem:"text", txt: this.level.toString(), ref: "levelInfoArea", attrs: {left: 65}}
                    ]}
                ]
            }]);
        /* References */
        this.interfaceLayer    = _interface.interfaceLayer;
        this.levelInfoArea     = _interface.levelInfoArea;
        this.scoreInfoArea     = _interface.scoreInfoArea;
        this.blockOriginsLayer = _interface.blockOriginsLayer;
        this.interfaceBg       = _interface.bg;
        /* Tiled */
        var tiledLayer = cn.addLayer(this.interfaceLayer), tile, tileHeight = Math.sqrt(this.cntWidth * this.cntWidth + this.cntHeight * this.cntHeight) * 1.5;
        for(var i = 0; i < 7; i++) {
            cn.rotate(
                cn.drawPath({data: "M 0 " + tileHeight + " L 0 0 L 100 0 Z", fill: "black", opacity: .1}, tiledLayer),
                i * 15, "left-bottom");
            };
        cn.clip(tiledLayer, cn.addClipPath(cn.drawRectangle({left: 0, top: tileHeight - this.cntHeight, width: this.cntWidth, height: this.cntHeight, radiusX: 10, strokeWidth: 5})));
        cn.translate(tiledLayer, 0, - (tileHeight - this.cntHeight));        
        cn.lowerToBottom(tiledLayer);
        cn.raiseOneStep(tiledLayer);
        /* Block origin */
        var grd = cn.createLinearGradient({
            y2: 1, x2: 0, x1: 0, y1: 0, colors:[
                {"color":"white",offset:"0"},
                {"color":"white",offset:"1","opacity":"0"}
                ]}),
            w = 50, h = 18;
        var org = cn.inject([
            {elem: "layer", ref: "originLayer", attrs: {display: "inline"}, code:[
                {elem: "rectangle", ref: "rect1", attrs: {radiusX:5,width:w,height:h,stroke:"#000",strokeWidth:0.3}},
                {elem: "rectangle", ref: "rect2", attrs: {fill:grd,radiusX:2,width:w/1.1,height:h/2.3}}           
                ]}
            ]);
        
        cn.align(org.rect2, org.rect1, "center-top", 0, 1);
        cn.scale(org.originLayer, this.blockWidth/w, this.blockHeight/h, "left-top");
        this.blockOrigin = cn.addOrigin(org.originLayer);
        /* Block flash */
        var flashLayer = cn.addLayer(),
            flashMask  = cn.drawRectangle({left: 0, top: 0, radiusX: 5, width: w, height: h, strokeWidth: 0, fill: "none"}),         
            flash;
            
        flashMask = cn.scale(flashMask, this.blockWidth/w, this.blockHeight/h, "left-top");    
        flashBg = flashMask.cloneNode(false);
        flashLayer.appendChild(flashBg);
        flash = cn.drawPath({data: "M 50 0 l 20 0 l -50 50 l -20 0 Z", opacity: 0.7, strokeWidth: 0, fill: "#FFF"}, flashLayer);
        cn.translate(flash, -70, 0);
        cn.clip(flashLayer, cn.addClipPath(flashMask));
        this.flashLayer = flashLayer;
        },
    /* Draw menu */
    menu: {
        menuRefLayer: null,//referencja do warstwy z menu
        infoRef : null,//referencja do wiersza komunikatu
        menuBg : null, //podkład
        
        lockEvent  : false,
        timerTime: 3,//[s]
        defaultInfo: "Click to start game",
        init: function() {
            var ag = arcanoidGame,
            code = ag.canvas.inject([
                {elem: "layer", ref: "menuRefLayer", attrs:{"display":"inline"}, code:[
                    {elem: "rectangle", ref: "menuBg", attrs: {width: "100%", height: 150, fill: "white", "fill-opacity": 0.1, "stroke-opacity": 0.5, stroke: "white", strokeWidth: 1, left: 0, top: 0}},                    
                    {elem: "text", ref: "keyInfo", txt: "click the left arrow to move the pallete to the left or right arrow to move the pallete to the right", attrs: {left: 0, top: 0, weight: "bold"}},                    
                    {elem: "text", ref: "infoRef", txt: "", attrs: {x: 0, y: 0, fill: "#FFF", size: 25, family: "Verdana", cursor: "default"}}
                    ]}                  
                ], arcanoidGame.interfaceLayer);
            
            this.menuRefLayer = code.menuRefLayer;
            this.infoRef  = code.infoRef;
            this.menuBg = code.menuBg;
      
            ag.canvas.align(code.keyInfo, code.menuBg, "center-top", 0, 20);
            ag.canvas.align(this.menuRefLayer, arcanoidGame.interfaceBg, "center");
            
            this.infoRef.addEventListener("click", function() {
                if(arcanoidGame.menu.lockEvent)
                    return;
                arcanoidGame.menu.timer();
                }, false);
            this.show("NEW GAME");
            },
        showInfo: function(value) {
            this.infoRef.textContent = (value != undefined)? value : "";
            arcanoidGame.canvas.align(this.infoRef, this.menuBg, "center"); 
            },
        show: function(mode) {
            arcanoidGame.keyLock = true;
            this.menuRefLayer.setAttribute("display", "block");
            switch(mode) {
                case "NEXT LEVEL": {//NEXT LEVEL
                    this.showInfo("Level: " + arcanoidGame.level);
                    setTimeout(function() {arcanoidGame.menu.timer()}, this.timerTime*1000);
                    break;
                    }
                case "GAME OVER": {//GAME OVER
                    this.showInfo("Game Over !");
                    setTimeout(function() {arcanoidGame.menu.show()}, this.timerTime*1000);
                    break;
                    }
                default: {//NEW GAME
                    this.lockEvent = false;
                    this.showInfo("Click to start the game");
                    }                    
                };
            },
        hide: function() {
            this.menuRefLayer.setAttribute("display", "none");
            },
        timer: function()  {
            this.lockEvent = true;
            if(arcanoidGame.firstGame) {
                arcanoidGame.gameInit();
                };
            var i = 3, _this_ = this,
                fn = function() {
                _this_.showInfo((i >= 0)? i : "Ready !");
                if(--i === -3) {
                    clearInterval(anch);
                    arcanoidGame.startGame();
                    arcanoidGame.keyLock = false;
                    return;
                    };
                };
            var anch = setInterval(fn, 1000);
            }
        },
    /* Tworzenie ukladu blokow. Kazdy blok jest obiektem o ustalonych wlasciwosciach i metodach */
    Block: function(x, y, blockStrength) {
        var colors = ["#00bfff", "#ffd700", "#9400d3", "#ff8c00", "#0000ff", "#ff0000", "#228b22"];
        this.width  = arcanoidGame.blockWidth;
        this.height = arcanoidGame.blockHeight;
        this.x = x;
        this.y = y;
        this.opacity = 1;
        this.unlinked = false;
        this.blockStrength = blockStrength || 1;
        this.flashAnimActive = false;
        this.ref = arcanoidGame.canvas.useOrigin(
            arcanoidGame.blockOrigin,
            {left:x, top:y, fill:colors[Math.round(Math.random()*(colors.length-1))]},
            arcanoidGame.blockOriginsLayer
            );

        this.blockCollision = function() {
            if(!--this.blockStrength) {
                this.unlink();
                arcanoidGame.setScoreInfo(arcanoidGame.score + 1);
                if(!arcanoidGame.blocksAr.length)
                    arcanoidGame.nextLevel();
                }
            else{
                this.flashAnim();
                };
            };
        //this.unlink = function() {
        //    arcanoidGame.canvas.destroy(this.ref);
        //    for(var i in arcanoidGame.blocksAr) {
        //        if(this === arcanoidGame.blocksAr[i])
        //            break;
        //        };
        //    arcanoidGame.blocksAr.splice(i, 1);
        //    return;
        //    };
        this.unlink = function() {
            for(var i in arcanoidGame.blocksAr) {
                if(this === arcanoidGame.blocksAr[i])
                    break;
                };
            arcanoidGame.blocksAr.splice(i, 1);
            this.unlinked = true;
            if(!this.flashAnimActive)
                this.animateHide();
            return;
            };            
        this.flashAnim = (function() {
            
            var ag = arcanoidGame, fl, totalTx = 0, path, maxTx, anim, flashAnch, _this_;
                
            return function() {
                
                if(this.flashAnimActive)
                    return;
                this.flashAnimActive = true;
                
                fl = ag.flashLayer.cloneNode(true);
                
                ag.canvas.translate(fl, this.x, this.y);
                ag.blockOriginsLayer.appendChild(fl);
                
                _this_ = this;
                totalTx = 0;
                path = fl.getElementsByTagName("path")[0];
                maxTx = fl.getBBox().width + path.getBBox().width;      
                anim = function() {
                    totalTx += 8;
                    if(totalTx >= maxTx) {
                        ag.canvas.destroy(fl);
                        ag.runGame.unlinkDrawFn(flashAnch);
                        if(_this_.unlinked) {
                            _this_.animateHide();
                            }
                        else{
                            _this_.flashAnimActive = false;
                            };
                        return;
                        };
                    ag.canvas.translate(path, 8, 0);            
                    };
                flashAnch = ag.runGame.setDrawFn(function() {anim()});
                
            }})();
        this.animate = function() {
            var op = this.opacity - 0.07;
            if(op <= 0) {
                arcanoidGame.canvas.destroy(this.ref);
                delete this.ref;
                arcanoidGame.runGame.unlinkDrawFn(this.anch);
                return;
                };
            this.opacity = op;
            this.ref.setAttribute("opacity", this.opacity);            
            };
        this.animateHide = function() {
            this.anch = arcanoidGame.runGame.setDrawFn((function(th) {
                return function() {th.animate()};
                })(this));
            };
        },
    /* Create blocks matrix */
     createMatrix: function() {

        if(this.blocksAr.length) {//jesli kolejna gra nalezy wyczyscic tablice i pousuwac bloki
            while(this.blocksAr.length) {
                this.blocksAr[0].unlink();
                };
            };

        var maxRowsAreaHeight = this.cntHeight * 2/3, i = 0, posY,
            blocksPerRow = Math.floor((this.cntWidth - 2*this.minMatrixMarginX - this.blockMarginX)/(this.blockWidth + this.blockMarginX)),
            matrixMarginX = (this.blockMarginX + this.cntWidth - (blocksPerRow * (this.blockWidth + this.blockMarginX)))/2;

        var proposedRowsLen = 3 + Math.floor(this.level/15 * 10),
            blockID;
        function loop() {
        for(var y=0; y<proposedRowsLen; y++) {
                for(var x=0; x<blocksPerRow; x++) {
                    posY = this.minMatrixMarginY + y * (this.blockHeight + this.blockMarginY);
                        
                    if(posY > maxRowsAreaHeight)
                        return;
                       
                    this.blocksAr.push(new this.Block(
                        matrixMarginX + x * (this.blockWidth + this.blockMarginX),
                        posY,
                        Math.round(Math.random() * this.level/1.5)
                        ));
                    };
                };
            };
        loop.call(this);
        return;
        },
    /* Create and initialize game pallete */
    pallete: {
        startWidth: 0,
        minWidth: 40,
        actualWidth: 0,
        height: 16,
        margin: 7,
        minX: 0,
        maxX: 0,
        x: 0,
        y: 0,
        ref: null,
        movingLeft : null,
        movingRight: null,
        speed: 1.3,//[cntWidth/s]
        kAnchor: null,
        activeKey: null,
        kFn: function() {},
        setPosition: function(x) {
            if(x < this.minX) {
                x = this.minX;
                }
            else if(x > this.maxX) {
                x = this.maxX;
                };
            if(x < this.x) {
                //this.movingLeft = true;
            }else if(x > this.x) {
                //this.movingRight = true;
                };
            this.x = x;
            this.ref.setAttribute("x", this.x);
            },
        k: function(evt, mode) {
            var _this_ = this,
                clearK = function() {
                    _this_.activeKey = _this_.movingLeft = _this_.movingRight = null;
                    _this_.kFn = function() {};
                    };
            if(evt.keyCode != 39 && evt.keyCode != 37) {
                return
                }
            else{
                evt.preventDefault();
                if(arcanoidGame.keyLock) {
                    clearK();
                    return;
                    };                
                };

            if(!mode) {
                clearK();
                }
            else{
                if(this.activeKey == evt.keyCode) {
                    return;
                    }
                else{
                    clearK();
                    this.activeKey = evt.keyCode;
                    if(evt.keyCode == 39) {
                        this.kFn = function(t) {arcanoidGame.pallete.moveLeft(t)};
                        }
                    else{
                        this.kFn = function(t) {arcanoidGame.pallete.moveRight(t)};
                        };
                    };
                };
            return;
            },
        moveLeft: function(t) {
            this.movingLeft = true;
            this.setPosition(this.x + (this.speed * arcanoidGame.speedGame) * t/1000);
            },
        moveRight: function(t) {
            this.movingRight = true;
            this.setPosition(this.x - (this.speed * arcanoidGame.speedGame) * t/1000);
            },
        resetPosition: function() {
            this.kFn = function() {};
            this.setPosition((arcanoidGame.cntWidth - this.actualWidth)/2);
            },
        changeSize: function(decreaseSize/*[%]*/) {
            if(decreaseSize) {
                var w = this.actualWidth + (this.startWidth * (decreaseSize/100));
                w = (w >= this.minWidth)? w : this.actualWidth; 
                }
            else
                var w = this.startWidth;
            this.ref.setAttribute("width", w);
            this.maxX += this.actualWidth - w;
            this.actualWidth = w;
            },
        init: function() {
            
            this.startWidth = this.actualWidth = Math.round(arcanoidGame.cntWidth * 0.2);
            this.y = arcanoidGame.cntHeight - this.height - this.margin;         
  
            this.ref = arcanoidGame.canvas.drawRectangle({
                width : this.actualWidth,
                height: this.height,
                fill: "#b8b8b8",
                radiusX: 5,
                strokeWidth: 0.3,
                stroke:"#000",
                left: 0,
                top : this.y
                }, arcanoidGame.interfaceLayer);

            this.minX = this.margin;
            this.maxX = arcanoidGame.cntWidth - this.actualWidth - this.margin;
            this.resetPosition();
            
            this.speed *= this.maxX;//[px/s]
            this.kAnchor = arcanoidGame.runGame.setDrawFn(function(t) {arcanoidGame.pallete.kFn(t)});
            
            window.addEventListener("keyup", function(evt) {arcanoidGame.pallete.k(evt, 0)});
            window.addEventListener("keydown", function(evt) {arcanoidGame.pallete.k(evt, 1)});
            }
        },
    /* Master game loop */
    runGame: {
        anch: null,
        FPSLimit: 50,
        loopLastTime: 0,
        frameLastTime: 0,
        loopLastTimeDif: 0,
        frameLastTimeDiff: 0,
        timeNextFrame: 0,
        frameLength: 0,
        active: false,
        refreshFnObj: {},
        drawFnObj: {},
        FnLength: 0,
        executeFn: function(FnObj, mode) {
            for(var i in FnObj)
                try{
                    FnObj[i]((mode)? this.frameLastTimeDiff : this.loopLastTimeDif);
                    }
                catch(err) {};            
            },
        setRefreshFn: function(Fn) {
            this.refreshFnObj[this.FnLength] = Fn;
            return this.FnLength++;
            },
        unlinkRefreshFn: function(FnID) {
            try{delete this.refreshFnObj[FnID]} catch(err) {};
            },            
        refresh: function() {
            this.executeFn(this.refreshFnObj, 0);
            },
        setDrawFn: function(Fn) {
            this.drawFnObj[this.FnLength] = Fn;
            return this.FnLength++;
            },
        unlinkDrawFn: function(FnID) {
            try{delete this.drawFnObj[FnID]} catch(err) {};
            },
        draw: function() {
            this.refresh();
            this.executeFn(this.drawFnObj, 1);
            },
        startGameLoop: function() {
            if(this.active)
                return;
            else{
                this.active = true;
                this.frameLength = 1000/this.FPSLimit;
                this.loopLastTime = this.frameLastTime = new Date().getTime();
                this.timeNextFrame = this.loopLastTime + this.frameLength;                
                };
            var _this_ = this, actualTime, Fn = function() {
                
                actualTime = new Date().getTime();
                _this_.loopLastTimeDif = actualTime - _this_.loopLastTime;
                _this_.loopLastTime = actualTime;
                
                if(actualTime >= _this_.timeNextFrame) {
                    _this_.timeNextFrame += _this_.frameLength;
                    _this_.frameLastTimeDiff = actualTime - _this_.frameLastTime;
                    _this_.frameLastTime = actualTime;
                    _this_.draw();
                    }
                else{
                    _this_.refresh();
                    };
                _this_.anch = setTimeout(Fn, 10);
                };
            Fn();
            },
        },
    /* Create and initialize ball */
    ball: {
        radius: 10,
        x: 0,
        y: 0,
        startX: 0,
        startY: 0,
        vectorLength: 300,//[px/s]
        vx: 0,
        vy: 0,
        ref: null,
        drawAnchor: null,
        refreshAnchor: null,
        checkCollision: function(x, y) {

            var collisionBlock = null, checkResult = "NO COLLISION", bl, blw, blh;
            var getReturnedObj = function() {
                return {"collisionBlock": collisionBlock, "checkResult": checkResult};
                };

            /* Check collision in the pallete */
            var plt = arcanoidGame.pallete;
            if(y + this.radius > plt.y && (x > 0 && x < arcanoidGame.cntWidth - this.radius)) {
                if(x + this.radius < plt.x || x - this.radius > plt.x + plt.actualWidth) {
                    checkResult = "UNDER PALLETE";
                    return getReturnedObj();
                    };
                this.vy = -this.vy;                
                checkResult = "COLLISION";                         

                if(plt.movingLeft || plt.movingRight) {
                    var dif = Math.abs((this.x - (plt.x + (plt.actualWidth/2)))/(plt.actualWidth/2));
                    var _vx = (plt.movingLeft)? ((this.vx < 0)? dif : -dif) : ((this.vx > 0)? dif : -dif);
                    _vx *= arcanoidGame.speedGame * this.vectorLength;
                    if(Math.abs(this.vx + _vx) < arcanoidGame.speedGame * this.vectorLength) {
                        this.vx += _vx;
                        };
                    };
                return getReturnedObj();
                };

            /* Check collision in the wall */
            if(x-this.radius < 0 || x+this.radius > arcanoidGame.cntWidth) {
                this.vx = -this.vx;
                checkResult = "COLLISION";
                return getReturnedObj();
                };
            if(y-this.radius < 0 || y+this.radius > arcanoidGame.cntHeight) {
                this.vy = -this.vy;
                checkResult = "COLLISION";
                return getReturnedObj();
                };
                                                                
            /* Check collision in the block */
            for(var i in arcanoidGame.blocksAr) {

                bl  = arcanoidGame.blocksAr[i];
                blw = bl.width;
                blh = bl.height;

                if(!((x + this.radius >= bl.x) && (x - this.radius <= bl.x + blw)))
                    continue;
                if(!((y + this.radius >= bl.y) && (y - this.radius <= bl.y + blh)))
                    continue;

                collisionBlock = bl;
                checkResult = "BLOCK";

                if((this.x + this.radius <= bl.x) || (this.x - this.radius  >= bl.x + blw)) {
                    this.vx = -this.vx;
                    break;
                    };
                this.vy = -this.vy;
                break;
                };
            return getReturnedObj();
            },
        setPosition: function() {
            this.ref.setAttribute("cx", this.x);
            this.ref.setAttribute("cy", this.y);
            },
        move: function(timeDif/*[ms]*/) {
       
            //timeDif = (timeDif)? timeDif/1000 : 1;                               
            var x = this.x + this.vx * 0.015,// * timeDif,
                y = this.y + this.vy * 0.015,// * timeDif,
                check;          

            check = this.checkCollision(x, y);
            switch(check.checkResult) {
                case "UNDER PALLETE": {
                    arcanoidGame.stopGame();
                    break;
                    }
                case "BLOCK": {
                    check["collisionBlock"].blockCollision();
                    }
                case "COLLISION": {
                    break;
                    }
                case "NO COLLISION": {
                    this.x = x;
                    this.y = y;
                    break;
                    }                    
                default: {
                    
                    }
                };
            return;
            },
        hide: function() {
            this.ref.style.opacity = 0;
            },
        show: function(){
            this.ref.style.opacity = 1;
            },
        stopAnimate: function() {
            arcanoidGame.runGame.unlinkDrawFn(this.drawAnchor);
            arcanoidGame.runGame.unlinkRefreshFn(this.refreshAnchor);            
            },
        startAnimate: function() {
            this.drawAnchor = arcanoidGame.runGame.setDrawFn(function() {arcanoidGame.ball.setPosition()});
            this.refreshAnchor = arcanoidGame.runGame.setRefreshFn(function(t) {arcanoidGame.ball.move(t)});
            },
        reset: function() {
            var getRandom = function(min, max) {
                return min + Math.random() * (max - min);
                };
            this.x = this.startX;
            this.y = this.startY;
            this.setPosition();
            
            var maxVectorLength = arcanoidGame.speedGame * this.vectorLength;
            this.vx = getRandom(maxVectorLength/5, maxVectorLength/2) * ((getRandom(-1, 1) < 0)? -1 : 1);
            this.vy = Math.sqrt(Math.pow(maxVectorLength, 2) - Math.pow(this.vx, 2));
                                      
            this.show();
            },
        init: function() {
            this.ref = arcanoidGame.canvas.drawCircle({
                fill:"#FFF",
                left: 0,
                top : 0,
                radius: this.radius,
                strokeWidth:0,
                opacity: 0,
                }, arcanoidGame.blockOriginsLayer);
            this.startX = arcanoidGame.cntWidth/2;
            this.startY = arcanoidGame.cntHeight - this.radius - arcanoidGame.pallete.height - arcanoidGame.pallete.margin;
            }
        },
    /* Refresh info about phase and game score */    
    setScoreInfo: function(v) {
        this.score = v;
        this.scoreInfoArea.textContent = v.toString();
        },
    setLevelInfo: function(v) {
        this.level = v;
        this.levelInfoArea.textContent = v.toString();
        },
    /* Initialize new game (first level) */
    gameInit: function() {
        this.setLevelInfo(1);
        this.setScoreInfo(0);
        this.speedGame = this.startSpeedGame;
        this.pallete.changeSize();
        this.pallete.resetPosition();
        this.createMatrix();
        this.ball.reset();
        this.firstGame = false;
        },
    /* Play in the new level of the game */
    nextLevel: function() {                        
        this.speedGame += this.startSpeedGame * 0.15;
        this.setLevelInfo(this.level+1);
        
        this.pallete.changeSize(-5);
        this.pallete.resetPosition();        
        
        this.ball.stopAnimate();
        this.ball.reset();
        this.createMatrix();
        this.menu.show("NEXT LEVEL");
        },
    /* Start game (first and next level) */
    startGame: function() {
        this.menu.hide();
        this.ball.startAnimate();
        },
    /* Stop the game (game over) */
    stopGame: function() {
        this.ball.stopAnimate();
        this.ball.hide();
        this.firstGame = true;
        this.menu.show("GAME OVER");
        },
    /* Initialize the game */
    init: function(cntID){
        var el;
        if(cntID) {//HTML document
            el = document.getElementById(cntID);
            this.cntWidth    = 600;//el.clientWidth;
            this.cntHeight   = 500;//el.clientHeight;
            this.canvas      = new SVGDraw(el, "100%", "100%", "0 0 600 500"); 
            }
        else{//SVG document
            this.canvas      = new SVGDraw(null, "100%", "100%", "0 0 600 500");
            this.cntWidth    = 600;
            this.cntHeight   = 500;           
            };
            
        this.blockWidth  = 60;
        this.blockHeight = 17;

        this.drawInterface();
        this.pallete.init();
        this.ball.init();
        this.menu.init();
        this.gameInit();
        
        this.runGame.startGameLoop();

        }
    };
