import hashlib, os
from binascii import hexlify
from r09_diffiehellman import DiffieHellman


if __name__ == "__main__":
    """
    Test implementacji protokołu Diffiego-Hellmana.
    """

    def exchageTest (generator, group, keyLenght, testLenght = 50):
        misses = 0

        for i in range(0,testLenght):
            alice = DiffieHellman(generator, group, keyLenght)
            bob = DiffieHellman(generator, group, keyLenght)

            alice.generateSharedKey(bob.publicKey)
            bob.generateSharedKey(alice.publicKey)

            print("============= WYNIKI WYMIANY:", i, "o długości", testLenght)
            if (alice.getSharedKey() == bob.getSharedKey()):
                print("Współdzielone klucze są takie same!!!")
            else:
                print("Współdzielone klucze są różne...")
                misses+= 1

        print("\n>>>>> CAŁKOWITE NIEDOPASOWANIE:", misses, "\n")

    
    alice = DiffieHellman(2,17,1024)
    bob = DiffieHellman(2,17,1024)

    
    alice.generateSharedKey(bob.publicKey)
    bob.generateSharedKey(alice.publicKey)

    print("\n============= ALICJA:\n")
    alice.displayParameters()
    alice.displayShared()
    print("\n")
    
    print("\n============= BOB:\n")
    bob.displayParameters()
    bob.displayShared()
    print("\n")

    print("============= WYNIKI WYMIANY:")
    if (alice.getSharedKey() == bob.getSharedKey()):
        print("Współdzielone klucze są takie same!!!")
        print("Klucz:", hexlify(alice.key))
    else:
        print("Współdzielone klucze są różne...")
        print("\nWspółdzielony klucz u Alicji:", alice.generateSharedSecret(alice.privateKey,bob.publicKey))
        print("\nWspółdzielony klucz u Boba:", bob.generateSharedSecret(bob.privateKey,alice.publicKey))
    print("\n")

