# Wysyłanie wiadomości
import hashlib, random, os, time
from binascii import hexlify
from socket import *
import r09_telnet as ct


def get_dh_sharedsecret():
    return
    
def get_dh_sharedkey():
    return
   
def encrypt(plaintext, usePKI, useDH, clientSecret):
    msg = ct.encrypt(plaintext, usePKI, useDH, clientSecret)
    return msg

def main():
    host = "127.0.0.1" # Adres IP serwera
    port = 8080
    addr = (host, port)
    UDPSock = socket(AF_INET, SOCK_DGRAM)

    # Zmienne sterujące szyfrowaniem
    sendUsingPrivate = False
    sendUsingDH = False
    skipEncryption = False
    
    # Pobieranie współdzielonego klucza; klucz jest w użyciu tylko wtedy, gdy opcja dh jest włączona
    clientSecret = get_dh_sharedkey()
    
    print("Witaj w naszym czacie! \n")
    print()
   
    # Pętla wysyłająca 
    while True:
        if sendUsingPrivate == True or sendUsingDH == True:
            data = str(input("Wprowadź wiadomość do bezpiecznego wysłania lub wyjdź poprzez wpisanie 'exit': ")).encode()
        else:
            data = str(input("Wprowadź wiadomość do wysłania lub wyjdź poprzez wpisanie 'exit': ")).encode()
        
        # Sprawdzenie, czy użytkownik nie wpisał jakiegoś polecenia
        result = ct.check_client_command(data)
        # Obsługa poleceń
        if data == b'exit':
            break
        if result == 0:
            break

        ciphertext = encrypt(data, sendUsingPrivate, sendUsingDH, clientSecret)
        if skipEncryption:
            ciphertext = data
            skipEncryption = False

        # Wysłanie wiadomości przez gniazdo UDP
        UDPSock.sendto(ciphertext, addr)

    # Zamknięcie połączenia UDP
    UDPSock.close()
    os._exit(0)

if __name__ == '__main__': 
    main() 


