import binascii

def crand(seed):
    r=[]
    r.append(seed)
    for i in range(30):
        r.append((16807*r[-1]) % 2147483647)
        if r[-1] < 0:
            r[-1] += 2147483647
    for i in range(31, 34):
        r.append(r[len(r)-31])
    for i in range(34, 344):
        r.append((r[len(r)-31] + r[len(r)-3]) % 2**32)
    while True:
        next = r[len(r)-31]+r[len(r)-3] % 2**32
        r.append(next)
        yield (next >> 1 if next < 2**32 else (next % 2**32) >> 1)

mygen = crand(54321)
rands = [next(mygen) for i in range(4)]
#[60209456, 357898661, 257185675, 1235229180]

ciphertext = b'546f207065776e6120626172647a6f2074616a6ef799473c78c13b3ae4d37add'
hexkey = "".join(map(lambda x: format(x, 'x')[-6:], rands))
plain_as_int = int(ciphertext, 16) ^ int(hexkey, 16)
plain_as_hex = format(plain_as_int, 'x')
plaintext = binascii.unhexlify(plain_as_hex)

print(ciphertext)
print(plain_as_int)
print(plain_as_hex)
print(plaintext)



