import urllib.request, ssl

# Pobieranie tekstu deklaracji
response = urllib.request.urlopen("https://raw.githubusercontent.com/noidentity29/AppliedCryptoPython/master/declaration.txt", context=ssl._create_unverified_context())
originalText = response.read()

# Usuwanie wszystkich niealfanumerycznych znaków
# Można to zrobić na wiele sposobów, ale najprostszy jest ten:


modifiedText = str(originalText.strip())
modifiedText = modifiedText.replace(" ", "")
modifiedText = " ".join(modifiedText.split())
modifiedText = modifiedText.lower()

plaintext = ""
for c in modifiedText:
    if (c.isalpha()):
        plaintext = plaintext + c


# Analiza częstości tekstu w postaci jawnej
frequency = {}
for ascii in range(ord('a'), ord('a')+26):
    frequency[chr(ascii)] = float(plaintext.count(chr(ascii)))/len(plaintext)

sum_freqs_squared = 0.0
for ltr in frequency:
    sum_freqs_squared += frequency[ltr]*frequency[ltr]

# Wyniki
print()
print("Jeżeli tekst napisano w języku angielskim, to suma kwadratów częstości powinna wynosić około 0.065: " + str(sum_freqs_squared))

