# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2026-01-29T08:15:39+00:00
#
# https://pypi.org/project/datamodel-code-generator/
#
#pip install datamodel-code-generator
#curl https://api-test.ksef.mf.gov.pl/docs/v2/openapi.json
# datamodel-codegen \
#  --output-model-type pydantic_v2.BaseModel \
#  --input openapi.json \
#  --input-file-type openapi \
#  --output models.py \
#  --use-generic-container-types \
#  --collapse-root-models
#
# zmiana po wygenerowaniu:
# w miejsce:
#         extra='forbid',
# wstawiam:
#        populate_by_name=True,
#        extra='ignore',

from __future__ import annotations

from datetime import date
from enum import Enum
from typing import Mapping, Optional, Sequence

from pydantic import (
    AnyUrl,
    AwareDatetime,
    BaseModel,
    ConfigDict,
    Field,
    RootModel,
    conint,
    constr,
)


class AllowedIps(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    ip4Addresses: Optional[
        Sequence[constr(pattern=r'^((25[0-5]|(2[0-4]|1\d|[1-9]|)\d)\.?\b){4}$')]
    ] = Field(
        None,
        description='Lista adresów IPv4 w notacji dziesiętnej kropkowanej, np. `192.168.0.10`.',
    )
    ip4Ranges: Optional[
        Sequence[
            constr(
                pattern=r'^((25[0-5]|(2[0-4]|1\d|[1-9]|)\d)\.?\b){4}-((25[0-5]|(2[0-4]|1\d|[1-9]|)\d)\.?\b){4}$'
            )
        ]
    ] = Field(
        None,
        description='Lista adresów IPv4 podana w formie zakresu początek–koniec, oddzielonego pojedynczym myślnikiem, np. `10.0.0.1–10.0.0.254`.',
    )
    ip4Masks: Optional[
        Sequence[
            constr(
                pattern=r'^((25[0-5]|(2[0-4]|1\d|[1-9]|)\d)\.?\b){4}\/(0|[1-9]|1[0-9]|2[0-9]|3[0-2])$'
            )
        ]
    ] = Field(
        None, description='Lista adresów IPv4 w notacji CIDR, np. `172.16.0.0/16`.'
    )


class AmountType(str,Enum):
    Brutto = 'Brutto'
    Netto = 'Netto'
    Vat = 'Vat'


class ApiRateLimitValuesOverride(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    perSecond: int = Field(..., description='Limit na sekundę.')
    perMinute: int = Field(..., description='Limit na minutę.')
    perHour: int = Field(..., description='Limit na godzinę.')


class ApiRateLimitsOverride(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    onlineSession: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla otwierania/zamykania sesji interaktywnych.'
    )
    batchSession: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla otwierania/zamykania sesji wsadowych.'
    )
    invoiceSend: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla wysyłki faktur.'
    )
    invoiceStatus: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla pobierania statusu faktury z sesji.'
    )
    sessionList: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla pobierania listy sesji.'
    )
    sessionInvoiceList: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla pobierania listy faktur w sesji.'
    )
    sessionMisc: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla pozostałych operacji w ramach sesji.'
    )
    invoiceMetadata: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla pobierania metadanych faktur.'
    )
    invoiceExport: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla eksportu paczki faktur.'
    )
    invoiceExportStatus: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla pobierania statusu eksportu paczki faktur.'
    )
    invoiceDownload: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla pobierania faktur po numerze KSeF.'
    )
    other: ApiRateLimitValuesOverride = Field(
        ..., description='Limity dla pozostałych operacji API.'
    )


class AuthenticationContextIdentifierType(str,Enum):
    Nip = 'Nip'
    InternalId = 'InternalId'
    NipVatUe = 'NipVatUe'
    PeppolId = 'PeppolId'


class AuthenticationMethod(str,Enum):
    Token = 'Token'
    TrustedProfile = 'TrustedProfile'
    InternalCertificate = 'InternalCertificate'
    QualifiedSignature = 'QualifiedSignature'
    QualifiedSeal = 'QualifiedSeal'
    PersonalSignature = 'PersonalSignature'
    PeppolSignature = 'PeppolSignature'


class AuthenticationTokenStatus(str,Enum):
    Pending = 'Pending'
    Active = 'Active'
    Revoking = 'Revoking'
    Revoked = 'Revoked'
    Failed = 'Failed'


class AuthorizationPolicy(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    allowedIps: Optional[AllowedIps] = Field(
        None, description='Lista dozwolonych adresów IP.'
    )


class BatchSessionContextLimitsOverride(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    maxInvoiceSizeInMB: conint(ge=0, le=5) = Field(
        ..., description='Maksymalny rozmiar faktury w MB.'
    )
    maxInvoiceWithAttachmentSizeInMB: conint(ge=0, le=10) = Field(
        ..., description='Maksymalny rozmiar faktury z załącznikiem w MB.'
    )
    maxInvoices: conint(ge=0, le=100000) = Field(
        ...,
        description='Maksymalna ilość faktur które można przesłać w pojedynczej sesji.',
    )


class BatchSessionEffectiveContextLimits(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    maxInvoiceSizeInMB: conint(ge=0) = Field(
        ..., description='Maksymalny rozmiar faktury w MB.'
    )
    maxInvoiceWithAttachmentSizeInMB: conint(ge=0) = Field(
        ..., description='Maksymalny rozmiar faktury z załącznikiem w MB.'
    )
    maxInvoices: conint(ge=0) = Field(
        ...,
        description='Maksymalna ilość faktur które można przesłać w pojedynczej sesji.',
    )


class BuyerIdentifierType(str,Enum):
    Nip = 'Nip'
    VatUe = 'VatUe'
    Other = 'Other'
    None_ = 'None'


class CertificateEffectiveSubjectLimits(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    maxCertificates: Optional[int] = None


class CertificateEnrollmentDataResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    commonName: str = Field(..., description='Nazwa powszechna.')
    countryName: str = Field(..., description='Kraj, kod ISO 3166.')
    givenName: Optional[str] = Field(None, description='Imię.')
    surname: Optional[str] = Field(None, description='Nazwisko.')
    serialNumber: Optional[str] = Field(None, description='Numer seryjny podmiotu.')
    uniqueIdentifier: Optional[str] = Field(None, description='Unikalny identyfikator.')
    organizationName: Optional[str] = Field(None, description='Nazwa organizacji.')
    organizationIdentifier: Optional[str] = Field(
        None, description='Identyfikator organizacji.'
    )


class CertificateLimit(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    remaining: int = Field(..., description='Pozostała wartość limitu.')
    limit: int = Field(
        ..., description='Maksymalna liczba zasobów dozwolona w ramach limitu.'
    )


class CertificateLimitsResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    canRequest: bool = Field(
        ...,
        description='Flaga informująca czy uwierzytelniony podmiot może złożyć nowy wniosek o certyfikat.',
    )
    enrollment: CertificateLimit = Field(
        ...,
        description='Informacje o limitach związanych z liczbą możliwych do złożenia wniosków certyfikacyjnych.',
    )
    certificate: CertificateLimit = Field(
        ...,
        description='Informacje o limitach dotyczących liczby aktywnych certyfikatów wydanych dla danego podmiotu.',
    )


class CertificateListItemStatus(str,Enum):
    Active = 'Active'
    Blocked = 'Blocked'
    Revoked = 'Revoked'
    Expired = 'Expired'


class CertificateRevocationReason(str,Enum):
    Unspecified = 'Unspecified'
    Superseded = 'Superseded'
    KeyCompromise = 'KeyCompromise'


class CertificateSubjectIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class CertificateSubjectLimitsOverride(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    maxCertificates: Optional[conint(ge=0)] = None


class CheckAttachmentPermissionStatusResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    isAttachmentAllowed: Optional[bool] = Field(
        None,
        description='Informacja czy Podmiot ma obecnie możliwość dodawania Załączników do Faktur',
    )
    revokedDate: Optional[AwareDatetime] = Field(
        None,
        description='Data i czas zakończenia możliwość dodawania przez Podmiot Załączników do Faktur.\nBrak podanej daty oznacza bezterminową możliwość dodawania Załączników do Faktur',
    )


class CommonSessionStatus(str,Enum):
    InProgress = 'InProgress'
    Succeeded = 'Succeeded'
    Failed = 'Failed'
    Cancelled = 'Cancelled'


class CurrencyCode(str,Enum):
    AED = 'AED'
    AFN = 'AFN'
    ALL = 'ALL'
    AMD = 'AMD'
    ANG = 'ANG'
    AOA = 'AOA'
    ARS = 'ARS'
    AUD = 'AUD'
    AWG = 'AWG'
    AZN = 'AZN'
    BAM = 'BAM'
    BBD = 'BBD'
    BDT = 'BDT'
    BGN = 'BGN'
    BHD = 'BHD'
    BIF = 'BIF'
    BMD = 'BMD'
    BND = 'BND'
    BOB = 'BOB'
    BOV = 'BOV'
    BRL = 'BRL'
    BSD = 'BSD'
    BTN = 'BTN'
    BWP = 'BWP'
    BYN = 'BYN'
    BZD = 'BZD'
    CAD = 'CAD'
    CDF = 'CDF'
    CHE = 'CHE'
    CHF = 'CHF'
    CHW = 'CHW'
    CLF = 'CLF'
    CLP = 'CLP'
    CNY = 'CNY'
    COP = 'COP'
    COU = 'COU'
    CRC = 'CRC'
    CUC = 'CUC'
    CUP = 'CUP'
    CVE = 'CVE'
    CZK = 'CZK'
    DJF = 'DJF'
    DKK = 'DKK'
    DOP = 'DOP'
    DZD = 'DZD'
    EGP = 'EGP'
    ERN = 'ERN'
    ETB = 'ETB'
    EUR = 'EUR'
    FJD = 'FJD'
    FKP = 'FKP'
    GBP = 'GBP'
    GEL = 'GEL'
    GGP = 'GGP'
    GHS = 'GHS'
    GIP = 'GIP'
    GMD = 'GMD'
    GNF = 'GNF'
    GTQ = 'GTQ'
    GYD = 'GYD'
    HKD = 'HKD'
    HNL = 'HNL'
    HRK = 'HRK'
    HTG = 'HTG'
    HUF = 'HUF'
    IDR = 'IDR'
    ILS = 'ILS'
    IMP = 'IMP'
    INR = 'INR'
    IQD = 'IQD'
    IRR = 'IRR'
    ISK = 'ISK'
    JEP = 'JEP'
    JMD = 'JMD'
    JOD = 'JOD'
    JPY = 'JPY'
    KES = 'KES'
    KGS = 'KGS'
    KHR = 'KHR'
    KMF = 'KMF'
    KPW = 'KPW'
    KRW = 'KRW'
    KWD = 'KWD'
    KYD = 'KYD'
    KZT = 'KZT'
    LAK = 'LAK'
    LBP = 'LBP'
    LKR = 'LKR'
    LRD = 'LRD'
    LSL = 'LSL'
    LYD = 'LYD'
    MAD = 'MAD'
    MDL = 'MDL'
    MGA = 'MGA'
    MKD = 'MKD'
    MMK = 'MMK'
    MNT = 'MNT'
    MOP = 'MOP'
    MRU = 'MRU'
    MUR = 'MUR'
    MVR = 'MVR'
    MWK = 'MWK'
    MXN = 'MXN'
    MXV = 'MXV'
    MYR = 'MYR'
    MZN = 'MZN'
    NAD = 'NAD'
    NGN = 'NGN'
    NIO = 'NIO'
    NOK = 'NOK'
    NPR = 'NPR'
    NZD = 'NZD'
    OMR = 'OMR'
    PAB = 'PAB'
    PEN = 'PEN'
    PGK = 'PGK'
    PHP = 'PHP'
    PKR = 'PKR'
    PLN = 'PLN'
    PYG = 'PYG'
    QAR = 'QAR'
    RON = 'RON'
    RSD = 'RSD'
    RUB = 'RUB'
    RWF = 'RWF'
    SAR = 'SAR'
    SBD = 'SBD'
    SCR = 'SCR'
    SDG = 'SDG'
    SEK = 'SEK'
    SGD = 'SGD'
    SHP = 'SHP'
    SLL = 'SLL'
    SOS = 'SOS'
    SRD = 'SRD'
    SSP = 'SSP'
    STN = 'STN'
    SVC = 'SVC'
    SYP = 'SYP'
    SZL = 'SZL'
    THB = 'THB'
    TJS = 'TJS'
    TMT = 'TMT'
    TND = 'TND'
    TOP = 'TOP'
    TRY = 'TRY'
    TTD = 'TTD'
    TWD = 'TWD'
    TZS = 'TZS'
    UAH = 'UAH'
    UGX = 'UGX'
    USD = 'USD'
    USN = 'USN'
    UYI = 'UYI'
    UYU = 'UYU'
    UYW = 'UYW'
    UZS = 'UZS'
    VES = 'VES'
    VND = 'VND'
    VUV = 'VUV'
    WST = 'WST'
    XAF = 'XAF'
    XAG = 'XAG'
    XAU = 'XAU'
    XBA = 'XBA'
    XBB = 'XBB'
    XBC = 'XBC'
    XBD = 'XBD'
    XCD = 'XCD'
    XCG = 'XCG'
    XDR = 'XDR'
    XOF = 'XOF'
    XPD = 'XPD'
    XPF = 'XPF'
    XPT = 'XPT'
    XSU = 'XSU'
    XUA = 'XUA'
    XXX = 'XXX'
    YER = 'YER'
    ZAR = 'ZAR'
    ZMW = 'ZMW'
    ZWL = 'ZWL'


class EffectiveApiRateLimitValues(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    perSecond: int = Field(..., description='Limit na sekundę.')
    perMinute: int = Field(..., description='Limit na minutę.')
    perHour: int = Field(..., description='Limit na godzinę.')


class EffectiveApiRateLimits(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    onlineSession: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla otwierania/zamykania sesji interaktywnych.'
    )
    batchSession: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla otwierania/zamykania sesji wsadowych.'
    )
    invoiceSend: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla wysyłki faktur.'
    )
    invoiceStatus: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla pobierania statusu faktury z sesji.'
    )
    sessionList: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla pobierania listy sesji.'
    )
    sessionInvoiceList: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla pobierania listy faktur w sesji.'
    )
    sessionMisc: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla pozostałych operacji w ramach sesji.'
    )
    invoiceMetadata: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla pobierania metadanych faktur.'
    )
    invoiceExport: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla eksportu paczki faktur.'
    )
    invoiceExportStatus: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla pobierana statusu eksportu paczki faktur.'
    )
    invoiceDownload: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla pobierania faktur po numerze KSeF.'
    )
    other: EffectiveApiRateLimitValues = Field(
        ..., description='Limity dla pozostałych operacji API.'
    )


class EncryptionInfo(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    encryptedSymmetricKey: str = Field(
        ...,
        description='Klucz symetryczny o długości 32 bajtów, zaszyfrowany algorytmem RSA (Padding: OAEP z SHA-256), zakodowany w formacie Base64.\n\n[Klucz publiczny Ministerstwa Finansów](/docs/v2/index.html#tag/Certyfikaty-klucza-publicznego)',
    )
    initializationVector: str = Field(
        ...,
        description='Wektor inicjalizujący (IV) o długości 16 bajtów, używany do szyfrowania symetrycznego, zakodowany w formacie Base64.',
    )


class EnrollmentEffectiveSubjectLimits(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    maxEnrollments: Optional[int] = None


class EnrollmentSubjectLimitsOverride(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    maxEnrollments: Optional[conint(ge=0)] = None


class EntityAuthorizationPermissionType(str,Enum):
    SelfInvoicing = 'SelfInvoicing'
    RRInvoicing = 'RRInvoicing'
    TaxRepresentative = 'TaxRepresentative'
    PefInvoicing = 'PefInvoicing'


class EntityAuthorizationPermissionsSubjectIdentifierType(str,Enum):
    Nip = 'Nip'
    PeppolId = 'PeppolId'


class EntityAuthorizationsAuthorIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class EntityAuthorizationsAuthorizedEntityIdentifierType(str,Enum):
    Nip = 'Nip'
    PeppolId = 'PeppolId'


class EntityAuthorizationsAuthorizingEntityIdentifierType(str,Enum):
    Nip = 'Nip'


class EntityByFingerprintDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    fullName: constr(max_length=100) = Field(..., description='Pełna nazwa podmiotu.')
    address: constr(max_length=512) = Field(..., description='Adres podmiotu.')


class EntityDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    fullName: constr(min_length=5, max_length=90) = Field(
        ..., description='Pełna nazwa podmiotu.'
    )


class EntityPermissionType(str,Enum):
    InvoiceWrite = 'InvoiceWrite'
    InvoiceRead = 'InvoiceRead'


class EntityPermissionsSubjectIdentifierType(str,Enum):
    Nip = 'Nip'


class EntityPermissionsSubordinateEntityIdentifierType(str,Enum):
    Nip = 'Nip'


class EntityRoleType(str,Enum):
    CourtBailiff = 'CourtBailiff'
    EnforcementAuthority = 'EnforcementAuthority'
    LocalGovernmentUnit = 'LocalGovernmentUnit'
    LocalGovernmentSubUnit = 'LocalGovernmentSubUnit'
    VatGroupUnit = 'VatGroupUnit'
    VatGroupSubUnit = 'VatGroupSubUnit'


class EntityRolesParentEntityIdentifierType(str,Enum):
    Nip = 'Nip'


class EntitySubjectByFingerprintDetailsType(str,Enum):
    EntityByFingerprint = 'EntityByFingerprint'


class EntitySubjectByIdentifierDetailsType(str,Enum):
    EntityByIdentifier = 'EntityByIdentifier'


class EntitySubjectDetailsType(str,Enum):
    EntityByIdentifier = 'EntityByIdentifier'
    EntityByFingerprint = 'EntityByFingerprint'


class EuEntityAdministrationPermissionsContextIdentifierType(str,Enum):
    NipVatUe = 'NipVatUe'


class EuEntityAdministrationPermissionsSubjectIdentifierType(str,Enum):
    Fingerprint = 'Fingerprint'


class EuEntityDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    fullName: constr(max_length=100) = Field(..., description='Pełna nazwa podmiotu.')
    address: constr(max_length=512) = Field(..., description='Adres podmiotu.')


class EuEntityPermissionSubjectDetailsType(str,Enum):
    PersonByFingerprintWithIdentifier = 'PersonByFingerprintWithIdentifier'
    PersonByFingerprintWithoutIdentifier = 'PersonByFingerprintWithoutIdentifier'
    EntityByFingerprint = 'EntityByFingerprint'


class EuEntityPermissionType(str,Enum):
    InvoiceWrite = 'InvoiceWrite'
    InvoiceRead = 'InvoiceRead'


class EuEntityPermissionsAuthorIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class EuEntityPermissionsQueryPermissionType(str,Enum):
    VatUeManage = 'VatUeManage'
    InvoiceWrite = 'InvoiceWrite'
    InvoiceRead = 'InvoiceRead'
    Introspection = 'Introspection'


class EuEntityPermissionsQueryRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    vatUeIdentifier: Optional[
        constr(
            pattern=r'^(ATU\d{8}|BE[01]{1}\d{9}|BG\d{9,10}|CY\d{8}[A-Z]|CZ\d{8,10}|DE\d{9}|DK\d{8}|EE\d{9}|EL\d{9}|ES([A-Z]\d{8}|\d{8}[A-Z]|[A-Z]\d{7}[A-Z])|FI\d{8}|FR[A-Z0-9]{2}\d{9}|HR\d{11}|HU\d{8}|IE(\d{7}[A-Z]{2}|\d[A-Z0-9+*]\d{5}[A-Z])|IT\d{11}|LT(\d{9}|\d{12})|LU\d{8}|LV\d{11}|MT\d{8}|NL[A-Z0-9+*]{12}|PT\d{9}|RO\d{2,10}|SE\d{12}|SI\d{8}|SK\d{10}|XI((\d{9}|\d{12})|(GD|HA)\d{3}))$'
        )
    ] = Field(
        None,
        description='Wartość identyfikatora (numeru identyfikacyjnego VAT) podmiotu unijnego (exact match).',
    )
    authorizedFingerprintIdentifier: Optional[str] = Field(
        None,
        description='Odcisk palca certyfikatu kwalifikowanego uprawnionego (contains).',
    )
    permissionTypes: Optional[Sequence[EuEntityPermissionsQueryPermissionType]] = Field(
        None, description='Lista rodzajów wyszukiwanych uprawnień.'
    )


class EuEntityPermissionsSubjectIdentifierType(str,Enum):
    Fingerprint = 'Fingerprint'


class ExceptionDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    exceptionCode: Optional[int] = None
    exceptionDescription: Optional[str] = None
    details: Optional[Sequence[str]] = None


class FormCode(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    systemCode: str = Field(..., description='Kod systemowy')
    schemaVersion: str = Field(..., description='Wersja schematu')
    value: str = Field(..., description='Wartość')


class IdDocument(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: constr(max_length=20) = Field(..., description='Rodzaj dokumentu tożsamości.')
    number: constr(max_length=20) = Field(
        ..., description='Seria i numer dokumentu tożsamości.'
    )
    country: constr(min_length=2, max_length=2) = Field(
        ...,
        description='Kraj wydania dokumentu tożsamości. Musi być zgodny z ISO 3166-1 alpha-2 (np. PL, DE, US) oraz zawierać dokładnie 2 wielkie litery.',
    )


class IndirectPermissionType(str,Enum):
    InvoiceRead = 'InvoiceRead'
    InvoiceWrite = 'InvoiceWrite'


class IndirectPermissionsSubjectIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class IndirectPermissionsTargetIdentifierType(str,Enum):
    Nip = 'Nip'
    AllPartners = 'AllPartners'
    InternalId = 'InternalId'


class InternalId(
    RootModel[
        constr(
            pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}-\d{5}$',
            min_length=16,
            max_length=16,
        )
    ]
):
    root: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}-\d{5}$', min_length=16, max_length=16
    ) = Field(
        ...,
        description='Identyfikator wewnętrzny, składający się z numeru NIP i 5 cyfr.',
    )


class InvoiceMetadataBuyerIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: BuyerIdentifierType = Field(
        ...,
        description='Typ identyfikatora nabywcy.\n| Wartość | Opis |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| VatUe | Identyfikator VAT UE podmiotu unijnego |\n| Other | Inny identyfikator |\n| None | Brak identyfikatora nabywcy |\n',
    )
    value: Optional[constr(max_length=50)] = Field(
        None, description='Wartość identyfikatora nabywcy.'
    )


class InvoicePermissionType(str,Enum):
    SelfInvoicing = 'SelfInvoicing'
    TaxRepresentative = 'TaxRepresentative'
    RRInvoicing = 'RRInvoicing'
    PefInvoicing = 'PefInvoicing'


class InvoiceQueryAmount(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: AmountType
    from_: Optional[float] = Field(None, alias='from')
    to: Optional[float] = None


class InvoiceQueryBuyerIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: BuyerIdentifierType = Field(
        ...,
        description='Typ identyfikatora nabywcy.\n| Wartość | Opis |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| VatUe | Identyfikator VAT UE podmiotu unijnego |\n| Other | Inny identyfikator |\n| None | Brak identyfikatora nabywcy |\n',
    )
    value: Optional[constr(max_length=50)] = Field(
        None, description='Wartość identyfikatora nabywcy (exact match).'
    )


class InvoiceQueryDateType(str,Enum):
    Issue = 'Issue'
    Invoicing = 'Invoicing'
    PermanentStorage = 'PermanentStorage'


class InvoiceQueryFormType(str,Enum):
    FA = 'FA'
    PEF = 'PEF'
    RR = 'RR'


class InvoiceQuerySubjectType(str,Enum):
    Subject1 = 'Subject1'
    Subject2 = 'Subject2'
    Subject3 = 'Subject3'
    SubjectAuthorized = 'SubjectAuthorized'


class InvoiceStatusInfo(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    code: int = Field(..., description='Kod statusu faktury')
    description: constr(min_length=1) = Field(..., description='Opis statusu')
    details: Optional[Sequence[str]] = Field(
        None, description='Dodatkowe szczegóły statusu'
    )
    extensions: Optional[Mapping[str, str]] = Field(
        None,
        description='Zbiór dodatkowych informacji związanych ze statusem faktury, zapisanych jako pary klucz–wartość.\nUmożliwia rozszerzenie modelu o dane specyficzne dla danego przypadku.',
    )


class InvoiceType(str,Enum):
    Vat = 'Vat'
    Zal = 'Zal'
    Kor = 'Kor'
    Roz = 'Roz'
    Upr = 'Upr'
    KorZal = 'KorZal'
    KorRoz = 'KorRoz'
    VatPef = 'VatPef'
    VatPefSp = 'VatPefSp'
    KorPef = 'KorPef'
    VatRr = 'VatRr'
    KorVatRr = 'KorVatRr'


class InvoicingMode(str,Enum):
    Online = 'Online'
    Offline = 'Offline'


class KsefCertificateType(str,Enum):
    Authentication = 'Authentication'
    Offline = 'Offline'


class NipVatUe(
    RootModel[
        constr(
            pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}-(ATU\d{8}|BE[01]{1}\d{9}|BG\d{9,10}|CY\d{8}[A-Z]|CZ\d{8,10}|DE\d{9}|DK\d{8}|EE\d{9}|EL\d{9}|ES([A-Z]\d{8}|\d{8}[A-Z]|[A-Z]\d{7}[A-Z])|FI\d{8}|FR[A-Z0-9]{2}\d{9}|HR\d{11}|HU\d{8}|IE(\d{7}[A-Z]{2}|\d[A-Z0-9+*]\d{5}[A-Z])|IT\d{11}|LT(\d{9}|\d{12})|LU\d{8}|LV\d{11}|MT\d{8}|NL[A-Z0-9+*]{12}|PT\d{9}|RO\d{2,10}|SE\d{12}|SI\d{8}|SK\d{10}|XI((\d{9}|\d{12})|(GD|HA)\d{3}))$'
        )
    ]
):
    root: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}-(ATU\d{8}|BE[01]{1}\d{9}|BG\d{9,10}|CY\d{8}[A-Z]|CZ\d{8,10}|DE\d{9}|DK\d{8}|EE\d{9}|EL\d{9}|ES([A-Z]\d{8}|\d{8}[A-Z]|[A-Z]\d{7}[A-Z])|FI\d{8}|FR[A-Z0-9]{2}\d{9}|HR\d{11}|HU\d{8}|IE(\d{7}[A-Z]{2}|\d[A-Z0-9+*]\d{5}[A-Z])|IT\d{11}|LT(\d{9}|\d{12})|LU\d{8}|LV\d{11}|MT\d{8}|NL[A-Z0-9+*]{12}|PT\d{9}|RO\d{2,10}|SE\d{12}|SI\d{8}|SK\d{10}|XI((\d{9}|\d{12})|(GD|HA)\d{3}))$'
    ) = Field(
        ...,
        description='Identyfikator złożony, czyli dwuczłonowy identyfikator składający się z nr NIP podmiotu polskiego oraz numeru VAT UE podmiotu unijnego.',
    )


class OnlineSessionContextLimitsOverride(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    maxInvoiceSizeInMB: conint(ge=0, le=5) = Field(
        ..., description='Maksymalny rozmiar faktury w MB.'
    )
    maxInvoiceWithAttachmentSizeInMB: conint(ge=0, le=10) = Field(
        ..., description='Maksymalny rozmiar faktury z załącznikiem w MB.'
    )
    maxInvoices: conint(ge=0, le=100000) = Field(
        ...,
        description='Maksymalna ilość faktur które można przesłać w pojedynczej sesji.',
    )


class OnlineSessionEffectiveContextLimits(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    maxInvoiceSizeInMB: conint(ge=0) = Field(
        ..., description='Maksymalny rozmiar faktury w MB.'
    )
    maxInvoiceWithAttachmentSizeInMB: conint(ge=0) = Field(
        ..., description='Maksymalny rozmiar faktury z załącznikiem w MB.'
    )
    maxInvoices: conint(ge=0) = Field(
        ...,
        description='Maksymalna ilość faktur które można przesłać w pojedynczej sesji.',
    )


class OpenOnlineSessionRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    formCode: FormCode = Field(
        ...,
        description='Schemat faktur wysyłanych w ramach sesji.\n\nObsługiwane schematy:\n| SystemCode | SchemaVersion | Value |\n| --- | --- | --- |\n| [FA (2)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/FA/schemat_FA(2)_v1-0E.xsd) | 1-0E | FA |\n| [FA (3)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/FA/schemat_FA(3)_v1-0E.xsd) | 1-0E | FA |\n| [PEF (3)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/PEF/Schemat_PEF(3)_v2-1.xsd) | 2-1 | PEF |\n| [PEF_KOR (3)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/PEF/Schemat_PEF_KOR(3)_v2-1.xsd) | 2-1 | PEF |\n',
    )
    encryption: EncryptionInfo = Field(
        ...,
        description='Symetryczny klucz szyfrujący pliki XML, zaszyfrowany kluczem publicznym Ministerstwa Finansów.',
    )


class PartUploadRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    ordinalNumber: conint(ge=1) = Field(
        ..., description='Numer sekwencyjny części pliku paczki.'
    )
    method: str = Field(
        ...,
        description='Metoda HTTP, której należy użyć przy wysyłce części pliku paczki.',
    )
    url: AnyUrl = Field(
        ..., description='Adres pod który należy wysłać część pliku paczki.'
    )
    headers: Mapping[str, str] = Field(
        ...,
        description='Nagłówki, których należy użyć przy wysyłce części pliku paczki.',
    )


class PeppolProvider(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    id: constr(pattern=r'^P[A-Z]{2}[0-9]{6}$', min_length=9, max_length=9) = Field(
        ..., description='Identyfikator dostawcy usług Peppol.'
    )
    name: constr(max_length=256) = Field(
        ..., description='Nazwa dostawcy usług Peppol.'
    )
    dateCreated: AwareDatetime = Field(
        ..., description='Data rejestracji dostawcy usług Peppol w systemie.'
    )


class PermissionState(str,Enum):
    Active = 'Active'
    Inactive = 'Inactive'


class PermissionsEuEntityDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    fullName: constr(max_length=100) = Field(
        ..., description='Pełna nazwa podmiotu unijnego.'
    )
    address: constr(max_length=512) = Field(..., description='Adres podmiotu unijnego.')


class PermissionsSubjectEntityByFingerprintDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectDetailsType: EntitySubjectByFingerprintDetailsType = Field(
        ...,
        description='Typ danych podmiotu uprawnionego.\n| Wartość | Opis |\n| --- | --- |\n| EntityByFingerprint | Podmiot identyfikowany odciskiem palca pieczęci kwalifikowanej. |\n',
    )
    fullName: constr(max_length=100) = Field(..., description='Pełna nazwa podmiotu.')
    address: Optional[constr(max_length=512)] = Field(
        None, description='Adres podmiotu.'
    )


class PermissionsSubjectEntityByIdentifierDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectDetailsType: EntitySubjectByIdentifierDetailsType = Field(
        ...,
        description='Typ danych podmiotu uprawnionego.\n| Wartość | Opis |\n| --- | --- |\n| EntityByIdentifier | Podmiot identyfikowany numerem NIP. |\n',
    )
    fullName: constr(max_length=100) = Field(..., description='Pełna nazwa podmiotu.')


class PermissionsSubjectEntityDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectDetailsType: EntitySubjectDetailsType = Field(
        ...,
        description='Typ danych podmiotu uprawnionego.\n| Wartość | Opis |\n| --- | --- |\n| EntityByIdentifier | Podmiot identyfikowany numerem NIP. |\n| EntityByFingerprint | Podmiot identyfikowany odciskiem palca pieczęci kwalifikowanej. |\n',
    )
    fullName: constr(max_length=100) = Field(..., description='Pełna nazwa podmiotu.')
    address: Optional[constr(max_length=512)] = Field(
        None, description='Adres podmiotu.'
    )


class PersonByFingerprintWithoutIdentifierDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    firstName: constr(min_length=2, max_length=30) = Field(
        ..., description='Imię osoby fizycznej.'
    )
    lastName: constr(min_length=2, max_length=81) = Field(
        ..., description='Nazwisko osoby fizycznej.'
    )
    birthDate: date = Field(..., description='Data urodzenia osoby fizycznej.')
    idDocument: IdDocument = Field(
        ..., description='Dane dokumentu tożsamości osoby fizycznej.'
    )


class PersonDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    firstName: constr(min_length=2, max_length=30) = Field(
        ..., description='Imię osoby fizycznej.'
    )
    lastName: constr(min_length=2, max_length=81) = Field(
        ..., description='Nazwisko osoby fizycznej.'
    )


class PersonIdentifierType(str,Enum):
    Pesel = 'Pesel'
    Nip = 'Nip'


class PersonPermissionScope(str,Enum):
    CredentialsManage = 'CredentialsManage'
    CredentialsRead = 'CredentialsRead'
    InvoiceWrite = 'InvoiceWrite'
    InvoiceRead = 'InvoiceRead'
    Introspection = 'Introspection'
    SubunitManage = 'SubunitManage'
    EnforcementOperations = 'EnforcementOperations'


class PersonPermissionSubjectDetailsType(str,Enum):
    PersonByIdentifier = 'PersonByIdentifier'
    PersonByFingerprintWithIdentifier = 'PersonByFingerprintWithIdentifier'
    PersonByFingerprintWithoutIdentifier = 'PersonByFingerprintWithoutIdentifier'


class PersonPermissionType(str,Enum):
    CredentialsManage = 'CredentialsManage'
    CredentialsRead = 'CredentialsRead'
    InvoiceWrite = 'InvoiceWrite'
    InvoiceRead = 'InvoiceRead'
    Introspection = 'Introspection'
    SubunitManage = 'SubunitManage'
    EnforcementOperations = 'EnforcementOperations'


class PersonPermissionsAuthorIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'
    System = 'System'


class PersonPermissionsAuthorizedIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class PersonPermissionsContextIdentifierType(str,Enum):
    Nip = 'Nip'
    InternalId = 'InternalId'


class PersonPermissionsQueryType(str,Enum):
    PermissionsInCurrentContext = 'PermissionsInCurrentContext'
    PermissionsGrantedInCurrentContext = 'PermissionsGrantedInCurrentContext'


class PersonPermissionsSubjectIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class PersonPermissionsTargetIdentifierType(str,Enum):
    Nip = 'Nip'
    AllPartners = 'AllPartners'
    InternalId = 'InternalId'


class PersonRemoveRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    nip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='10 cyfrowy numer NIP.')


class PersonSubjectByFingerprintDetailsType(str,Enum):
    PersonByFingerprintWithIdentifier = 'PersonByFingerprintWithIdentifier'
    PersonByFingerprintWithoutIdentifier = 'PersonByFingerprintWithoutIdentifier'


class PersonSubjectDetailsType(str,Enum):
    PersonByIdentifier = 'PersonByIdentifier'
    PersonByFingerprintWithIdentifier = 'PersonByFingerprintWithIdentifier'
    PersonByFingerprintWithoutIdentifier = 'PersonByFingerprintWithoutIdentifier'


class PersonalPermissionScope(str,Enum):
    CredentialsManage = 'CredentialsManage'
    CredentialsRead = 'CredentialsRead'
    InvoiceWrite = 'InvoiceWrite'
    InvoiceRead = 'InvoiceRead'
    Introspection = 'Introspection'
    SubunitManage = 'SubunitManage'
    EnforcementOperations = 'EnforcementOperations'
    VatUeManage = 'VatUeManage'


class PersonalPermissionType(str,Enum):
    CredentialsManage = 'CredentialsManage'
    CredentialsRead = 'CredentialsRead'
    InvoiceWrite = 'InvoiceWrite'
    InvoiceRead = 'InvoiceRead'
    Introspection = 'Introspection'
    SubunitManage = 'SubunitManage'
    EnforcementOperations = 'EnforcementOperations'
    VatUeManage = 'VatUeManage'


class PersonalPermissionsAuthorizedIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class PersonalPermissionsContextIdentifierType(str,Enum):
    Nip = 'Nip'
    InternalId = 'InternalId'


class PersonalPermissionsTargetIdentifierType(str,Enum):
    Nip = 'Nip'
    AllPartners = 'AllPartners'
    InternalId = 'InternalId'


class PublicKeyCertificateUsage(str,Enum):
    KsefTokenEncryption = 'KsefTokenEncryption'
    SymmetricKeyEncryption = 'SymmetricKeyEncryption'


class QueryCertificatesRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    certificateSerialNumber: Optional[str] = Field(
        None,
        description='Numer seryjny certyfikatu. Wyszukiwanie odbywa się na zasadzie dokładnego dopasowania (exact match).',
    )
    name: Optional[str] = Field(
        None,
        description='Nazwa własna certyfikatu. Wyszukiwanie jest częściowe, czyli zwracane są certyfikaty, których nazwa zawiera podany ciąg znaków (contains).',
    )
    type: Optional[KsefCertificateType] = Field(
        None,
        description='Typ certyfikatu KSeF.\n| Wartość | Opis |\n| --- | --- |\n| Authentication | Certyfikat używany do uwierzytelnienia w systemie. |\n| Offline | Certyfikat używany wyłącznie do potwierdzania autentyczności wystawcy i integralności faktury w trybie offline |\n',
    )
    status: Optional[CertificateListItemStatus] = Field(
        None,
        description='Status certyfikatu.\n| Wartość | Opis |\n| --- | --- |\n| Active | Certyfikat jest aktywny i może zostać użyty do uwierzytelnienia lub realizacji operacji w trybie offline (w zależności od typu certyfikatu). |\n| Blocked | Certyfikat został zablokowany i nie może zostać użyty do uwierzytelnienia i realizacji operacji w trybie offline.            Status przejściowy do czasu zakończenia procesu unieważniania. |\n| Revoked | Certyfikat został unieważniony i nie może zostać użyty do uwierzytelnienia i realizacji operacji w trybie offline. |\n| Expired | Certyfikat wygasł i nie może zostać użyty do uwierzytelnienia i realizacji operacji w trybie offline. |\n',
    )
    expiresAfter: Optional[AwareDatetime] = Field(
        None, description='Filtruje certyfikaty, które wygasają po podanej dacie.'
    )


class QueryPeppolProvidersResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    peppolProviders: Sequence[PeppolProvider] = Field(
        ..., description='Lista dostawców usług Peppol.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class QueryType(str,Enum):
    Granted = 'Granted'
    Received = 'Received'


class RetrieveCertificatesListItem(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    certificate: str = Field(
        ..., description='Certyfikat w formacie DER, zakodowany w formacie Base64.'
    )
    certificateName: str = Field(..., description='Nazwa własna certyfikatu.')
    certificateSerialNumber: str = Field(..., description='Numer seryjny certyfikatu.')
    certificateType: KsefCertificateType = Field(
        ...,
        description='Typ certyfikatu.\n| Wartość | Opis |\n| --- | --- |\n| Authentication | Certyfikat używany do uwierzytelnienia w systemie. |\n| Offline | Certyfikat używany wyłącznie do potwierdzania autentyczności wystawcy i integralności faktury w trybie offline |\n',
    )


class RetrieveCertificatesRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    certificateSerialNumbers: Sequence[str] = Field(
        ...,
        description='Numery seryjne certyfikatów do pobrania.',
        max_length=10,
        min_length=1,
    )


class RetrieveCertificatesResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    certificates: Sequence[RetrieveCertificatesListItem] = Field(
        ..., description='Pobrane certyfikaty.'
    )


class RetryAfter(RootModel[int]):
    root: int = Field(
        ...,
        description='Liczba sekund po których można ponowić żądanie.',
        examples=[30],
    )


class RevokeCertificateRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    revocationReason: Optional[CertificateRevocationReason] = Field(
        None,
        description='Powód unieważnienia certyfikatu.\n| Wartość | Opis |\n| --- | --- |\n| Unspecified | Nieokreślony. |\n| Superseded | Certyfikat został zastąpiony przez inny. |\n| KeyCompromise | Klucz prywatny powiązany z certyfikatem został skompromitowany. |\n',
    )


class SendInvoiceResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny faktury.'
    )


class SessionType(str,Enum):
    Online = 'Online'
    Batch = 'Batch'


class SetRateLimitsRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    rateLimits: ApiRateLimitsOverride = Field(
        ..., description='Limity dla ilości żądań do API.'
    )


class SetSessionLimitsRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    onlineSession: OnlineSessionContextLimitsOverride = Field(
        ..., description='Limity dla sesji interaktywnych.'
    )
    batchSession: BatchSessionContextLimitsOverride = Field(
        ..., description='Limity dla sesji wsadowych.'
    )


class SortOrder(str,Enum):
    Asc = 'Asc'
    Desc = 'Desc'


class StatusInfo(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    code: int = Field(..., description='Kod statusu')
    description: constr(min_length=1) = Field(..., description='Opis statusu')
    details: Optional[Sequence[str]] = Field(
        None, description='Dodatkowe szczegóły statusu'
    )


class SubjectIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class SubjectRemoveRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectNip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='10 cyfrowy numer NIP.')


class SubjectType(str,Enum):
    EnforcementAuthority = 'EnforcementAuthority'
    VatGroup = 'VatGroup'
    JST = 'JST'


class SubordinateEntityRoleType(str,Enum):
    LocalGovernmentSubUnit = 'LocalGovernmentSubUnit'
    VatGroupSubUnit = 'VatGroupSubUnit'


class SubordinateRoleSubordinateEntityIdentifierType(str,Enum):
    Nip = 'Nip'


class Subunit(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectNip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='10 cyfrowy numer NIP.')
    description: constr(min_length=5, max_length=256)


class SubunitPermissionScope(str,Enum):
    CredentialsManage = 'CredentialsManage'


class SubunitPermissionsAuthorIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class SubunitPermissionsContextIdentifierType(str,Enum):
    InternalId = 'InternalId'
    Nip = 'Nip'


class SubunitPermissionsSubjectIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class SubunitPermissionsSubunitIdentifierType(str,Enum):
    InternalId = 'InternalId'
    Nip = 'Nip'


class TestDataAuthenticationContextIdentifierType(str,Enum):
    Nip = 'Nip'
    InternalId = 'InternalId'
    NipVatUe = 'NipVatUe'
    PeppolId = 'PeppolId'


class TestDataAuthorizedIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class TestDataContextIdentifierType(str,Enum):
    Nip = 'Nip'


class TestDataPermissionType(str,Enum):
    InvoiceRead = 'InvoiceRead'
    InvoiceWrite = 'InvoiceWrite'
    Introspection = 'Introspection'
    CredentialsRead = 'CredentialsRead'
    CredentialsManage = 'CredentialsManage'
    EnforcementOperations = 'EnforcementOperations'
    SubunitManage = 'SubunitManage'


class ThirdSubjectIdentifierType(str,Enum):
    Nip = 'Nip'
    InternalId = 'InternalId'
    VatUe = 'VatUe'
    Other = 'Other'
    None_ = 'None'


class TokenAuthorIdentifierType(str,Enum):
    Nip = 'Nip'
    Pesel = 'Pesel'
    Fingerprint = 'Fingerprint'


class TokenAuthorIdentifierTypeIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: TokenAuthorIdentifierType = Field(
        ...,
        description='Typ identyfikatora.\n| Wartość | Opis |\n| --- | --- |\n| Nip | NIP. |\n| Pesel | PESEL. |\n| Fingerprint | Odcisk palca certyfikatu. |\n',
    )
    value: str = Field(..., description='Wartość identyfikatora.')


class TokenContextIdentifierType(str,Enum):
    Nip = 'Nip'
    InternalId = 'InternalId'
    NipVatUe = 'NipVatUe'
    PeppolId = 'PeppolId'


class TokenContextIdentifierTypeIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: TokenContextIdentifierType = Field(
        ...,
        description='Typ identyfikatora.\n| Wartość | Opis |\n| --- | --- |\n| Nip | NIP. |\n| InternalId | Identyfikator wewnętrzny. |\n| NipVatUe | Dwuczłonowy identyfikator składający się z numeru NIP i numeru VAT-UE: `{nip}-{vat_ue}`. |\n| PeppolId | Identyfikator dostawcy usług Peppol. |\n',
    )
    value: str = Field(..., description='Wartość identyfikatora.')


class TokenInfo(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    token: str = Field(..., description='Token w formacie JWT.')
    validUntil: AwareDatetime = Field(..., description='Data ważności tokena.')


class TokenPermissionType(str,Enum):
    InvoiceRead = 'InvoiceRead'
    InvoiceWrite = 'InvoiceWrite'
    CredentialsRead = 'CredentialsRead'
    CredentialsManage = 'CredentialsManage'
    SubunitManage = 'SubunitManage'
    EnforcementOperations = 'EnforcementOperations'


class TokenStatusResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny tokena KSeF.'
    )
    authorIdentifier: TokenAuthorIdentifierTypeIdentifier = Field(
        ..., description='Identyfikator osoby która wygenerowała token.'
    )
    contextIdentifier: TokenContextIdentifierTypeIdentifier = Field(
        ...,
        description='Identyfikator kontekstu, w którym został wygenerowany token i do którego daje dostęp.',
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis tokena.'
    )
    requestedPermissions: Sequence[TokenPermissionType] = Field(
        ..., description='Uprawnienia przypisane tokenowi.'
    )
    dateCreated: AwareDatetime = Field(
        ..., description='Data i czas utworzenia tokena.'
    )
    lastUseDate: Optional[AwareDatetime] = Field(
        None, description='Data ostatniego użycia tokena.'
    )
    status: AuthenticationTokenStatus = Field(
        ...,
        description='Status tokena.\n| Wartość | Opis |\n| --- | --- |\n| Pending | Token został utworzony ale jest jeszcze w trakcie aktywacji i nadawania uprawnień. Nie może być jeszcze wykorzystywany do uwierzytelniania. |\n| Active | Token jest aktywny i może być wykorzystywany do uwierzytelniania. |\n| Revoking | Token jest w trakcie unieważniania. Nie może już być wykorzystywany do uwierzytelniania. |\n| Revoked | Token został unieważniony i nie może być wykorzystywany do uwierzytelniania. |\n| Failed | Nie udało się aktywować tokena. Należy wygenerować nowy token, obecny nie może być wykorzystywany do uwierzytelniania. |\n',
    )
    statusDetails: Optional[Sequence[str]] = Field(
        None,
        description='Dodatkowe informacje na temat statusu, zwracane w przypadku błędów.',
    )


class Status(BaseModel):
    code: int = Field(
        ...,
        description='Kod statusu HTTP odpowiadający błędowi. Zawsze ma wartość 429.',
    )
    description: str = Field(..., description='Opis błędu zgodny z nazwą statusu HTTP.')
    details: Sequence[str] = Field(
        ...,
        description='Lista szczegółowych informacji opisujących przyczynę przekroczenia limitu żądań oraz wskazówki dotyczące ponowienia żądania.',
    )


class TooManyRequestsResponse(BaseModel):
    status: Status = Field(
        ..., description='Informacje o błędzie związanym z przekroczeniem limitu żądań.'
    )


class UpoPageResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny strony UPO.'
    )
    downloadUrl: AnyUrl = Field(
        ...,
        description='Adres do pobrania strony UPO. Link generowany jest przy każdym odpytaniu o status. \nDostęp odbywa się metodą `HTTP GET` i <b>nie należy</b> wysyłać tokenu dostępowego. \nLink nie podlega limitom API i wygasa po określonym czasie w `DownloadUrlExpirationDate`.\n\nOdpowiedź HTTP zawiera dodatkowe nagłówki:\n- `x-ms-meta-hash` – skrót SHA-256 dokumentu UPO, zakodowany w formacie Base64.',
    )
    downloadUrlExpirationDate: AwareDatetime = Field(
        ...,
        description='Data i godzina wygaśnięcia adresu. Po tej dacie link `DownloadUrl` nie będzie już aktywny.',
    )


class UpoResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    pages: Sequence[UpoPageResponse] = Field(..., description='Lista stron UPO.')


class AttachmentPermissionGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    nip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='10 cyfrowy numer NIP.')


class AttachmentPermissionRevokeRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    nip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='10 cyfrowy numer NIP.')
    expectedEndDate: Optional[date] = Field(
        None, description='Data wycofania zgody na przesyłanie faktur z załącznikiem.'
    )


class AuthenticationChallengeResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    challenge: constr(min_length=36, max_length=36) = Field(
        ..., description='Unikalny challenge.'
    )
    timestamp: AwareDatetime = Field(..., description='Czas wygenerowania challenge-a.')
    timestampMs: int = Field(
        ...,
        description='Czas wygenerowania challenge-a w milisekundach od 1 stycznia 1970 roku (Unix timestamp).',
    )


class AuthenticationContextIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: AuthenticationContextIdentifierType = Field(
        ..., description='Typ identyfikatora'
    )
    value: str = Field(..., description='Wartość identyfikatora')


class AuthenticationInitResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny sesji uwierzytelnienia.'
    )
    authenticationToken: TokenInfo = Field(
        ..., description='Token operacji uwierzytelnienia.'
    )


class AuthenticationListItem(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia operacji uwierzytelnienia.'
    )
    authenticationMethod: AuthenticationMethod = Field(
        ...,
        description='Metoda uwierzytelnienia.\n| Wartość | Opis |\n| --- | --- |\n| Token | Token KSeF. |\n| TrustedProfile | Profil Zaufany. |\n| InternalCertificate | Certyfikat KSeF. |\n| QualifiedSignature | Podpis kwalifikowany. |\n| QualifiedSeal | Pieczęć kwalifikowana. |\n| PersonalSignature | Podpis osobisty. |\n| PeppolSignature | Podpis dostawcy usług Peppol. |\n',
    )
    status: StatusInfo = Field(
        ...,
        description='Informacje o aktualnym statusie.\n| Code | Description | Details |\n| --- | --- | --- |\n| 100 | Uwierzytelnianie w toku | - |\n| 200 | Uwierzytelnianie zakończone sukcesem | - |\n| 415 | Uwierzytelnianie zakończone niepowodzeniem | Brak przypisanych uprawnień |\n| 425 | Uwierzytelnienie unieważnione  | Uwierzytelnienie i powiązane refresh tokeny zostały unieważnione przez użytkownika |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Nieprawidłowe wyzwanie autoryzacyjne |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Nieprawidłowy token |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Nieprawidłowy czas tokena |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Token unieważniony |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Token nieaktywny |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Nieważny certyfikat |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Błąd weryfikacji łańcucha certyfikatów |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Niezaufany łańcuch certyfikatów |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Certyfikat odwołany |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Niepoprawny certyfikat |\n| 470 | Uwierzytelnianie zakończone niepowodzeniem | Próba wykorzystania metod autoryzacyjnych osoby zmarłej |\n| 480 | Uwierzytelnienie zablokowane | Podejrzenie incydentu bezpieczeństwa. Skontaktuj się z Ministerstwem Finansów przez formularz zgłoszeniowy. |\n| 500 | Nieznany błąd | - |\n| 550 | Operacja została anulowana przez system | Przetwarzanie zostało przerwane z przyczyn wewnętrznych systemu. Spróbuj ponownie |',
    )
    isTokenRedeemed: Optional[bool] = Field(
        None,
        description='Czy został już wydany refresh token powiązany z danym uwierzytelnieniem.',
    )
    lastTokenRefreshDate: Optional[AwareDatetime] = Field(
        None, description='Data ostatniego odświeżenia tokena.'
    )
    refreshTokenValidUntil: Optional[AwareDatetime] = Field(
        None,
        description='Termin ważności refresh tokena (o ile nie zostanie wcześniej unieważniony).',
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny sesji uwierzytelnienia.'
    )
    isCurrent: Optional[bool] = Field(
        None, description='Czy sesja jest powiązana z aktualnie używanym tokenem.'
    )


class AuthenticationListResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    continuationToken: Optional[str] = Field(
        None,
        description='Token służący do pobrania kolejnej strony wyników. Jeśli jest pusty, to nie ma kolejnych stron.',
    )
    items: Sequence[AuthenticationListItem] = Field(
        ..., description='Lista sesji uwierzytelniania.'
    )


class AuthenticationOperationStatusResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia operacji uwierzytelnienia.'
    )
    authenticationMethod: AuthenticationMethod = Field(
        ...,
        description='Metoda uwierzytelnienia.\n| Wartość | Opis |\n| --- | --- |\n| Token | Token KSeF. |\n| TrustedProfile | Profil Zaufany. |\n| InternalCertificate | Certyfikat KSeF. |\n| QualifiedSignature | Podpis kwalifikowany. |\n| QualifiedSeal | Pieczęć kwalifikowana. |\n| PersonalSignature | Podpis osobisty. |\n| PeppolSignature | Podpis dostawcy usług Peppol. |\n',
    )
    status: StatusInfo = Field(
        ...,
        description='Informacje o aktualnym statusie.\n| Code | Description | Details |\n| --- | --- | --- |\n| 100 | Uwierzytelnianie w toku | - |\n| 200 | Uwierzytelnianie zakończone sukcesem | - |\n| 415 | Uwierzytelnianie zakończone niepowodzeniem | Brak przypisanych uprawnień |\n| 425 | Uwierzytelnienie unieważnione  | Uwierzytelnienie i powiązane refresh tokeny zostały unieważnione przez użytkownika |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Nieprawidłowe wyzwanie autoryzacyjne |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Nieprawidłowy token |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Nieprawidłowy czas tokena |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Token unieważniony |\n| 450 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędnego tokenu | Token nieaktywny |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Nieważny certyfikat |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Błąd weryfikacji łańcucha certyfikatów |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Niezaufany łańcuch certyfikatów |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Certyfikat odwołany |\n| 460 | Uwierzytelnianie zakończone niepowodzeniem z powodu błędu certyfikatu | Niepoprawny certyfikat |\n| 470 | Uwierzytelnianie zakończone niepowodzeniem | Próba wykorzystania metod autoryzacyjnych osoby zmarłej |\n| 480 | Uwierzytelnienie zablokowane | Podejrzenie incydentu bezpieczeństwa. Skontaktuj się z Ministerstwem Finansów przez formularz zgłoszeniowy. |\n| 500 | Nieznany błąd | - |\n| 550 | Operacja została anulowana przez system | Przetwarzanie zostało przerwane z przyczyn wewnętrznych systemu. Spróbuj ponownie |',
    )
    isTokenRedeemed: Optional[bool] = Field(
        None,
        description='Czy został już wydany refresh token powiązany z danym uwierzytelnieniem.',
    )
    lastTokenRefreshDate: Optional[AwareDatetime] = Field(
        None, description='Data ostatniego odświeżenia tokena.'
    )
    refreshTokenValidUntil: Optional[AwareDatetime] = Field(
        None,
        description='Termin ważności refresh tokena (o ile nie zostanie wcześniej unieważniony).',
    )


class AuthenticationTokenRefreshResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    accessToken: TokenInfo = Field(
        ...,
        description='Token dostępu, którego należy używać w wywołaniach chronionych zasobów API.',
    )


class AuthenticationTokensResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    accessToken: TokenInfo = Field(..., description='Token dostępu.')
    refreshToken: TokenInfo = Field(
        ...,
        description='Token umożliwiający odświeżenie tokenu dostępu.\n> Więcej informacji:\n> - [Odświeżanie tokena](https://github.com/CIRFMF/ksef-docs/blob/main/uwierzytelnianie.md#5-od%C5%9Bwie%C5%BCenie-tokena-dost%C4%99powego-accesstoken)',
    )


class BatchFilePartInfo(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    ordinalNumber: conint(ge=1) = Field(
        ..., description='Numer sekwencyjny części pliku paczki.'
    )
    fileSize: conint(ge=1) = Field(
        ..., description='Rozmiar zaszyfrowanej części pliku paczki w bajtach.'
    )
    fileHash: str = Field(
        ...,
        description='Skrót SHA256 zaszyfrowanej części pliku paczki, zakodowany w formacie Base64.',
    )


class CertificateEnrollmentStatusResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    requestDate: AwareDatetime = Field(
        ..., description='Data złożenia wniosku certyfikacyjnego.'
    )
    status: StatusInfo = Field(
        ...,
        description='Informacje o aktualnym statusie.\n| Code | Description | Details |\n| --- | --- | --- |\n| 100 | Wniosek przyjęty do realizacji | - |\n| 200 | Wniosek obsłużony (certyfikat wygenerowany) | - |\n| 400 | Wniosek odrzucony | Klucz publiczny został już certyfikowany przez inny podmiot. |\n| 400 | Wniosek odrzucony | Osiągnięto dopuszczalny limit posiadanych certyfikatów. |\n| 500 | Nieznany błąd | - |\n| 550 | Operacja została anulowana przez system | Przetwarzanie zostało przerwane z przyczyn wewnętrznych systemu. Spróbuj ponownie |',
    )
    certificateSerialNumber: Optional[str] = Field(
        None,
        description='Numer seryjny wygenerowanego certyfikatu (w formacie szesnastkowym). \nZwracany w przypadku prawidłowego przeprocesowania wniosku certyfikacyjnego.',
    )


class CertificateSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: CertificateSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EffectiveContextLimits(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    onlineSession: OnlineSessionEffectiveContextLimits = Field(
        ..., description='Limity dla sesji interaktywnych.'
    )
    batchSession: BatchSessionEffectiveContextLimits = Field(
        ..., description='Limity dla sesji wsadowych.'
    )


class EffectiveSubjectLimits(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    enrollment: Optional[EnrollmentEffectiveSubjectLimits] = None
    certificate: Optional[CertificateEffectiveSubjectLimits] = None


class EnrollCertificateRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    certificateName: constr(
        pattern=r'^[a-zA-Z0-9_\-\ ąćęłńóśźżĄĆĘŁŃÓŚŹŻ]+$', min_length=5, max_length=100
    ) = Field(..., description='Nazwa własna certyfikatu.')
    certificateType: KsefCertificateType = Field(
        ...,
        description='Typ certyfikatu.\n| Wartość | Opis |\n| --- | --- |\n| Authentication | Certyfikat używany do uwierzytelnienia w systemie. |\n| Offline | Certyfikat używany wyłącznie do potwierdzania autentyczności wystawcy i integralności faktury w trybie offline |\n',
    )
    csr: str = Field(
        ...,
        description='Wniosek certyfikacyjny PKCS#10 (CSR) w formacie DER, zakodowany w formacie Base64.',
    )
    validFrom: Optional[AwareDatetime] = Field(
        None,
        description='Data rozpoczęcia ważności certyfikatu.\nJeśli nie zostanie podana, certyfikat będzie ważny od momentu jego wystawienia.',
    )


class EnrollCertificateResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny wniosku certyfikacyjnego.'
    )
    timestamp: AwareDatetime = Field(
        ..., description='Data złożenia wniosku certyfikacyjnego.'
    )


class EntityAuthorizationPermissionsSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EntityAuthorizationPermissionsSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=9, max_length=10) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EntityAuthorizationsAuthorIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EntityAuthorizationsAuthorIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EntityAuthorizationsAuthorizedEntityIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EntityAuthorizationsAuthorizedEntityIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=9, max_length=10) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EntityAuthorizationsAuthorizingEntityIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EntityAuthorizationsAuthorizingEntityIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=10) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EntityPermission(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EntityPermissionType = Field(..., description='Rodzaj uprawnienia.')
    canDelegate: Optional[bool] = Field(
        None,
        description='Flaga pozwalająca na pośrednie przekazywanie danego uprawnienia',
    )


class EntityPermissionsSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EntityPermissionsSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=10) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EntityPermissionsSubordinateEntityIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EntityPermissionsSubordinateEntityIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=10) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EntityRolesParentEntityIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EntityRolesParentEntityIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=10) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EuEntityAdministrationPermissionsContextIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EuEntityAdministrationPermissionsContextIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=15, max_length=25) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EuEntityAdministrationPermissionsSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EuEntityAdministrationPermissionsSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=64, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EuEntityPermissionsAuthorIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EuEntityPermissionsAuthorIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class EuEntityPermissionsSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: EuEntityPermissionsSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=64, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class ExceptionInfo(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    exceptionDetailList: Optional[Sequence[ExceptionDetails]] = None
    referenceNumber: Optional[constr(min_length=36, max_length=36)] = Field(
        None, description='Numer referencyjny.'
    )
    serviceCode: Optional[str] = None
    serviceCtx: Optional[str] = None
    serviceName: Optional[str] = None
    timestamp: Optional[AwareDatetime] = None


class ExceptionResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    exception: Optional[ExceptionInfo] = None


class ExportInvoicesResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny eksportu faktur.'
    )


class GenerateTokenRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    permissions: Sequence[TokenPermissionType] = Field(
        ..., description='Uprawnienia przypisane tokenowi.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis tokena.'
    )


class GenerateTokenResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny tokena KSeF.'
    )
    token: constr(max_length=160) = Field(..., description='Token KSeF.')


class IndirectPermissionsSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: IndirectPermissionsSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class IndirectPermissionsTargetIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: IndirectPermissionsTargetIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: Optional[constr(min_length=10, max_length=16)] = Field(
        None,
        description='Wartość identyfikatora. W przypadku typu AllPartners należy pozostawić puste. W pozostałych przypadkach pole jest wymagane.',
    )


class InitTokenAuthenticationRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    challenge: constr(min_length=36, max_length=36) = Field(
        ..., description='Wygenerowany wcześniej challenge.'
    )
    contextIdentifier: AuthenticationContextIdentifier = Field(
        ...,
        description='Identyfikator kontekstu do którego następuje uwierzytelnienie.',
    )
    encryptedToken: str = Field(
        ...,
        description="Zaszyfrowany token wraz z timestampem z challenge'a, w postaci `token|timestamp`, zakodowany w formacie Base64.",
    )
    authorizationPolicy: Optional[AuthorizationPolicy] = Field(
        None,
        description='Polityka autoryzacji żądań przy każdym użyciu tokena dostępu.',
    )


class InvoiceMetadataAuthorizedSubject(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    nip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='Nip podmiotu upoważnionego')
    name: Optional[constr(max_length=512)] = Field(
        None, description='Nazwa podmiotu upoważnionego.'
    )
    role: int = Field(
        ...,
        description='Rola podmiotu upoważnionego.\n| Wartość | Opis |\n| ---- | --- |\n| 1 | Organ egzekucyjny - w przypadku, o którym mowa w art. 106c pkt 1 ustawy |\n| 2 | Komornik sądowy - w przypadku, o którym mowa w art. 106c pkt 2 ustawy |\n| 3 | Przedstawiciel podatkowy - w przypadku gdy na fakturze występują dane przedstawiciela podatkowego, o którym mowa w art. 18a - 18d ustawy |',
    )


class InvoiceMetadataBuyer(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    identifier: InvoiceMetadataBuyerIdentifier = Field(
        ...,
        description='Identyfikator nabywcy.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| VatUe | Identyfikator VAT UE podmiotu unijnego |\n| Other | Inny identyfikator|\n| None  | Brak identyfikatora nabywcy |',
    )
    name: Optional[constr(max_length=512)] = Field(None, description='Nazwa nabywcy.')


class InvoiceMetadataSeller(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    nip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='Nip sprzedawcy.')
    name: Optional[constr(max_length=512)] = Field(
        None, description='Nazwa sprzedawcy.'
    )


class InvoiceMetadataThirdSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: ThirdSubjectIdentifierType = Field(
        ...,
        description='Typ identyfikatora podmiotu trzeciego.\n| Wartość | Opis |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| InternalId | Identyfikator wewnętrzny, składający się z numeru NIP i 5 cyfr. |\n| VatUe | Identyfikator VAT UE podmiotu unijnego |\n| Other | Inny identyfikator |\n| None | Brak identyfikatora podmiotu trzeciego |\n',
    )
    value: Optional[constr(max_length=50)] = Field(
        None, description='Wartość identyfikatora podmiotu trzeciego.'
    )


class InvoicePackagePart(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    ordinalNumber: conint(ge=1) = Field(
        ..., description='Numer sekwencyjny pliku części paczki.'
    )
    partName: constr(max_length=100) = Field(
        ..., description='Nazwa pliku części paczki.'
    )
    method: str = Field(
        ..., description='Metoda HTTP, której należy użyć przy pobieraniu pliku.'
    )
    url: AnyUrl = Field(
        ...,
        description='Adres URL, pod który należy wysłać żądanie pobrania części paczki.\nLink jest generowany dynamicznie w momencie odpytania o status operacji eksportu.\nNie podlega limitom API i nie wymaga przesyłania tokenu dostępowego przy pobraniu.\n\nOdpowiedź HTTP zawiera dodatkowe nagłówki:\n- `x-ms-meta-hash` – zaszyfrowanej części paczki, zakodowany w formacie Base64.',
    )
    partSize: conint(ge=1) = Field(..., description='Rozmiar części paczki w bajtach.')
    partHash: str = Field(
        ...,
        description='Skrót SHA256 pliku części paczki, zakodowany w formacie Base64.',
    )
    encryptedPartSize: conint(ge=1) = Field(
        ..., description='Rozmiar zaszyfrowanej części paczki w bajtach.'
    )
    encryptedPartHash: str = Field(
        ...,
        description='Skrót SHA256 zaszyfrowanej części paczki, zakodowany w formacie Base64.',
    )
    expirationDate: AwareDatetime = Field(
        ...,
        description='Data i godzina wygaśnięcia linku umożliwiającego pobranie części paczki.\nPo upływie tego momentu link przestaje być aktywny.',
    )


class InvoiceQueryDateRange(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    dateType: InvoiceQueryDateType = Field(
        ...,
        description='Typ daty, według której ma być zastosowany zakres.\n| Wartość | Opis |\n| --- | --- |\n| Issue | Data wystawienia faktury. |\n| Invoicing | Data przyjęcia faktury w systemie KSeF (do dalszego przetwarzania). |\n| PermanentStorage | Data trwałego zapisu faktury w repozytorium systemu KSeF. |\n',
    )
    from_: AwareDatetime = Field(
        ...,
        alias='from',
        description='Data początkowa zakresu w formacie ISO-8601 np. 2026-01-03T13:45:00+00:00.',
    )
    to: Optional[AwareDatetime] = Field(
        None,
        description='Data końcowa zakresu w formacie ISO-8601. Jeśli nie zostanie podana, przyjmowana jest bieżąca data i czas w UTC.',
    )
    restrictToPermanentStorageHwmDate: Optional[bool] = Field(
        None,
        description='Określa, czy system ma ograniczyć filtrowanie (zakres dateRange.to) do wartości `PermanentStorageHwmDate`.\n\n* Dotyczy wyłącznie zapytań z `dateType = PermanentStorage`,  \n* Gdy `true`, system ogranicza filtrowanie tak, aby wartość `dateRange.to` nie przekraczała wartości `PermanentStorageHwmDate`,  \n* Gdy `null` lub `false`, filtrowanie może wykraczać poza `PermanentStorageHwmDate`.',
    )


class InvoiceQueryFilters(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectType: InvoiceQuerySubjectType = Field(
        ...,
        description='Typ podmiotu, którego dotyczą kryteria filtrowania metadanych faktur.\nOkreśla kontekst, w jakim przeszukiwane są dane.\n| Wartość | Opis |\n| --- | --- |\n| Subject1 | Podmiot 1 - sprzedawca |\n| Subject2 | Podmiot 2 - nabywca |\n| Subject3 | Podmiot 3 |\n| SubjectAuthorized | Podmiot upoważniony |\n',
    )
    dateRange: InvoiceQueryDateRange = Field(
        ...,
        description='Typ i zakres dat, według którego filtrowane są faktury.\nMaksymalny dozwolony okres wynosi 3 miesiące w strefie UTC lub w strefie Europe/Warsaw (WAW).\n            \nFormat daty:\n * Daty muszą być przekazane w formacie ISO 8601, np. `yyyy-MM-ddTHH:mm:ss`.\n * Dopuszczalne są następujące warianty:\n   - z sufiksem `Z` (czas UTC),\n   - z jawnym offsetem, np. `+01:00`, `+03:00`,\n   - bez offsetu (interpretowane jako czas lokalny strefy Europe/Warsaw).\n   \nZasady interpretacji dat:\n * Daty z sufiksem `Z` są traktowane jako czas UTC.\n * Daty bez jawnie podanego offsetu są interpretowane jako czas lokalny strefy Europe/Warsaw (WAW).\n * Daty z jawnym offsetem (`+01:00`, `+08:00` itd.) są przeliczane z uwzględnieniem offsetu, a następnie walidowane w strefie UTC lub w strefie Europe/Warsaw (WAW).',
    )
    ksefNumber: Optional[
        constr(
            pattern=r'^([1-9](\d[1-9]|[1-9]\d)\d{7})-(20[2-9][0-9]|2[1-9]\d{2}|[3-9]\d{3})(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])-([0-9A-F]{6})-?([0-9A-F]{6})-([0-9A-F]{2})$',
            min_length=35,
            max_length=36,
        )
    ] = Field(None, description='Numer KSeF faktury (exact match).')
    invoiceNumber: Optional[constr(max_length=256)] = Field(
        None, description='Numer faktury nadany przez wystawcę (exact match).'
    )
    amount: Optional[InvoiceQueryAmount] = Field(
        None, description='Filtr kwotowy – brutto, netto lub VAT (z wartością).'
    )
    sellerNip: Optional[
        constr(
            pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
        )
    ] = Field(None, description='Nip sprzedawcy (exact match).')
    buyerIdentifier: Optional[InvoiceQueryBuyerIdentifier] = Field(
        None,
        description='Identyfikator nabywcy.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| VatUe | Identyfikator VAT UE podmiotu unijnego. |\n| Other | Inny identyfikator|\n| None  | Brak identyfikatora nabywcy |',
    )
    currencyCodes: Optional[Sequence[CurrencyCode]] = Field(
        None, description='Kody walut.'
    )
    invoicingMode: Optional[InvoicingMode] = Field(
        None, description='Tryb wystawienia faktury: online lub offline.'
    )
    isSelfInvoicing: Optional[bool] = Field(
        None, description='Czy faktura została wystawiona w trybie samofakturowania.'
    )
    formType: Optional[InvoiceQueryFormType] = Field(
        None,
        description='Typ dokumentu.\n| Wartość | Opis |\n| --- | --- |\n| FA | Faktura VAT |\n| PEF | Faktura PEF |\n| RR | Faktura RR |\n',
    )
    invoiceTypes: Optional[Sequence[InvoiceType]] = Field(
        None,
        description='Rodzaje faktur.\n| Wartość | Opis |\n| --- | --- |\n| Vat | (FA) Podstawowa |\n| Zal | (FA) Zaliczkowa |\n| Kor | (FA) Korygująca |\n| Roz | (FA) Rozliczeniowa |\n| Upr | (FA) Uproszczona |\n| KorZal | (FA) Korygująca fakturę zaliczkową |\n| KorRoz | (FA) Korygująca fakturę rozliczeniową |\n| VatPef | (PEF) Podstawowa |\n| VatPefSp | (PEF) Specjalizowana |\n| KorPef | (PEF) Korygująca |\n| VatRr | (RR) Podstawowa |\n| KorVatRr | (RR) Korygująca |\n',
    )
    hasAttachment: Optional[bool] = Field(None, description='Czy faktura ma załącznik.')


class OpenBatchSessionResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny sesji.'
    )
    partUploadRequests: Sequence[PartUploadRequest] = Field(
        ...,
        description='Dane wymagane do poprawnego przesłania poszczególnych części pliku paczki faktur.\n\nKażdą część pliku paczki zadeklarowaną w <b>fileParts</b> należy przesłać zgodnie z odpowiadającym jej obiektem w <b>partUploadRequests</b>.\nŁącznikiem pomiędzy deklaracją a instrukcją wysyłki jest pole <b>ordinalNumber</b>.\n\nDla każdej części należy:\n* zastosować metodę HTTP wskazaną w <b>method</b>,\n* ustawić adres z <b>url</b>,\n* dołączyć nagłówki z <b>headers</b>,\n* dołączyć treść części pliku w korpusie żądania.\n\n`Uwaga: nie należy dodawać do nagłówków token dostępu (accessToken).`\n \nKażdą część przesyła się oddzielnym żądaniem HTTP.Zwracane kody odpowiedzi:\n * <b>201</b> – poprawne przyjęcie pliku,\n * <b>400</b> – błędne dane,\n * <b>401</b> – nieprawidłowe uwierzytelnienie,\n * <b>403</b> – brak uprawnień do zapisu (np.upłynął czas na zapis).',
    )


class OpenOnlineSessionResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny sesji.'
    )
    validUntil: AwareDatetime = Field(
        ...,
        description='Termin ważności sesji. Po jego upływie sesja zostanie automatycznie zamknięta.',
    )


class PermissionsOperationResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny operacji nadania lub odbierania uprawnień.'
    )


class PermissionsOperationStatusResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    status: StatusInfo = Field(
        ...,
        description='Informacje o aktualnym statusie.\n| Code | Description | Details |\n| --- | --- | --- |\n| 100 | Operacja przyjęta do realizacji | - |\n| 200 | Operacja zakończona sukcesem | - |\n| 400 | Operacja zakończona niepowodzeniem | - |\n| 410 | Podane identyfikatory są niezgodne lub pozostają w niewłaściwej relacji | - |\n| 420 | Użyte poświadczenia nie mają uprawnień do wykonania tej operacji | - |\n| 430 | Kontekst identyfikatora nie odpowiada wymaganej roli lub uprawnieniom | - |\n| 440 | Operacja niedozwolona dla wskazanych powiązań identyfikatorów | - |\n| 450 | Operacja niedozwolona dla wskazanego identyfikatora lub jego typu | - |\n| 500 | Nieznany błąd | - |\n| 550 | Operacja została anulowana przez system | Przetwarzanie zostało przerwane z przyczyn wewnętrznych systemu. Spróbuj ponownie później. |',
    )


class PersonCreateRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    nip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='10 cyfrowy numer NIP.')
    pesel: constr(
        pattern=r'^\d{2}(?:0[1-9]|1[0-2]|2[1-9]|3[0-2]|4[1-9]|5[0-2]|6[1-9]|7[0-2]|8[1-9]|9[0-2])\d{7}$',
        min_length=11,
        max_length=11,
    ) = Field(..., description='11 cyfrowy numer PESEL.')
    isBailiff: bool
    description: constr(min_length=5, max_length=256)
    isDeceased: Optional[bool] = None
    createdDate: Optional[AwareDatetime] = Field(
        None,
        description='W przypadku wielokrotnego tworzenia danych testowych z tym samym identyfikatorem nie można podawać daty wcześniejszej ani takiej samej jak poprzednia.',
    )


class PersonIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonIdentifierType = Field(..., description='Typ identyfikatora.')
    value: constr(min_length=10, max_length=11) = Field(
        ..., description='Wartość identyfikatora.'
    )


class PersonPermissionsAuthorIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonPermissionsAuthorIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: Optional[constr(min_length=10, max_length=64)] = Field(
        None,
        description='Wartość identyfikatora. W przypadku typu System należy pozostawić puste. W pozostałych przypadkach pole jest wymagane.',
    )


class PersonPermissionsAuthorizedIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonPermissionsAuthorizedIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class PersonPermissionsContextIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonPermissionsContextIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=16) = Field(
        ..., description='Wartość identyfikatora.'
    )


class PersonPermissionsSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonPermissionsSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class PersonPermissionsTargetIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonPermissionsTargetIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: Optional[constr(min_length=10, max_length=16)] = Field(
        None,
        description='Wartość identyfikatora. W przypadku typu AllPartners należy pozostawić puste. W pozostałych przypadkach pole jest wymagane.',
    )


class PersonalPermissionsAuthorizedIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonalPermissionsAuthorizedIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class PersonalPermissionsContextIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonalPermissionsContextIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=16) = Field(
        ..., description='Wartość identyfikatora.'
    )


class PersonalPermissionsTargetIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: PersonalPermissionsTargetIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: Optional[constr(min_length=10, max_length=16)] = Field(
        None,
        description='Wartość identyfikatora. W przypadku typu AllPartners należy pozostawić puste. W pozostałych przypadkach pole jest wymagane.',
    )


class PublicKeyCertificate(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    certificate: str = Field(
        ...,
        description='Certyfikat klucza publicznego w formacie DER, zakodowany w formacie Base64.',
    )
    validFrom: AwareDatetime = Field(
        ..., description='Data początku obowiązywania certyfikatu.'
    )
    validTo: AwareDatetime = Field(
        ..., description='Data końca obowiązywania certyfikatu.'
    )
    usage: Sequence[PublicKeyCertificateUsage] = Field(
        ...,
        description='Operacje do których może być używany certyfikat.\n| Wartość | Opis |\n| --- | --- |\n| KsefTokenEncryption | Szyfrowanie tokenów KSeF przesyłanych w trakcie procesu uwierzytelniania. |\n| SymmetricKeyEncryption | Szyfrowanie klucza symetrycznego wykorzystywanego do szyfrowania przesyłanych faktur. |\n',
    )


class QueryTokensResponseItem(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny tokena KSeF.'
    )
    authorIdentifier: TokenAuthorIdentifierTypeIdentifier = Field(
        ..., description='Identyfikator osoby która wygenerowała token.'
    )
    contextIdentifier: TokenContextIdentifierTypeIdentifier = Field(
        ...,
        description='Identyfikator kontekstu, w którym został wygenerowany token i do którego daje dostęp.',
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis tokena.'
    )
    requestedPermissions: Sequence[TokenPermissionType] = Field(
        ..., description='Uprawnienia przypisane tokenowi.'
    )
    dateCreated: AwareDatetime = Field(
        ..., description='Data i czas utworzenia tokena.'
    )
    lastUseDate: Optional[AwareDatetime] = Field(
        None, description='Data ostatniego użycia tokena.'
    )
    status: AuthenticationTokenStatus = Field(
        ...,
        description='Status tokena.\n| Wartość | Opis |\n| --- | --- |\n| Pending | Token został utworzony ale jest jeszcze w trakcie aktywacji i nadawania uprawnień. Nie może być jeszcze wykorzystywany do uwierzytelniania. |\n| Active | Token jest aktywny i może być wykorzystywany do uwierzytelniania. |\n| Revoking | Token jest w trakcie unieważniania. Nie może już być wykorzystywany do uwierzytelniania. |\n| Revoked | Token został unieważniony i nie może być wykorzystywany do uwierzytelniania. |\n| Failed | Nie udało się aktywować tokena. Należy wygenerować nowy token, obecny nie może być wykorzystywany do uwierzytelniania. |\n',
    )
    statusDetails: Optional[Sequence[str]] = Field(
        None,
        description='Dodatkowe informacje na temat statusu, zwracane w przypadku błędów.',
    )


class SendInvoiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    invoiceHash: str = Field(
        ...,
        description='Skrót SHA256 oryginalnej faktury, zakodowany w formacie Base64.',
    )
    invoiceSize: conint(ge=1) = Field(
        ...,
        description='Rozmiar oryginalnej faktury w bajtach. Maksymalny rozmiar zależy od limitów ustawionych dla uwierzytelnionego kontekstu.',
    )
    encryptedInvoiceHash: str = Field(
        ...,
        description='Skrót SHA256 zaszyfrowanej faktury, zakodowany w formacie Base64.',
    )
    encryptedInvoiceSize: conint(ge=1) = Field(
        ..., description='Rozmiar zaszyfrowanej faktury w bajtach.'
    )
    encryptedInvoiceContent: str = Field(
        ...,
        description='Faktura zaszyfrowana algorytmem AES-256-CBC z dopełnianiem PKCS#7 (kluczem przekazanym przy otwarciu sesji), zakodowana w formacie Base64.',
    )
    offlineMode: Optional[bool] = Field(
        False,
        description='Określa, czy podatnik deklaruje tryb fakturowania "offline" dla przesyłanego dokumentu.',
    )
    hashOfCorrectedInvoice: Optional[str] = Field(
        None,
        description='Skrót SHA256 korygowanej faktury, zakodowany w formacie Base64. Wymagany przy wysyłaniu korekty technicznej faktury.',
    )


class SessionInvoiceStatusResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    ordinalNumber: conint(ge=1) = Field(
        ..., description='Numer sekwencyjny faktury w ramach sesji.'
    )
    invoiceNumber: Optional[constr(max_length=256)] = Field(
        None, description='Numer faktury.'
    )
    ksefNumber: Optional[
        constr(
            pattern=r'^([1-9](\d[1-9]|[1-9]\d)\d{7})-(20[2-9][0-9]|2[1-9]\d{2}|[3-9]\d{3})(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])-([0-9A-F]{6})-?([0-9A-F]{6})-([0-9A-F]{2})$',
            min_length=35,
            max_length=36,
        )
    ] = Field(None, description='Numer KSeF.')
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny faktury.'
    )
    invoiceHash: str = Field(
        ..., description='Skrót SHA256 faktury, zakodowany w formacie Base64.'
    )
    invoiceFileName: Optional[constr(max_length=128)] = Field(
        None,
        description='Nazwa pliku faktury (zwracana dla faktur wysyłanych wsadowo).',
    )
    acquisitionDate: Optional[AwareDatetime] = Field(
        None, description='Data nadania numeru KSeF.'
    )
    invoicingDate: AwareDatetime = Field(
        ...,
        description='Data przyjęcia faktury w systemie KSeF (do dalszego przetwarzania).',
    )
    permanentStorageDate: Optional[AwareDatetime] = Field(
        None,
        description='Data trwałego zapisu faktury w repozytorium KSeF. Wartość uzupełniana asynchronicznie w momencie trwałego zapisu; zawsze późniejsza niż <b>acquisitionDate</b>. Podczas sprawdzania statusu może być jeszcze niedostępna.',
    )
    upoDownloadUrl: Optional[AnyUrl] = Field(
        None,
        description='Adres do pobrania UPO. Link generowany jest przy każdym odpytaniu o status. \nDostęp odbywa się metodą `HTTP GET` i <b>nie należy</b> wysyłać tokenu dostępowego. \nLink nie podlega limitom API i wygasa po określonym czasie w `UpoDownloadUrlExpirationDate`.\n\nOdpowiedź HTTP zawiera dodatkowe nagłówki:\n- `x-ms-meta-hash` – skrót SHA-256 dokumentu UPO, zakodowany w formacie Base64.',
    )
    upoDownloadUrlExpirationDate: Optional[AwareDatetime] = Field(
        None,
        description='Data i godzina wygaśnięcia adresu. Po tej dacie link `UpoDownloadUrl` nie będzie już aktywny.',
    )
    invoicingMode: Optional[InvoicingMode] = Field(
        None, description='Tryb fakturowania (online/offline).'
    )
    status: InvoiceStatusInfo = Field(
        ...,
        description="Status faktury.\n\n| Code | Description | Details | Extensions |\n| --- | --- | --- | ---|\n| 100 | Faktura przyjęta do dalszego przetwarzania | - | - |\n| 150 | Trwa przetwarzanie | - | - |\n| 200 | Sukces | - | - |\n| 405 | Przetwarzanie anulowane z powodu błędu sesji | - | - |\n| 410 | Nieprawidłowy zakres uprawnień | - |  - |\n| 415 | Brak możliwości wysyłania faktury z załącznikiem | - | - |\n| 430 | Błąd weryfikacji pliku faktury | - | -  |\n| 435 | Błąd odszyfrowania pliku | - | - |\n| 440 | Duplikat faktury | - | 'originalSessionReferenceNumber', 'originalKsefNumber'|\n| 450 | Błąd weryfikacji semantyki dokumentu faktury | - | - |\n| 500 | Nieznany błąd ({statusCode}) | - | - |\n| 550 | Operacja została anulowana przez system | Przetwarzanie zostało przerwane z przyczyn wewnętrznych systemu. Spróbuj ponownie |- |",
    )


class SessionInvoicesResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    continuationToken: Optional[str] = Field(
        None,
        description='Token służący do pobrania kolejnej strony wyników. Jeśli jest pusty, to nie ma kolejnych stron.',
    )
    invoices: Sequence[SessionInvoiceStatusResponse] = Field(
        ..., description='Lista pobranych faktur.'
    )


class SessionStatusResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    status: StatusInfo = Field(
        ...,
        description='Informacje o aktualnym statusie.\n            \nSesja wsadowa:\n| Code | Description | Details |\n| --- | --- | --- |\n| 100 | Sesja wsadowa rozpoczęta | - |\n| 150 | Trwa przetwarzanie | - |\n| 200 | Sesja wsadowa przetworzona pomyślnie | - |\n| 405 | Błąd weryfikacji poprawności dostarczonych elementów paczki | - |\n| 415 | Błąd odszyfrowania dostarczonego klucza | - |\n| 420 | Przekroczony limit faktur w sesji | - |\n| 430 | Błąd dekompresji pierwotnego archiwum | - |\n| 435 | Błąd odszyfrowania zaszyfrowanych części archiwum | - |\n| 440 | Sesja anulowana | Przekroczono czas wysyłki |\n| 440 | Sesja anulowana | Nie przesłano faktur |\n| 445 | Błąd weryfikacji, brak poprawnych faktur | - |\n| 500 | Nieznany błąd ({statusCode}) | - |\n\nSesja interaktywna:\n| Code | Description | Details |\n| --- | --- | --- |\n| 100 | Sesja interaktywna otwarta | - |\n| 170 | Sesja interaktywna zamknięta | - |\n| 200 | Sesja interaktywna przetworzona pomyślnie | - |\n| 415 | Błąd odszyfrowania dostarczonego klucza | - |\n| 440 | Sesja anulowana | Nie przesłano faktur |\n| 445 | Błąd weryfikacji, brak poprawnych faktur | - |\n| * | description missing | - |',
    )
    dateCreated: AwareDatetime = Field(..., description='Data utworzenia sesji.')
    dateUpdated: AwareDatetime = Field(
        ..., description='Data ostatniej aktywności w ramach sesji.'
    )
    validUntil: Optional[AwareDatetime] = Field(
        None,
        description='Termin ważności sesji. Po jego upływie sesja zostanie automatycznie zamknięta.',
    )
    upo: Optional[UpoResponse] = Field(
        None,
        description='Informacja o UPO sesyjnym, zwracana gdy sesja została zamknięta i UPO zostało wygenerowane.',
    )
    invoiceCount: Optional[conint(ge=0)] = Field(
        None, description='Liczba przyjętych faktur w ramach sesji.'
    )
    successfulInvoiceCount: Optional[conint(ge=0)] = Field(
        None, description='Liczba faktur przeprocesowanych w ramach sesji z sukcesem .'
    )
    failedInvoiceCount: Optional[conint(ge=0)] = Field(
        None, description='Liczba faktur przeprocesowanych w ramach sesji z błędem.'
    )


class SessionsQueryResponseItem(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    referenceNumber: constr(min_length=36, max_length=36) = Field(
        ..., description='Numer referencyjny sesji.'
    )
    status: StatusInfo = Field(..., description='Status sesji.')
    dateCreated: AwareDatetime = Field(..., description='Data utworzenia sesji.')
    dateUpdated: AwareDatetime = Field(
        ..., description='Data ostatniej aktywności w ramach sesji.'
    )
    validUntil: Optional[AwareDatetime] = Field(
        None,
        description='Termin ważności sesji. Po jego upływie sesja interaktywna zostanie automatycznie zamknięta.',
    )
    totalInvoiceCount: conint(ge=0) = Field(
        ...,
        description='Łączna liczba faktur (uwzględnia również te w trakcie przetwarzania).',
    )
    successfulInvoiceCount: conint(ge=0) = Field(
        ..., description='Liczba poprawnie przetworzonych faktur.'
    )
    failedInvoiceCount: conint(ge=0) = Field(
        ..., description='Liczba błędnie przetworzonych faktur.'
    )


class SetSubjectLimitsRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectIdentifierType: Optional[SubjectIdentifierType] = None
    enrollment: Optional[EnrollmentSubjectLimitsOverride] = None
    certificate: Optional[CertificateSubjectLimitsOverride] = None


class SubjectCreateRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectNip: constr(
        pattern=r'^[1-9]((\d[1-9])|([1-9]\d))\d{7}$', min_length=10, max_length=10
    ) = Field(..., description='10 cyfrowy numer NIP.')
    subjectType: SubjectType
    subunits: Optional[Sequence[Subunit]] = None
    description: constr(min_length=5, max_length=256)
    createdDate: Optional[AwareDatetime] = Field(
        None,
        description='W przypadku wielokrotnego tworzenia danych testowych z tym samym identyfikatorem nie można podawać daty wcześniejszej ani takiej samej jak poprzednia.',
    )


class SubordinateEntityRolesQueryRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subordinateEntityIdentifier: Optional[
        EntityPermissionsSubordinateEntityIdentifier
    ] = Field(
        None,
        description='Identyfikator podmiotu podrzędnego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |',
    )


class SubordinateRoleSubordinateEntityIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: SubordinateRoleSubordinateEntityIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=10) = Field(
        ..., description='Wartość identyfikatora.'
    )


class SubunitPermissionsAuthorIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: SubunitPermissionsAuthorIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class SubunitPermissionsAuthorizedIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: SubunitPermissionsSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class SubunitPermissionsContextIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: SubunitPermissionsContextIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=16) = Field(
        ..., description='Wartość identyfikatora.'
    )


class SubunitPermissionsSubjectIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: SubunitPermissionsSubjectIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=64) = Field(
        ..., description='Wartość identyfikatora.'
    )


class SubunitPermissionsSubunitIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: SubunitPermissionsSubunitIdentifierType = Field(
        ..., description='Typ identyfikatora.'
    )
    value: constr(min_length=10, max_length=16) = Field(
        ..., description='Wartość identyfikatora.'
    )


class TestDataAuthenticationContextIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    value: str
    type: TestDataAuthenticationContextIdentifierType


class TestDataAuthorizedIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: TestDataAuthorizedIdentifierType
    value: constr(min_length=10, max_length=64)


class TestDataContextIdentifier(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    type: TestDataContextIdentifierType
    value: constr(min_length=10, max_length=10)


class TestDataPermission(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    description: constr(min_length=5, max_length=256)
    permissionType: TestDataPermissionType


class TestDataPermissionsGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    contextIdentifier: TestDataContextIdentifier
    authorizedIdentifier: TestDataAuthorizedIdentifier
    permissions: Sequence[TestDataPermission]


class TestDataPermissionsRevokeRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    contextIdentifier: TestDataContextIdentifier
    authorizedIdentifier: TestDataAuthorizedIdentifier


class UnblockContextAuthenticationRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    contextIdentifier: Optional[TestDataAuthenticationContextIdentifier] = None


class BatchFileInfo(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    fileSize: conint(ge=1, le=5000000000) = Field(
        ...,
        description='Rozmiar pliku paczki w bajtach. Maksymalny rozmiar paczki to 5GB.',
    )
    fileHash: str = Field(
        ..., description='Skrót SHA256 pliku paczki, zakodowany w formacie Base64.'
    )
    fileParts: Sequence[BatchFilePartInfo] = Field(
        ...,
        description='Informacje o częściach pliku paczki. Maksymalna liczba części to 50. Maksymalny dozwolony rozmiar części przed zaszyfrowaniem to 100MB.',
        max_length=50,
        min_length=1,
    )


class BlockContextAuthenticationRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    contextIdentifier: Optional[TestDataAuthenticationContextIdentifier] = None


class CertificateListItem(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    certificateSerialNumber: str = Field(
        ..., description='Numer seryjny certyfikatu (w formacie szesnastkowym).'
    )
    name: constr(max_length=100) = Field(..., description='Nazwa własna certyfikatu.')
    type: KsefCertificateType = Field(
        ...,
        description='Typ certyfikatu.\n| Wartość | Opis |\n| --- | --- |\n| Authentication | Certyfikat używany do uwierzytelnienia w systemie. |\n| Offline | Certyfikat używany wyłącznie do potwierdzania autentyczności wystawcy i integralności faktury w trybie offline |\n',
    )
    commonName: str = Field(
        ...,
        description='Nazwa powszechna (CN) podmiotu, dla którego wystawiono certyfikat.',
    )
    status: CertificateListItemStatus = Field(
        ...,
        description='Status certyfikatu.\n| Wartość | Opis |\n| --- | --- |\n| Active | Certyfikat jest aktywny i może zostać użyty do uwierzytelnienia lub realizacji operacji w trybie offline (w zależności od typu certyfikatu). |\n| Blocked | Certyfikat został zablokowany i nie może zostać użyty do uwierzytelnienia i realizacji operacji w trybie offline.            Status przejściowy do czasu zakończenia procesu unieważniania. |\n| Revoked | Certyfikat został unieważniony i nie może zostać użyty do uwierzytelnienia i realizacji operacji w trybie offline. |\n| Expired | Certyfikat wygasł i nie może zostać użyty do uwierzytelnienia i realizacji operacji w trybie offline. |\n',
    )
    subjectIdentifier: CertificateSubjectIdentifier = Field(
        ..., description='Identyfikator podmiotu, dla którego wystawiono certyfikat.'
    )
    validFrom: AwareDatetime = Field(
        ..., description='Data rozpoczęcia ważności certyfikatu.'
    )
    validTo: AwareDatetime = Field(..., description='Data wygaśnięcia certyfikatu.')
    lastUseDate: Optional[AwareDatetime] = Field(
        None, description='Data ostatniego użycia certyfikatu.'
    )
    requestDate: AwareDatetime = Field(
        ..., description='Data złożenia wniosku certyfikacyjnego.'
    )


class EntityAuthorizationGrant(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    id: constr(min_length=36, max_length=36) = Field(
        ..., description='Identyfikator uprawnienia.'
    )
    authorIdentifier: Optional[EntityAuthorizationsAuthorIdentifier] = Field(
        None,
        description='Identyfikator osoby nadającej uprawnienie.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    authorizedEntityIdentifier: EntityAuthorizationsAuthorizedEntityIdentifier = Field(
        ...,
        description='Identyfikator podmiotu uprawnionego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| PeppolId | Identyfikator dostawcy usług Peppol |',
    )
    authorizingEntityIdentifier: EntityAuthorizationsAuthorizingEntityIdentifier = (
        Field(
            ...,
            description='Identyfikator podmiotu uprawniającego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |',
        )
    )
    authorizationScope: InvoicePermissionType = Field(
        ..., description='Rodzaj uprawnienia.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia.'
    )
    subjectEntityDetails: Optional[PermissionsSubjectEntityByIdentifierDetails] = Field(
        None, description='Dane podmiotu uprawnionego.'
    )
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia obowiązywania uprawnienia.'
    )


class EntityAuthorizationPermissionsGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectIdentifier: EntityAuthorizationPermissionsSubjectIdentifier = Field(
        ...,
        description='Identyfikator podmiotu uprawnianego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| PeppolId | Identyfikator dostawcy usług Peppol |',
    )
    permission: EntityAuthorizationPermissionType = Field(
        ..., description='Rodzaj uprawnienia.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia'
    )
    subjectDetails: EntityDetails = Field(
        ..., description='Dane podmiotu, któremu nadawane są uprawnienia.'
    )


class EntityAuthorizationPermissionsQueryRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    authorizingIdentifier: Optional[EntityAuthorizationsAuthorizingEntityIdentifier] = (
        Field(
            None,
            description='Identyfikator podmiotu uprawniającego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |',
        )
    )
    authorizedIdentifier: Optional[EntityAuthorizationsAuthorizedEntityIdentifier] = (
        Field(
            None,
            description='Identyfikator podmiotu uprawnionego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| PeppolId | Identyfikator dostawcy usług Peppol |',
        )
    )
    queryType: QueryType = Field(
        ...,
        description='Typ zapytania.\n| Type | Value |\n| --- | --- |\n| Granted | Uprawnienia nadane innym podmiotom |\n| Received | Uprawnienia otrzymane od innych podmiotów |',
    )
    permissionTypes: Optional[Sequence[InvoicePermissionType]] = Field(
        None, description='Lista rodzajów wyszukiwanych uprawnień.'
    )


class EntityPermissionsGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectIdentifier: EntityPermissionsSubjectIdentifier = Field(
        ...,
        description='Identyfikator podmiotu.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |',
    )
    permissions: Sequence[EntityPermission] = Field(
        ...,
        description='Lista nadawanych uprawnień. Każda wartość może wystąpić tylko raz.',
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia'
    )
    subjectDetails: EntityDetails = Field(
        ..., description='Dane podmiotu, któremu nadawane są uprawnienia.'
    )


class EntityRole(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    parentEntityIdentifier: Optional[EntityRolesParentEntityIdentifier] = Field(
        None,
        description='Identyfikator podmiotu nadrzędnego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |',
    )
    role: EntityRoleType = Field(
        ..., description='Typ roli - powiązania z podmiotem nadrzędnym.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis roli.'
    )
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia obowiązywania roli.'
    )


class InvoiceExportRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    encryption: EncryptionInfo = Field(
        ..., description='Informacje wymagane do zaszyfrowania wyniku zapytania.'
    )
    filters: InvoiceQueryFilters = Field(
        ..., description='Zestaw filtrów do wyszukiwania faktur.'
    )


class InvoiceMetadataThirdSubject(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    identifier: InvoiceMetadataThirdSubjectIdentifier
    name: Optional[constr(max_length=512)] = Field(
        None, description='Nazwa podmiotu trzeciego.'
    )
    role: int = Field(
        ...,
        description='Rola podmiotu trzeciego.\n| Wartość | Opis |\n| ---- | --- |\n| 0 | Inna rola |\n| 1 | Faktor - w przypadku gdy na fakturze występują dane faktora |\n| 2 | Odbiorca - w przypadku gdy na fakturze występują dane jednostek wewnętrznych, oddziałów, wyodrębnionych w ramach nabywcy, które same nie stanowią nabywcy w rozumieniu ustawy |\n| 3 | Podmiot pierwotny - w przypadku gdy na fakturze występują dane podmiotu będącego w stosunku do podatnika podmiotem przejętym lub przekształconym, który dokonywał dostawy lub świadczył usługę. Z wyłączeniem przypadków, o których mowa w art. 106j ust.2 pkt 3 ustawy, gdy dane te wykazywane są w części Podmiot1K |\n| 4 | Dodatkowy nabywca - w przypadku gdy na fakturze występują dane kolejnych (innych niż wymieniony w części Podmiot2) nabywców |\n| 5 | Wystawca faktury - w przypadku gdy na fakturze występują dane podmiotu wystawiającego fakturę w imieniu podatnika. Nie dotyczy przypadku, gdy wystawcą faktury jest nabywca |\n| 6 | Dokonujący płatności - w przypadku gdy na fakturze występują dane podmiotu regulującego zobowiązanie w miejsce nabywcy |\n| 7 | Jednostka samorządu terytorialnego - wystawca |\n| 8 | Jednostka samorządu terytorialnego - odbiorca |\n| 9 | Członek grupy VAT - wystawca |\n| 10 | Członek grupy VAT - odbiorca |\n| 11 | Pracownik |',
    )


class InvoicePackage(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    invoiceCount: conint(ge=0, le=10000) = Field(
        ..., description='Łączna liczba faktur w paczce.'
    )
    size: conint(ge=0) = Field(..., description='Rozmiar paczki w bajtach.')
    parts: Sequence[InvoicePackagePart] = Field(
        ..., description='Lista dostępnych części paczki do pobrania.'
    )
    isTruncated: bool = Field(
        ...,
        description='Określa, czy wynik eksportu został ucięty z powodu przekroczenia limitu liczby faktur lub wielkości paczki.',
    )
    lastIssueDate: Optional[date] = Field(
        None,
        description='Data wystawienia ostatniej faktury ujętej w paczce.\nPole występuje wyłącznie wtedy, gdy paczka została ucięta i eksport był filtrowany po typie daty `Issue`.',
    )
    lastInvoicingDate: Optional[AwareDatetime] = Field(
        None,
        description='Data przyjęcia ostatniej faktury ujętej w paczce.\nPole występuje wyłącznie wtedy, gdy paczka została ucięta i eksport był filtrowany po typie daty `Invoicing`.',
    )
    lastPermanentStorageDate: Optional[AwareDatetime] = Field(
        None,
        description='Data trwałego zapisu ostatniej faktury ujętej w paczce.\nPole występuje wyłącznie wtedy, gdy paczka została ucięta i eksport był filtrowany po typie daty `PermanentStorage`.',
    )
    permanentStorageHwmDate: Optional[AwareDatetime] = Field(
        None,
        description='Dotyczy wyłącznie zapytań filtrowanych po typie daty <b>PermanentStorage</b>.\nJeśli zapytanie dotyczyło najnowszego okresu, wartość ta może być wartością nieznacznie skorygowaną względem górnej granicy podanej w warunkach zapytania.\nDla okresów starszych, będzie to zgodne z warunkami zapytania. \n\nSystem gwarantuje, że dane poniżej tej wartości są spójne i kompletne.\nPonowne zapytania obejmujące zakresem dane poniżej tego kroczącego znacznika czasu nie zwrócą w przyszłości innych wyników (np.dodatkowych faktur). \n\nDla dateType = Issue lub Invoicing – null.',
    )


class OpenBatchSessionRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    formCode: FormCode = Field(
        ...,
        description='Schemat faktur wysyłanych w ramach sesji.\n\nObsługiwane schematy:\n| SystemCode | SchemaVersion | Value |\n| --- | --- | --- |\n| [FA (2)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/FA/schemat_FA(2)_v1-0E.xsd) | 1-0E | FA |\n| [FA (3)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/FA/schemat_FA(3)_v1-0E.xsd) | 1-0E | FA |\n',
    )
    batchFile: BatchFileInfo = Field(
        ..., description='Informacje o przesyłanej paczce faktur.'
    )
    encryption: EncryptionInfo = Field(
        ...,
        description='Symetryczny klucz szyfrujący plik paczki, zaszyfrowany kluczem publicznym Ministerstwa Finansów.',
    )
    offlineMode: Optional[bool] = Field(
        False,
        description='Określa, czy podatnik deklaruje tryb fakturowania "offline" dla dokumentów przesyłanych w sesji wsadowej.',
    )


class PermissionsSubjectPersonByFingerprintDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectDetailsType: PersonSubjectByFingerprintDetailsType = Field(
        ...,
        description='Typ danych uprawnionej osoby fizycznej.\n| Wartość | Opis |\n| --- | --- |\n| PersonByFingerprintWithIdentifier | Osoba fizyczna posługująca się certyfikatem niezawierającym identyfikatora NIP ani PESEL, ale mająca NIP lub PESEL. |\n| PersonByFingerprintWithoutIdentifier | Osoba fizyczna posługująca się certyfikatem niezawierającym identyfikatora NIP ani PESEL i niemająca NIP ani PESEL. |\n',
    )
    firstName: constr(min_length=2, max_length=30) = Field(
        ..., description='Imię osoby fizycznej.'
    )
    lastName: constr(min_length=2, max_length=81) = Field(
        ..., description='Nazwisko osoby fizycznej.'
    )
    personIdentifier: Optional[PersonIdentifier] = Field(
        None, description='Identyfikator osoby fizycznej.'
    )
    birthDate: Optional[date] = Field(
        None, description='Data urodzenia osoby fizycznej.'
    )
    idDocument: Optional[IdDocument] = Field(
        None, description='Dane dokumentu tożsamości osoby fizycznej.'
    )


class PermissionsSubjectPersonDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectDetailsType: PersonSubjectDetailsType = Field(
        ...,
        description='Typ danych uprawnionej osoby fizycznej.\n| Wartość | Opis |\n| --- | --- |\n| PersonByIdentifier | Osoba fizyczna posługująca się Profilem Zaufanym lub certyfikatem zawierającym identyfikator NIP lub PESEL. |\n| PersonByFingerprintWithIdentifier | Osoba fizyczna posługująca się certyfikatem niezawierającym identyfikatora NIP ani PESEL, ale mająca NIP lub PESEL. |\n| PersonByFingerprintWithoutIdentifier | Osoba fizyczna posługująca się certyfikatem niezawierającym identyfikatora NIP ani PESEL i niemająca NIP ani PESEL. |\n',
    )
    firstName: constr(min_length=2, max_length=30) = Field(
        ..., description='Imię osoby fizycznej.'
    )
    lastName: constr(min_length=2, max_length=81) = Field(
        ..., description='Nazwisko osoby fizycznej.'
    )
    personIdentifier: Optional[PersonIdentifier] = Field(
        None, description='Identyfikator osoby fizycznej.'
    )
    birthDate: Optional[date] = Field(
        None, description='Data urodzenia osoby fizycznej.'
    )
    idDocument: Optional[IdDocument] = Field(
        None, description='Dane dokumentu tożsamości osoby fizycznej.'
    )


class PersonByFingerprintWithIdentifierDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    firstName: constr(min_length=2, max_length=30) = Field(
        ..., description='Imię osoby fizycznej.'
    )
    lastName: constr(min_length=2, max_length=81) = Field(
        ..., description='Nazwisko osoby fizycznej.'
    )
    identifier: PersonIdentifier = Field(
        ..., description='Identyfikator osoby fizycznej.'
    )


class PersonPermission(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    id: constr(min_length=36, max_length=36) = Field(
        ..., description='Identyfikator uprawnienia.'
    )
    authorizedIdentifier: PersonPermissionsAuthorizedIdentifier = Field(
        ...,
        description='Identyfikator osoby lub podmiotu uprawnionego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    contextIdentifier: Optional[PersonPermissionsContextIdentifier] = Field(
        None,
        description='Identyfikator kontekstu uprawnienia (dla uprawnień nadanych administratorom jednostek podrzędnych).\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    targetIdentifier: Optional[PersonPermissionsTargetIdentifier] = Field(
        None,
        description='Identyfikator podmiotu docelowego dla uprawnień nadanych pośrednio.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| AllPartners | Identyfikator oznaczający, że uprawnienie nadane w sposób pośredni jest typu generalnego |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    authorIdentifier: PersonPermissionsAuthorIdentifier = Field(
        ...,
        description='Identyfikator osoby lub podmiotu nadającego uprawnienie.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |\n| System | Identyfikator systemowy KSeF |',
    )
    permissionScope: PersonPermissionScope = Field(
        ..., description='Rodzaj uprawnienia.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia.'
    )
    subjectPersonDetails: Optional[PermissionsSubjectPersonDetails] = Field(
        None, description='Dane osoby uprawnionej.'
    )
    subjectEntityDetails: Optional[PermissionsSubjectEntityDetails] = Field(
        None, description='Dane podmiotu uprawnionego.'
    )
    permissionState: PermissionState = Field(..., description='Stan uprawnienia.')
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia obowiązywania uprawnienia.'
    )
    canDelegate: bool = Field(
        ...,
        description='Flaga określająca, czy uprawnienie ma być możliwe do dalszego przekazywania.',
    )


class PersonPermissionSubjectDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectDetailsType: PersonPermissionSubjectDetailsType = Field(
        ...,
        description='Typ danych podmiotu.\n| Wartość | Opis |\n| --- | --- |\n| PersonByIdentifier | Osoba fizyczna posługująca się Profilem Zaufanym lub certyfikatem zawierającym identyfikator NIP lub PESEL. |\n| PersonByFingerprintWithIdentifier | Osoba fizyczna posługująca się certyfikatem niezawierającym identyfikatora NIP ani PESEL, ale mająca NIP lub PESEL. |\n| PersonByFingerprintWithoutIdentifier | Osoba fizyczna posługująca się certyfikatem niezawierającym identyfikatora NIP ani PESEL i niemająca NIP ani PESEL. |\n',
    )
    personById: Optional[PersonDetails] = Field(
        None,
        description='Dane podmiotu.\n*Wymagane, gdy subjectDetailsType = PersonByIdentifier.*',
    )
    personByFpWithId: Optional[PersonByFingerprintWithIdentifierDetails] = Field(
        None,
        description='Dane podmiotu.\n*Wymagane, gdy subjectDetailsType = PersonByFingerprintWithIdentifier.*',
    )
    personByFpNoId: Optional[PersonByFingerprintWithoutIdentifierDetails] = Field(
        None,
        description='Dane podmiotu.\n*Wymagane, gdy subjectDetailsType = PersonByFingerprintWithoutIdentifier.*',
    )


class PersonPermissionsGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectIdentifier: PersonPermissionsSubjectIdentifier = Field(
        ...,
        description='Identyfikator osoby fizycznej.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    permissions: Sequence[PersonPermissionType] = Field(
        ...,
        description='Lista nadawanych uprawnień. Każda wartość może wystąpić tylko raz.',
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia'
    )
    subjectDetails: PersonPermissionSubjectDetails = Field(
        ..., description='Dane podmiotu, któremu nadawane są uprawnienia.'
    )


class PersonPermissionsQueryRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    authorIdentifier: Optional[PersonPermissionsAuthorIdentifier] = Field(
        None,
        description='Identyfikator osoby lub podmiotu nadającego uprawnienie.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |\n| System | Identyfikator systemowy KSeF |',
    )
    authorizedIdentifier: Optional[PersonPermissionsAuthorizedIdentifier] = Field(
        None,
        description='Identyfikator osoby lub podmiotu uprawnionego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    contextIdentifier: Optional[PersonPermissionsContextIdentifier] = Field(
        None,
        description='Identyfikator kontekstu uprawnienia (dla uprawnień nadanych administratorom jednostek podrzędnych).\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    targetIdentifier: Optional[PersonPermissionsTargetIdentifier] = Field(
        None,
        description='Identyfikator podmiotu docelowego dla uprawnień nadanych pośrednio.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| AllPartners | Identyfikator oznaczający, że uprawnienie nadane w sposób pośredni jest typu generalnego |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    permissionTypes: Optional[Sequence[PersonPermissionType]] = Field(
        None, description='Lista rodzajów wyszukiwanych uprawnień.'
    )
    permissionState: Optional[PermissionState] = Field(
        None,
        description='Stan uprawnienia. \n| Type | Value |\n| --- | --- |\n| Active | Uprawnienia aktywne |\n| Inactive | Uprawnienia nieaktywne, nadane w sposób pośredni |',
    )
    queryType: PersonPermissionsQueryType = Field(
        ...,
        description='Typ zapytania.\n| Type | Value |\n| --- | --- |\n| PermissionsInCurrentContext | Lista uprawnień obowiązujących w bieżącym kontekście |\n| PermissionsGrantedInCurrentContext | Lista uprawnień nadanych w bieżącym kontekście |',
    )


class PersonalPermission(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    id: constr(min_length=36, max_length=36) = Field(
        ..., description='Identyfikator uprawnienia.'
    )
    contextIdentifier: Optional[PersonalPermissionsContextIdentifier] = Field(
        None,
        description='Identyfikator kontekstu podmiotu, który nadał uprawnienia do obsługi faktur.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    authorizedIdentifier: Optional[PersonalPermissionsAuthorizedIdentifier] = Field(
        None,
        description='Identyfikator podmiotu uprawnionego, jeżeli jest inny niż identyfikator uwierzytelnionego klienta API.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |',
    )
    targetIdentifier: Optional[PersonalPermissionsTargetIdentifier] = Field(
        None,
        description='Identyfikator podmiotu docelowego dla uprawnień selektywnych nadanych pośrednio.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| AllPartners | Identyfikator oznaczający, że wyszukiwanie dotyczy uprawnień generalnych nadanych w sposób pośredni |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    permissionScope: PersonalPermissionScope = Field(
        ..., description='Rodzaj uprawnienia.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia.'
    )
    subjectPersonDetails: Optional[PermissionsSubjectPersonDetails] = Field(
        None, description='Dane osoby uprawnionej.'
    )
    subjectEntityDetails: Optional[PermissionsSubjectEntityDetails] = Field(
        None, description='Dane podmiotu uprawnionego.'
    )
    permissionState: PermissionState = Field(..., description='Stan uprawnienia.')
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia obowiązywania uprawnienia.'
    )
    canDelegate: bool = Field(
        ...,
        description='Flaga określająca, czy uprawnienie ma być możliwe do dalszego przekazywania.',
    )


class PersonalPermissionsQueryRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    contextIdentifier: Optional[PersonalPermissionsContextIdentifier] = Field(
        None,
        description='Identyfikator kontekstu podmiotu, który nadał uprawnienia do obsługi faktur.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    targetIdentifier: Optional[PersonalPermissionsTargetIdentifier] = Field(
        None,
        description='Identyfikator podmiotu docelowego dla uprawnień selektywnych nadanych pośrednio.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| AllPartners | Identyfikator oznaczający, że wyszukiwanie dotyczy uprawnień generalnych nadanych w sposób pośredni |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    permissionTypes: Optional[Sequence[PersonalPermissionType]] = Field(
        None, description='Lista rodzajów wyszukiwanych uprawnień.'
    )
    permissionState: Optional[PermissionState] = Field(
        None,
        description='Stan uprawnienia. \n| Type | Value |\n| --- | --- |\n| Active | Uprawnienia aktywne |\n| Inactive | Uprawnienia nieaktywne |',
    )


class QueryCertificatesResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    certificates: Sequence[CertificateListItem] = Field(
        ..., description='Lista certyfikatów spełniających kryteria wyszukiwania.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class QueryEntityAuthorizationPermissionsResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    authorizationGrants: Sequence[EntityAuthorizationGrant] = Field(
        ..., description='Lista odczytanych uprawnień.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class QueryEntityRolesResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    roles: Sequence[EntityRole] = Field(
        ..., description='Lista odczytanych ról podmiotu.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class QueryPersonPermissionsResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    permissions: Sequence[PersonPermission] = Field(
        ..., description='Lista odczytanych uprawnień.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class QueryPersonalPermissionsResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    permissions: Sequence[PersonalPermission] = Field(
        ..., description='Lista odczytanych uprawnień.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class QueryTokensResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    continuationToken: Optional[str] = Field(
        None,
        description='Token służący do pobrania kolejnej strony wyników. Jeśli jest pusty, to nie ma kolejnych stron.',
    )
    tokens: Sequence[QueryTokensResponseItem] = Field(
        ..., description='Lista tokenów uwierzytelniających.'
    )


class SessionsQueryResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    continuationToken: Optional[str] = Field(
        None,
        description='Token służący do pobrania kolejnej strony wyników. Jeśli jest pusty, to nie ma kolejnych stron.',
    )
    sessions: Sequence[SessionsQueryResponseItem] = Field(
        ..., description='Lista sesji.'
    )


class SubordinateEntityRole(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subordinateEntityIdentifier: SubordinateRoleSubordinateEntityIdentifier = Field(
        ...,
        description='Identyfikator podmiotu podrzędnego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |',
    )
    role: SubordinateEntityRoleType = Field(
        ..., description='Typ roli - powiązania z podmiotem nadrzędnym.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis powiązania.'
    )
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia obowiązywania powiązania.'
    )


class SubunitPermission(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    id: constr(min_length=36, max_length=36) = Field(
        ..., description='Identyfikator uprawnienia.'
    )
    authorizedIdentifier: SubunitPermissionsAuthorizedIdentifier = Field(
        ...,
        description='Identyfikator uprawnionego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    subunitIdentifier: SubunitPermissionsSubunitIdentifier = Field(
        ...,
        description='Identyfikator jednostki lub podmiotu podrzędnego.\n| Type | Value |\n| --- | --- |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |\n| Nip | 10 cyfrowy numer NIP |',
    )
    authorIdentifier: SubunitPermissionsAuthorIdentifier = Field(
        ...,
        description='Identyfikator uprawniającego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    permissionScope: SubunitPermissionScope = Field(
        ..., description='Rodzaj uprawnienia.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia.'
    )
    subjectPersonDetails: Optional[PermissionsSubjectPersonDetails] = Field(
        None, description='Dane osoby uprawnionej.'
    )
    subunitName: Optional[constr(min_length=5, max_length=256)] = Field(
        None, description='Nazwa jednostki podrzędnej.'
    )
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia obowiązywania uprawnienia.'
    )


class SubunitPermissionsGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectIdentifier: SubunitPermissionsSubjectIdentifier = Field(
        ...,
        description='Identyfikator podmiotu lub osoby fizycznej.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    contextIdentifier: SubunitPermissionsContextIdentifier = Field(
        ...,
        description='Identyfikator podmiotu podrzędnego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia'
    )
    subunitName: Optional[constr(min_length=5, max_length=256)] = Field(
        None,
        description='Nazwa jednostki podrzędnej. W przypadku jednostki podrzędnej z identyfikatorem wewnętrznym pole jest wymagane.',
    )
    subjectDetails: PersonPermissionSubjectDetails = Field(
        ..., description='Dane podmiotu, któremu nadawane są uprawnienia.'
    )


class SubunitPermissionsQueryRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subunitIdentifier: Optional[SubunitPermissionsSubunitIdentifier] = Field(
        None,
        description='Identyfikator jednostki lub podmiotu podrzędnego.\n| Type | Value |\n| --- | --- |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |\n| Nip | 10 cyfrowy numer NIP |',
    )


class EuEntityPermission(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    id: constr(min_length=36, max_length=36) = Field(
        ..., description='Identyfikator uprawnienia.'
    )
    authorIdentifier: EuEntityPermissionsAuthorIdentifier = Field(
        ...,
        description='Identyfikator uprawniającego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    vatUeIdentifier: str = Field(..., description='Identyfikator podmiotu unijnego.')
    euEntityName: constr(min_length=5, max_length=256) = Field(
        ..., description='Nazwa podmiotu unijnego.'
    )
    authorizedFingerprintIdentifier: constr(min_length=64, max_length=64) = Field(
        ..., description='Uprawniony odcisk palca certyfikatu.'
    )
    permissionScope: EuEntityPermissionsQueryPermissionType = Field(
        ..., description='Uprawnienie.'
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia.'
    )
    subjectPersonDetails: Optional[PermissionsSubjectPersonByFingerprintDetails] = (
        Field(None, description='Dane osoby uprawnionej.')
    )
    subjectEntityDetails: Optional[PermissionsSubjectEntityByFingerprintDetails] = (
        Field(None, description='Dane podmiotu uprawnionego.')
    )
    euEntityDetails: Optional[PermissionsEuEntityDetails] = Field(
        None,
        description='Dane podmiotu unijnego, w kontekście którego nadane jest uprawnienie.',
    )
    startDate: AwareDatetime = Field(
        ..., description='Data rozpoczęcia obowiązywania uprawnienia.'
    )


class EuEntityPermissionSubjectDetails(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectDetailsType: EuEntityPermissionSubjectDetailsType = Field(
        ...,
        description='Typ danych podmiotu.\n| Wartość | Opis |\n| --- | --- |\n| PersonByFingerprintWithIdentifier | Osoba fizyczna posługująca się certyfikatem niezawierającym identyfikatora NIP ani PESEL, ale mająca NIP lub PESEL. |\n| PersonByFingerprintWithoutIdentifier | Osoba fizyczna posługująca się certyfikatem niezawierającym identyfikatora NIP ani PESEL i niemająca NIP ani PESEL. |\n| EntityByFingerprint | Podmiot identyfikowany odciskiem palca pieczęci kwalifikowanej. |\n',
    )
    personByFpWithId: Optional[PersonByFingerprintWithIdentifierDetails] = Field(
        None,
        description='Dane podmiotu.\n*Wymagane, gdy subjectDetailsType = PersonByFingerprintWithIdentifier.*',
    )
    personByFpNoId: Optional[PersonByFingerprintWithoutIdentifierDetails] = Field(
        None,
        description='Dane podmiotu.\n*Wymagane, gdy subjectDetailsType = PersonByFingerprintWithoutIdentifier.*',
    )
    entityByFp: Optional[EntityByFingerprintDetails] = Field(
        None,
        description='Dane podmiotu.\n*Wymagane, gdy subjectDetailsType = EntityByFingerprint.*',
    )


class EuEntityPermissionsGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectIdentifier: EuEntityPermissionsSubjectIdentifier = Field(
        ...,
        description='Identyfikator podmiotu uprawnianego.\n| Type | Value |\n| --- | --- |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    permissions: Sequence[EuEntityPermissionType] = Field(
        ...,
        description='Lista nadawanych uprawnień. Każda wartość może wystąpić tylko raz.',
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia'
    )
    subjectDetails: EuEntityPermissionSubjectDetails = Field(
        ..., description='Dane podmiotu, któremu nadawane są uprawnienia.'
    )


class IndirectPermissionsGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectIdentifier: IndirectPermissionsSubjectIdentifier = Field(
        ...,
        description='Identyfikator osoby fizycznej.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| Pesel | 11 cyfrowy numer PESEL |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    targetIdentifier: Optional[IndirectPermissionsTargetIdentifier] = Field(
        None,
        description='Identyfikator kontekstu klienta. Nie przekazanie identyfikatora oznacza, że uprawnienie nadane w sposób pośredni jest typu generalnego.\n| Type | Value |\n| --- | --- |\n| Nip | 10 cyfrowy numer NIP |\n| AllPartners | Identyfikator oznaczający, że uprawnienie nadane w sposób pośredni jest typu generalnego |\n| InternalId | Dwuczłonowy identyfikator składający się z numeru NIP i 5 cyfr: `{nip}-{5_cyfr}` |',
    )
    permissions: Sequence[IndirectPermissionType] = Field(
        ...,
        description='Lista nadawanych uprawnień. Każda wartość może wystąpić tylko raz.',
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia'
    )
    subjectDetails: PersonPermissionSubjectDetails = Field(
        ..., description='Dane podmiotu, któremu nadawane są uprawnienia.'
    )


class InvoiceExportStatusResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    status: StatusInfo = Field(
        ...,
        description='Status eksportu.\n\n| Code | Description | Details |\n| --- | --- | --- |\n| 100 | Eksport faktur w toku | - |\n| 200 | Eksport faktur zakończony sukcesem | - |\n| 210 | Eksport faktur wygasł i nie jest już dostępny do pobrania | - |\n| 415 | Błąd odszyfrowania dostarczonego klucza  | - |\n| 420 | Zakres filtrowania wykracza poza dostępny zakres danych | Parametr dateRange.from jest późniejszy niż PermanentStorageHwmDate przy włączonym restrictToPermanentStorageHwmDate. |\n| 500 | Nieznany błąd ({statusCode}) | - |\n| 550 | Operacja została anulowana przez system | Przetwarzanie zostało przerwane z przyczyn wewnętrznych systemu. Spróbuj ponownie |',
    )
    completedDate: Optional[AwareDatetime] = Field(
        None, description='Data zakończenia przetwarzania żądania eksportu faktur.'
    )
    packageExpirationDate: Optional[AwareDatetime] = Field(
        None,
        description='Data wygaśnięcia paczki faktur przygotowanej do pobrania.\nPo upływie tej daty paczka nie będzie już dostępna do pobrania.',
    )
    package: Optional[InvoicePackage] = Field(
        None, description='Dane paczki faktur przygotowanej do pobrania.'
    )


class InvoiceMetadata(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    ksefNumber: constr(
        pattern=r'^([1-9](\d[1-9]|[1-9]\d)\d{7})-(20[2-9][0-9]|2[1-9]\d{2}|[3-9]\d{3})(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])-([0-9A-F]{6})-?([0-9A-F]{6})-([0-9A-F]{2})$',
        min_length=35,
        max_length=36,
    ) = Field(..., description='Numer KSeF faktury.')
    invoiceNumber: constr(max_length=256) = Field(
        ..., description='Numer faktury nadany przez wystawcę.'
    )
    issueDate: date = Field(..., description='Data wystawienia faktury.')
    invoicingDate: AwareDatetime = Field(
        ...,
        description='Data przyjęcia faktury w systemie KSeF (do dalszego przetwarzania).',
    )
    acquisitionDate: AwareDatetime = Field(..., description='Data nadania numeru KSeF.')
    permanentStorageDate: AwareDatetime = Field(
        ..., description='Data trwałego zapisu faktury w repozytorium systemu KSeF.'
    )
    seller: InvoiceMetadataSeller = Field(
        ..., description='Dane identyfikujące sprzedawcę.'
    )
    buyer: InvoiceMetadataBuyer = Field(..., description='Dane identyfikujące nabywcę.')
    netAmount: float = Field(..., description='Łączna kwota netto.')
    grossAmount: float = Field(..., description='Łączna kwota brutto.')
    vatAmount: float = Field(..., description='Łączna kwota VAT.')
    currency: constr(min_length=3, max_length=3) = Field(..., description='Kod waluty.')
    invoicingMode: InvoicingMode = Field(
        ..., description='Tryb fakturowania (online/offline).'
    )
    invoiceType: InvoiceType = Field(
        ...,
        description='Rodzaj faktury.\n| Wartość | Opis |\n| --- | --- |\n| Vat | (FA) Podstawowa |\n| Zal | (FA) Zaliczkowa |\n| Kor | (FA) Korygująca |\n| Roz | (FA) Rozliczeniowa |\n| Upr | (FA) Uproszczona |\n| KorZal | (FA) Korygująca fakturę zaliczkową |\n| KorRoz | (FA) Korygująca fakturę rozliczeniową |\n| VatPef | (PEF) Podstawowa |\n| VatPefSp | (PEF) Specjalizowana |\n| KorPef | (PEF) Korygująca |\n| VatRr | (RR) Podstawowa |\n| KorVatRr | (RR) Korygująca |\n',
    )
    formCode: FormCode = Field(
        ...,
        description='Struktura dokumentu faktury.\n\nObsługiwane schematy:\n| SystemCode | SchemaVersion | Value |\n| --- | --- | --- |\n| [FA (2)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/FA/schemat_FA(2)_v1-0E.xsd) | 1-0E | FA |\n| [FA (3)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/FA/schemat_FA(3)_v1-0E.xsd) | 1-0E | FA |\n| [PEF (3)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/PEF/Schemat_PEF(3)_v2-1.xsd) | 2-1 | PEF |\n| [PEF_KOR (3)](https://github.com/CIRFMF/ksef-docs/blob/main/faktury/schemy/PEF/Schemat_PEF_KOR(3)_v2-1.xsd) | 2-1 | PEF |\n| FA_RR (1) | 1-0E | RR |\n',
    )
    isSelfInvoicing: bool = Field(
        ..., description='Czy faktura została wystawiona w trybie samofakturowania.'
    )
    hasAttachment: bool = Field(
        ..., description='Określa, czy faktura posiada załącznik.'
    )
    invoiceHash: str = Field(
        ..., description='Skrót SHA256 faktury, zakodowany w formacie Base64.'
    )
    hashOfCorrectedInvoice: Optional[str] = Field(
        None,
        description='Skrót SHA256 korygowanej faktury, zakodowany w formacie Base64.',
    )
    thirdSubjects: Optional[Sequence[InvoiceMetadataThirdSubject]] = Field(
        None, description='Lista podmiotów trzecich.'
    )
    authorizedSubject: Optional[InvoiceMetadataAuthorizedSubject] = Field(
        None, description='Podmiot upoważniony.'
    )


class QueryEuEntityPermissionsResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    permissions: Sequence[EuEntityPermission] = Field(
        ..., description='Lista odczytanych uprawnień.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class QueryInvoicesMetadataResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    hasMore: bool = Field(
        ..., description='Określa, czy istnieją kolejne wyniki zapytania.'
    )
    isTruncated: bool = Field(
        ...,
        description='Określa, czy osiągnięto maksymalny dopuszczalny zakres wyników zapytania (10 000).',
    )
    permanentStorageHwmDate: Optional[AwareDatetime] = Field(
        None,
        description='Dotyczy wyłącznie zapytań filtrowanych po typie daty <b>PermanentStorage</b>.\nJeśli zapytanie dotyczyło najnowszego okresu, wartość ta może być wartością nieznacznie skorygowaną względem górnej granicy podanej w warunkach zapytania.\nDla okresów starszych, będzie to zgodne z warunkami zapytania. \n\nWartość jest stała dla wszystkich stron tego samego zapytania\ni nie zależy od paginacji ani sortowania.\n\nSystem gwarantuje, że dane poniżej tej wartości są spójne i kompletne.\nPonowne zapytania obejmujące zakresem dane poniżej tego kroczącego znacznika czasu nie zwrócą w przyszłości innych wyników (np.dodatkowych faktur). \n\nDla dateType = Issue lub Invoicing – null.',
    )
    invoices: Sequence[InvoiceMetadata] = Field(
        ..., description='Lista faktur spełniających kryteria.'
    )


class QuerySubordinateEntityRolesResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    roles: Sequence[SubordinateEntityRole] = Field(
        ..., description='Lista odczytanych podmiotów podrzędnych i ich ról.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class QuerySubunitPermissionsResponse(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    permissions: Sequence[SubunitPermission] = Field(
        ..., description='Lista odczytanych uprawnień.'
    )
    hasMore: bool = Field(
        ..., description='Flaga informująca o dostępności kolejnej strony wyników.'
    )


class EuEntityAdministrationPermissionsGrantRequest(BaseModel):
    model_config = ConfigDict(
        extra='ignore',
        populate_by_name=True,
    )
    subjectIdentifier: EuEntityAdministrationPermissionsSubjectIdentifier = Field(
        ...,
        description='Identyfikator podmiotu uprawnionego.\n| Type | Value |\n| --- | --- |\n| Fingerprint | Odcisk palca certyfikatu |',
    )
    contextIdentifier: EuEntityAdministrationPermissionsContextIdentifier = Field(
        ...,
        description='Identyfikator kontekstu złożonego.\n| Type | Value |\n| --- | --- |\n| NipVatUe | Dwuczłonowy identyfikator składający się z numeru NIP i numeru VAT-UE: `{nip}-{vat_ue}` |',
    )
    description: constr(min_length=5, max_length=256) = Field(
        ..., description='Opis uprawnienia'
    )
    euEntityName: constr(min_length=5, max_length=256) = Field(
        ...,
        description='Nazwa i adres podmiotu unijnego w formacie: \n`{euSubjectName}, {euSubjectAddress}`',
    )
    subjectDetails: EuEntityPermissionSubjectDetails = Field(
        ..., description='Dane podmiotu, któremu nadawane są uprawnienia.'
    )
    euEntityDetails: EuEntityDetails = Field(
        ...,
        description='Dane podmiotu unijnego, w kontekście którego nadawane są uprawnienia.',
    )
