# generated by datamodel-codegen:
#   filename:  ua.json
#   timestamp: 2025-09-19T19:17:42+00:00
# Poprawka BaseModel -> RootModel, gdy występuje root (__root__ -> root)

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from uuid import UUID

from pydantic import AnyUrl, BaseModel, RootModel, EmailStr, Field, constr


class DirectoryAdd(BaseModel):
    directoryName: Optional[constr(max_length=30)] = Field(
        None, description='Nazwa katalogu'
    )
    directoryLabel: Optional[str] = Field(None, description='Etykieta katalogu')


class DirectoryPatch(BaseModel):
    newDirectoryName: Optional[constr(max_length=30)] = Field(
        None, description='Nowa nazwa katalogu'
    )


class SubscriptionCreate(BaseModel):
    messageCallbackUrl: Optional[AnyUrl] = Field(
        None, description='URL serwera do notyfikacji przychodzących wiadomości'
    )
    evidenceCallbackUrl: Optional[str] = Field(
        None, description='URL serwera do notyfikacji przychodzących potwierdzeń'
    )
    inboxCallbackUrl: Optional[str] = Field(
        None,
        description='URL serwera do notyfikacji zakończenia przekazywania wiadomości z usługi do skrzynki ADE',
    )


class Contributor(BaseModel):
    firstName: Optional[str] = Field(None, description='Imię')
    lastName: Optional[str] = Field(None, description='Nazwisko')
    companyName: Optional[str] = Field(
        None, description='Nazwa firmy. PUH - max 50 znaków, PURDE - max 1900 znaków'
    )
    companyNameContinued: Optional[str] = Field(
        None, description='Nazwa firmy cd. PUH - max 100 znaków, PURDE - max 100 znaków'
    )


class Address(BaseModel):
    country: str = Field(..., description='państwo')
    street: str = Field(..., description='ulica')
    postalCode: str = Field(..., description='kod pocztowy')
    city: str = Field(..., description='miasto')
    buildingNumber: Optional[str] = Field(None, description='numer budynku')
    houseNumber: Optional[str] = Field(None, description='numer mieszkania')


class MessageAddressData(BaseModel):
    eDeliveryAddress: Optional[str] = Field(
        None, description='Adres e-Delivery', example='mailbox_address'
    )
    address: Optional[Address] = None
    contributor: Optional[Contributor] = None


class FileMetadata(BaseModel):
    fileId: Optional[UUID] = None # zmiana API
    filename: Optional[str] = Field(
        None, description='Nazwa pliku', example='document.pdf'
    )
    contentType: Optional[str] = Field(
        None, description='Typ MIME', example='text/plain'
    )
    size: Optional[int] = Field(None, description='Rozmiar pliku')
    alg: Optional[str] = Field(
        None,
        description='Nazwa algorytmu haszującego, jedyny dozwolony SHA-3',
        example='SHA-3',
    )
    hash: Optional[str] = Field(None, description='Hasz pliku')
    description: Optional[str] = Field(
        None, description='Opis pliku', example='Text document'
    )


class File(BaseModel):
    fileMetadata: Optional[FileMetadata] = None
    file: Optional[bytes] = None


class Label(BaseModel):
    label: Optional[str] = Field(
        None, example='INBOX, SENT, UNREAD, PUBLIC_ADMINISTRATION, TAXES'
    )
    messageLocation: Optional[str] = Field(
        None, description='directoryLabel', example='MOJ_NOWY_FOLDER'
    )


class ShippingService(Enum):
    electronic = 'electronic'
    hybrid = 'hybrid'


class Status(Enum):
    W_weryfikacji = 'W weryfikacji'
    Przekazana_do_wysyłki = 'Przekazana do wysyłki'
    Odrzucona = 'Odrzucona'
    Nadana = 'Nadana'
    Wysłana = 'Wysłana'
    Czeka_na_doręczenie = 'Czeka na doręczenie'
    Doręczona = 'Doręczona'
    Uznana_za_doręczoną = 'Uznana za doręczoną'
    Niedoręczona = 'Niedoręczona'


class MessageType(Enum):
    Message = 'Message'
    Evidence = 'Evidence'


class MessageControlData(BaseModel):
    opened: Optional[bool] = Field(
        None,
        description='Czy wiadomość została już odczytana. Ustawiany wyłącznie po stronie systemu obsługującego ADE',
    )
    status: Optional[Status] = Field(
        None,
        description='Status wiadomości. Ustawiany wyłącznie po stronie systemu obsługującego ADE',
    )
    statusDescription: Optional[str] = Field(
        None,
        description='Powód odrzucenia wiadomości. Może zawierać wiele opisów rozdzielonych średnikami (;)',
    )
    messageType: Optional[MessageType] = Field(None, description='Typ wiadomości')
    labels: Optional[List[Label]] = Field(
        None, description='Etykiety wskazujące na folder/lokalizację wiadomości'
    )


class MessageControlDataPatchResponse(BaseModel):
    messageId: Optional[str] = Field(None, description='Identyfikator wiadomości')
    opened: Optional[bool] = Field(
        None,
        description='Czy wiadomość została już odczytana. Ustawiany wyłącznie po stronie systemu obsługującego ADE',
    )
    status: Optional[Status] = Field(
        None,
        description='Status wiadomości. Ustawiany wyłącznie po stronie systemu obsługującego ADE',
    )
    statusDescription: Optional[str] = Field(
        None,
        description='Powód odrzucenia wiadomości. Może zawierać wiele opisów rozdzielonych średnikami (;)',
    )
    messageType: Optional[MessageType] = Field(None, description='Typ wiadomości')
    labels: Optional[List[Label]] = Field(
        None, description='Etykiety wskazujące na folder/lokalizację wiadomości'
    )


class Attachment(BaseModel):
    order: Optional[int] = Field(
        None, description='Numer kolejny załącznika w ramach wiadomości'
    )
    attachmentId: Optional[UUID] = Field(
        None,
        description='UUID załącznika',
        example='D41568F4-7175-42BB-9503-DAA282180D70',
    )
    file: Optional[File] = None # poprawka


class Type(Enum):
    A_1 = 'A.1'
    A_2 = 'A.2'
    B_1 = 'B.1'
    B_2 = 'B.2'
    B_3 = 'B.3'
    D_1 = 'D.1'
    D_2 = 'D.2'
    D_3 = 'D.3'
    E_1 = 'E.1'
    E_2 = 'E.2'
    BP_WX = 'BP.WX'
    BP_WP = 'BP.WP'
    BP_OX = 'BP.OX'
    BP_OP = 'BP.OP'
    H_DW = 'H.DW'
    H_PN = 'H.PN'
    H_EPO = 'H.EPO'


class Evidence(BaseModel):
    evidenceId: str = Field(..., description='ID potwierdzenia')
    messageId: str = Field(..., description='ID wiadomości')
    createDate: Optional[datetime] = Field(
        None,
        description='Data utworzenia potwierdzenia',
        example='2017-07-21T17:32:28.000Z',
    )
    eventDate: Optional[datetime] = Field(
        None,
        description='Czas zdarzenia dla potwierdzenia',
        example='2017-07-21T17:32:28.000Z',
    )
    reasonDetails: Optional[List[str]] = Field(None, description='Szczegóły powodu') # zmiana
    reasonId: Optional[str] = Field(None, description='Numer identyfikacyjny powodu')
    externalData: Optional[str] = Field(
        None, description='URL do wygenerowanego pliku potwierdzenia'
    )
    downloaded: Optional[bool] = Field(
        None, description='Czy potwierdzenie było wcześniej pobrane'
    )
    type: Optional[str] = Field(None, description='Typ potwierdzenia - kod')
    #  poprawka - występują na przykład 'BPOP'
    from_: Optional[MessageAddressData] = Field(None, alias='from')
    to: Optional[MessageAddressData] = None


class Settings(BaseModel):
    phoneNumber: Optional[str] = Field(
        None, description='numer telefonu - powiadomienia SMS'
    )
    email: Optional[EmailStr] = Field(None, description='email - powiadomienia email')
    settings: Optional[Dict[str, str]] = Field(
        None,
        description='Uzgodnione wartości klucz - totalCapacity (całkowita pojemność skrzynki w MB), usedCapacity - używana pojemność skrzynki w MB)',
    )


class NotificationInboxCallback(BaseModel):
    id: str = Field(
        ...,
        description='ID obiektu (w zależności od notyfikacji jest to ID wiadomości lub ID dowodu)',
    )
    threadId: Optional[str] = Field(
        None, description='ID wątku (wypełniane tylko dla notyfikacji InboxCallback)'
    )
    type: Optional[str] = Field(
        None, description='ID dowodu (wypełniane tylko dla notyfikacji NewEvidence'
    )


class Notification(Enum):
    on = 'on'
    off = 'off'


class SuccessInfo(BaseModel):
    status: str = Field(..., description='Status')
    notificationId: Optional[str] = Field(None, description='ID notyfikacji')
    eDeliveryAddress: Optional[str] = Field(
        None, description='Adres e-Delivery - ADE adresata'
    )
    notification: Optional[Notification] = Field(
        None, description='Czy subskrypcja włączona/wyłączona'
    )


class ThreadWrapper(BaseModel):
    threadId: Optional[str] = Field(None, description='Identyfikator wątku')
    caseIDs: Optional[List[str]] = Field(None, description='Numery sprawy')
    recipients: Optional[List[Contributor]] = Field(None, description='Adresaci')
    senders: Optional[List[Contributor]] = Field(None, description='Nadawcy')
    firstMessageTitle: Optional[str] = Field(
        None, description='Tytuł pierwszej wiadomości'
    )
    firstMessageSubmissionDate: Optional[datetime] = Field(
        None, description='Submission date pierwszej wiadomości'
    )
    firstMessagEventDate: Optional[datetime] = Field(
        None, description='Event date pierwszej wiadomości'
    )
    lastMessageSubmissionDate: Optional[datetime] = Field(
        None, description='Submission date ostatniej wiadomości'
    )
    lastMessagEventDate: Optional[datetime] = Field(
        None, description='Event date ostatniej wiadomości'
    )
    messagesCount: Optional[float] = Field(
        None, description='Liczba wiadomości w wątku'
    )


class ErrorInfo(BaseModel):
    error: str = Field(..., description='Kod błędu')
    error_description: str = Field(..., description='Opis błędu')
    messageId: Optional[str] = Field(None, description='ID wiadomości')


class DestinationDirectory(BaseModel):
    directoryId: Optional[str] = Field(None, description='Identyfikator katalogu')
    directoryName: Optional[str] = Field(None, description='Nazwa katalogu')
    directoryLabel: Optional[str] = Field(None, description='Etykieta katalogu')


class Op(Enum):
    add = 'add'
    remove = 'remove'
    replace = 'replace'
    move = 'move'
    copy = 'copy'
    test = 'test'


class PatchBodyItem(BaseModel):
    op: Op = Field(..., description='The operation to be performed')
    path: str = Field(..., description='A JSON-Pointer')
    value: Optional[Dict[str, Any]] = Field(
        None, description='The value to be used within the operations.'
    )


class PatchBody(RootModel):
    root: List[PatchBodyItem] = Field(..., max_items=1)


class ManageSubscriptionBody(BaseModel):
    subscriptionId: str = Field(..., description='Subscription ID')
    status: bool = Field(
        ..., description='Turn on/off subscription (true - on, false - off)'
    )


class Type1(Enum):
    predefined = 'predefined'
    defined = 'defined'


class Directory(BaseModel):
    directoryId: Optional[str] = Field(None, description='Identyfikator katalogu')
    name: Optional[str] = Field(None, description='Nazwa katalogu')
    label: Optional[str] = Field(None, description='Etykieta katalogu')
    type: Optional[Type1] = Field(
        None, description='Typ katalogu (definiowany/predefiniowany)'
    )


class MassageOperationResponseSingleWrapper(BaseModel):
    messageId: Optional[str] = Field(None, description='Identyfikator wiadomości')


class MassageOperationResponseSingleWrapperPut(BaseModel):
    messageId: Optional[str] = Field(None, description='Identyfikator wiadomości')
    warning: Optional[str] = Field(
        None, description='Ostrzeżenie o zbliżającym się przepełnieniu skrzynki'
    )


class MessageIds(BaseModel):
    messageIds: Optional[List[str]] = Field(
        None, description='Identyfikatory wiadomości'
    )


class AddresseeADE(RootModel):
    root: str = Field(..., description='Adres skrzynki ADE adresata')


class SendDraft(BaseModel):
    messageId: str = Field(..., description='Identyfikator wiadomości')


class StatusModel(RootModel):
    root: str = Field(..., description='Status')


class Subscription(BaseModel):
    id: str = Field(..., description='Identyfikator subskrypcji')
    name: str = Field(..., description='Nazwa subskrypcji')
    url: str = Field(..., description='URL do subskrypcji')
    status: bool = Field(
        ..., description='Czy subskrypcja włączona (true - włączona, false - wyłączona)'
    )


class ProcedingType(Enum):
    general = 'general'
    administrative = 'administrative'
    tax = 'tax'
    court_civil = 'court_civil'
    court_criminal = 'court_criminal'


class CategoryService(Enum):
    economic = 'economic'
    priority = 'priority'


class FormatService(Enum):
    XS = 'XS'
    S = 'S'
    M = 'M'
    L = 'L'


class PrintingMode(Enum):
    duplex = 'duplex'
    simplex = 'simplex'


class OverprintMode(Enum):
    monochrome = 'monochrome'
    color = 'color'


class ReturnService(Enum):
    returntosender = 'returntosender'
    destroy = 'destroy'


class ShippingMode(Enum):
    registered = 'registered'
    notRegistered = 'notRegistered'


class HybridShipment(BaseModel):
    shipmentNumber: Optional[constr(max_length=32)] = Field(
        None, description='Numer nadania przesyłki'
    )
    procedingType: ProcedingType = Field(
        ..., description='Nadanie przesyłki rejestrowanej na zasadach specjalnych'
    )
    sendersInformation: Optional[constr(max_length=30)] = Field(
        None, description='Pole 30-znakowe nadrukowywane na kopercie w polu nadawcy'
    )
    categoryService: CategoryService = Field(..., description='Termin doręczenia')
    formatService: Optional[FormatService] = Field(None, description='Format przesyłki')
    printingMode: PrintingMode = Field(
        ..., description='Sposób wydruku (jednostronny, dwustronny)'
    )
    overprintMode: OverprintMode = Field(
        ..., description='Rodzaj wydruku (biało-czarny, kolorowy)'
    )
    returnService: ReturnService = Field(
        ...,
        description='Sposób postępowania z przesyłką rejestrowaną w przypadku braku możliwości jej doręczenia',
    )
    proofOfDelivery: Optional[bool] = Field(None, description='Potwierdzenie odbioru')
    posteRestante: Optional[bool] = Field(None, description='Poste Restante')
    caseContent: Optional[constr(max_length=255)] = Field(
        None,
        description='Zawartość (tylko dla PUH krajowy rejestrowany, jeśli jest wybrany procedingType różne od General)',
    )
    shippingMode: ShippingMode = Field(
        ...,
        description='Przyjmuje wartości rejestrowany, nierejestrowany w przypadku gdy shippingService = publiczna usuga hybrydowa, pozostałe kwestie do ustalenia z PP',
    )


class FileWrapper(BaseModel):
    attachmentId: Optional[str] = Field(None, description='ID załącznika')
    warning: Optional[str] = Field(
        None, description='Ostrzeżenie o przepełnieniu skrzynki'
    )
    file : Optional[FileMetadata] = None


class EvidenceWrapper(BaseModel):
    evidences: Optional[List[Evidence]] = None
    warning: Optional[str] = Field(
        None, description='Ostrzeżenie o przepełnieniu skrzynki'
    )
"""
"""

class MessageMetadata(BaseModel):
    from_: Optional[MessageAddressData] = Field(None, alias='from')
    to: Optional[List[MessageAddressData]] = None
    hybridShipment: Optional[HybridShipment] = None
    subject: Optional[str] = Field(None, description='Tytuł wiadomości')
    messageId: Optional[str] = Field(None, description='ID wiadomości')
    refToMessageId: Optional[str] = Field(
        None, description='ID wiadomości do której wiadomość się odnosi'
    )
    threadId: Optional[str] = Field(None, description='ID wątku')
    caseId: Optional[str] = Field(None, description='ID sprawy')
    timestamp: Optional[datetime] = Field(
        None,
        description='Data utworzenia - określana po stronie systemu obsługującego ADE',
        example='2017-07-21T17:32:28.000Z',
    )
    receiptDate: Optional[datetime] = Field(
        None,
        description='Data doręczenia z biznesowego potwierdzenia otrzymania lub dowodu H.EPO',
        example='2017-07-21T17:32:28.000Z',
    )
    submissionDate: Optional[datetime] = Field(
        None,
        description='Wartość Submission Date and Time (M03) z dowodu A1 lub H.PN',
        example='2017-07-21T17:32:28.000Z',
    )
    eventDate: Optional[datetime] = Field(
        None,
        description='Wartość Event Time (G05) z dowodu A1 lub H.PN',
        example='2017-07-21T17:32:28.000Z',
    )
    shippingService: Optional[ShippingService] = Field(
        None,
        description='Wskazuje typ usługi. Dozwolone wartości: electronic (usługa elektronicznego doręczenia - RDE), hybrid (usługa hybrydowa - PUH)\n',
    )
    additionalData: Optional[Dict[str, str]] = Field(
        None, description='Dodatkowe dane - klucz -> wartość'
    )


class Message(BaseModel):
    messageControlData: Optional[MessageControlData] = None
    messageMetadata: Optional[MessageMetadata] = None
    textBody: Optional[str] = Field(None, description='Tekstowa część wiadomiści')
    attachments: Optional[List[Attachment]] = Field(None, description='Załączniki')
    evidences: Optional[List[Evidence]] = Field(
        None, description='Dowody nadania/odbioru'
    )


class MessagesWrapper(BaseModel):
    messages: List[Message] = Field(..., description='Wiadomości')
    total: Optional[int] = Field(
        None, description='Liczba wiadomości spełniających kryteria zapytania.'
    )
    electronicCount: Optional[int] = Field(
        None, description='Liczba wiadomości oczekujących na pobranie z usługi PURDE.'
    )
    warning: Optional[str] = Field(
        None, description='Ostrzeżenie o zbliżającym się przepełnieniu skrzynki'
    )


class MessageStatement(BaseModel):
    eDeliveryAddress: str = Field(..., description='Adres skrzynki ADE')
    notificationType: str
    electronicCount: Optional[int] = None
    notification: Optional[List[NotificationInboxCallback]] = None


class Threads(BaseModel):
    total: Optional[int] = Field(
        None, description='Liczba wiadomości spełniających kryteria zapytania.'
    )
    Thread: Optional[List[ThreadWrapper]] = None


class Thread(BaseModel):
    threadId: Optional[str] = Field(None, description='Identyfikator wątku')
    messages: Optional[MessagesWrapper] = None


class MassageOperationResponseWrapperPost(BaseModel):
    MessageId: Optional[str] = Field(None, description='Identyfikator wiadomości')
    AddresseeAde: Optional[AddresseeADE] = None
    Status: Optional[StatusModel] = None


class MassageOperationResponseWrapper(BaseModel):
    warning: Optional[str] = Field(
        None, description='Ostrzeżenie o zbliżającym się przepełnieniu skrzynki'
    )
    messageIds: Optional[MessageIds] = None


class MassageOperationResponseMultiWrapperPost(BaseModel):
    warning: Optional[str] = Field(
        None, description='Ostrzeżenie o zbliżającym się przepełnieniu skrzynki'
    )
    messages: Optional[List[MassageOperationResponseWrapperPost]] = None
