#!/bin/bash

HEIGHT=25
WIDTH=40
CHOICE_HEIGHT=15
BACKTITLE="Wybór opcji"
TITLE="Grupy przykładów"
MENU="Wybierz menu:"

OPTIONS=(1 "Szyfry"
         2 "Algorytmy"
         3 "Autoryzacja Linux"
         9 "bash"
         )

CHOICE=$(dialog --clear \
                --backtitle "$BACKTITLE" \
                --title "$TITLE" \
                --menu "$MENU" \
                $HEIGHT $WIDTH $CHOICE_HEIGHT \
                "${OPTIONS[@]}" \
                2>&1 >/dev/tty)

clear
if [[ ! "$CHOICE" =~ ^[0-9]+$ ]]; then
    echo "Nieprawidłowy wybór" >&2
    exit 1
fi
case $CHOICE in
        1)
            ./menu_crypt.sh
            ;;
        2)
            ./menu_alg.sh
            python p44_DH.py
            ;;
        3)
            ./menu_auth.sh
            ;;
        9)
            /bin/bash
            ;;
esac
./menu.sh