/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Color;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import rene.lister.Element;
import rene.util.FileName;
import rene.util.MyVector;
import rene.util.parser.StringParser;
import rene.util.sort.SortObject;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.construction.DepList;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.ExpressionString;
import rene.zirkel.expression.NoValueException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.Conditional;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructionObject
implements Cloneable,
SortObject,
Element {
    protected int ColorType = 0;
    public static final int NORMAL = 0;
    public static final int THICK = 1;
    public static final int THIN = 2;
    public static final int INVISIBLE = 3;
    protected int ColorIndex = 0;
    protected Color UserColor = null;
    protected Color UserLightColor = null;
    protected boolean Selected = false;
    protected boolean StrongSelected = false;
    protected boolean Indicated = false;
    protected boolean ShowIndicatedName = false;
    protected boolean LabelSelected = false;
    protected boolean Valid = true;
    protected boolean Hidden = false;
    protected boolean SuperHidden = false;
    protected boolean BreakHide = false;
    protected boolean ShowName = false;
    protected boolean ShowValue = false;
    protected boolean Selectable = true;
    protected String Name = "Generic";
    protected static int Count = 1;
    protected String Text = "???";
    private int XOffset = 0;
    private int YOffset = 0;
    protected double XcOffset = 0.0;
    protected double YcOffset = 0.0;
    protected boolean KeepClose;
    protected boolean DisplaysText = false;
    protected double TX1;
    protected double TY1;
    protected double TX2;
    protected double TY2;
    protected Construction Cn;
    protected boolean MainParameter;
    protected boolean Parameter;
    protected boolean Target;
    public boolean Flag;
    public boolean RekFlag;
    public boolean IsDrawn;
    public boolean HasZ;
    public int Scratch;
    protected boolean Keep = false;
    protected boolean JobTarget = false;
    protected boolean NoCheckTarget = false;
    protected ConstructionObject Translation;
    protected boolean Back = false;
    protected boolean Obtuse = true;
    protected boolean Break = false;
    protected boolean HideBreak = false;
    protected boolean Solid = false;
    static Count N = new Count();
    protected boolean inConstruction;
    protected String Unit = "";
    protected boolean Bold = false;
    protected boolean Large = false;
    protected Vector Conditionals;
    protected int NCount = 0;
    protected boolean gotNCount = false;
    protected int Ticks = 0;
    public static DepList DL = new DepList();
    int OldColorIndex;
    public double Value = 1000.0;
    ExpressionString AliasES = null;
    public MyVector VRek;
    public boolean RekValidating = false;
    public static final int DescriptionState = 0;
    public static final int FormulaState = 1;
    public static final int SizeState = 2;
    public boolean SpecialParameter = false;
    MyVector MV;
    boolean MVInUse = false;
    boolean Decorative = false;
    boolean FillBackground = false;

    public boolean isGotNCount() {
        return this.gotNCount;
    }

    public void setGotNCount(boolean gotNCount) {
        this.gotNCount = gotNCount;
    }

    public ConstructionObject(Construction c2) {
        this.Cn = c2;
        this.inConstruction = true;
        this.setName();
    }

    public ConstructionObject(Construction c2, String name) {
        this.Cn = c2;
        this.inConstruction = true;
        this.setName(name);
    }

    public void setName() {
        this.Name = this.Cn.LongNames ? String.valueOf(Zirkel.name("name." + this.getTag())) + " " + this.getN() : String.valueOf(Zirkel.name("name.short." + this.getTag())) + this.getN();
    }

    public int getN() {
        return N.next();
    }

    public String getTag() {
        return "Generic";
    }

    public ConstructionObject getTranslation() {
        return this.Translation;
    }

    public void setTranslation(ConstructionObject t) {
        this.Translation = t;
    }

    public void translate() {
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
    }

    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    public boolean nearto(int x, int y, boolean ignorefill, ZirkelCanvas zc) {
        return this.nearto(x, y, zc);
    }

    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return true;
    }

    public boolean textcontains(int x, int y, ZirkelCanvas zc) {
        if (!this.DisplaysText || !this.Valid || this.isHidden() && !zc.showHidden()) {
            return false;
        }
        return (double)x > this.TX1 && (double)x < this.TX2 && (double)y > this.TY1 && (double)y < this.TY2;
    }

    public void setSelected(boolean flag) {
        this.Selected = flag;
        this.StrongSelected = false;
    }

    public void setStrongSelected(boolean flag) {
        this.StrongSelected = flag;
    }

    public boolean isStrongSelected() {
        return this.StrongSelected;
    }

    public boolean selected() {
        return this.Selected || this.StrongSelected;
    }

    public void setLabelSelected(boolean flag) {
        this.LabelSelected = flag;
    }

    public boolean isSelectable() {
        return this.valid() && !this.JobTarget && this.Selectable;
    }

    public void validate() {
        this.Valid = true;
    }

    public boolean valid() {
        return this.Valid;
    }

    public boolean displays(ZirkelCanvas zc) {
        if (this.SuperHidden) {
            return false;
        }
        if (!zc.showHidden() && (this.testConditional("hidden") || this.testConditional("superhidden"))) {
            return false;
        }
        return this.Valid && !this.BreakHide && (!this.Hidden || zc.showHidden());
    }

    public boolean indicated() {
        return this.Indicated;
    }

    public void setIndicated(boolean f2) {
        this.Indicated = f2;
    }

    public void setIndicated(boolean f2, boolean showname) {
        this.Indicated = f2;
        this.ShowIndicatedName = showname;
    }

    public double changedBy() {
        return 0.0;
    }

    public static String text1(String format, String s1) {
        StringTokenizer t = ConstructionObject.tokenize(format);
        String s = "Illegal Format";
        try {
            s = String.valueOf(t.nextToken()) + s1;
            s = String.valueOf(s) + t.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.trim();
    }

    public static String text2(String format, String s1, String s2) {
        StringTokenizer t = ConstructionObject.tokenize(format);
        String s = "Illegal Format";
        try {
            s = String.valueOf(t.nextToken()) + s1 + t.nextToken() + s2;
            s = String.valueOf(s) + t.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.trim();
    }

    public static String text3(String format, String s1, String s2, String s3) {
        StringTokenizer t = ConstructionObject.tokenize(format);
        String s = "Illegal Format";
        try {
            s = String.valueOf(t.nextToken()) + s1 + t.nextToken() + s2 + t.nextToken() + s3;
            s = String.valueOf(s) + t.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.trim();
    }

    public static String text4(String format, String s1, String s2, String s3, String s4) {
        StringTokenizer t = ConstructionObject.tokenize(format);
        String s = "Illegal Format";
        try {
            s = String.valueOf(t.nextToken()) + s1 + t.nextToken() + s2 + t.nextToken() + s3 + t.nextToken() + s4;
            s = String.valueOf(s) + t.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static String textAny(String format, String[] ss) {
        StringTokenizer t = ConstructionObject.tokenize(format);
        String s = "Illegal Format";
        try {
            s = t.nextToken();
            int i = 0;
            while (i < ss.length) {
                s = String.valueOf(s) + ss[i];
                if (i < ss.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
            s = String.valueOf(s) + t.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    private static StringTokenizer tokenize(String format) {
        if (format.startsWith("%")) {
            format = " " + format;
        }
        if (format.endsWith("%")) {
            format = String.valueOf(format) + " ";
        }
        return new StringTokenizer(format, "%");
    }

    public void setText(String s, boolean user) {
        if (!user && this.Text.endsWith(" ")) {
            return;
        }
        this.Text = s;
    }

    public void setText(String s) {
        this.setText(s, false);
    }

    public String getText() {
        return this.Text;
    }

    public boolean labelSelected() {
        return this.LabelSelected;
    }

    public void setColor(int index) {
        if (index >= 0) {
            this.ColorIndex = index;
        }
        this.UserColor = null;
    }

    public void setColor(Color C) {
        this.UserColor = C;
        Color back = Color.gray.brighter();
        int red = back.getRed();
        int green = back.getGreen();
        int blue = back.getBlue();
        double lambda = 0.4;
        int r = (int)((double)red * (1.0 - lambda) + (double)C.getRed() * lambda);
        int g = (int)((double)green * (1.0 - lambda) + (double)C.getGreen() * lambda);
        int b2 = (int)((double)blue * (1.0 - lambda) + (double)C.getBlue() * lambda);
        this.UserLightColor = new Color(r, g, b2);
    }

    public int getColorIndex(boolean original) {
        if (!original && this.haveConditionals()) {
            int i = 0;
            while (i < ZirkelFrame.ColorStrings.length) {
                if (this.testConditional(ZirkelFrame.ColorStrings[i])) {
                    return i;
                }
                ++i;
            }
        }
        return this.ColorIndex;
    }

    public boolean hasUserColor() {
        return this.UserColor != null;
    }

    public Color getUserColor() {
        return this.UserColor;
    }

    public int getColorIndex() {
        return this.getColorIndex(false);
    }

    public Color getColor() {
        if (this.isJobTarget()) {
            if (this.isNoCheckTarget()) {
                return ZirkelFrame.NoCheckTargetColor;
            }
            return ZirkelFrame.TargetColor;
        }
        if (this.indicated()) {
            return ZirkelFrame.IndicateColor;
        }
        if (this.selected()) {
            return ZirkelFrame.SelectColor;
        }
        if (this.getColorType() == 2) {
            int i = this.getColorIndex();
            if (this.UserColor == null) {
                if (this.isHidden()) {
                    return ZirkelFrame.BrighterLightColors[i];
                }
                return ZirkelFrame.LightColors[i];
            }
            if (this.isHidden()) {
                return this.UserColor.brighter().brighter();
            }
            return this.UserColor.brighter();
        }
        int i = this.getColorIndex();
        if (this.UserColor == null) {
            if (this.isHidden()) {
                return ZirkelFrame.BrighterColors[i];
            }
            return ZirkelFrame.Colors[i];
        }
        if (this.isHidden()) {
            return this.UserColor.brighter().brighter();
        }
        return this.UserColor;
    }

    public Color getNormalColor() {
        if (this.UserColor == null) {
            return ZirkelFrame.Colors[this.getColorIndex()];
        }
        return this.UserColor;
    }

    public Color getBrighterColor() {
        if (this.UserColor == null) {
            return ZirkelFrame.BrighterColors[this.getColorIndex()];
        }
        return this.UserColor.brighter();
    }

    public Color getLightColor() {
        if (this.UserColor == null) {
            return ZirkelFrame.LightColors[this.getColorIndex()];
        }
        return this.UserLightColor;
    }

    public Color getBrighterLightColor() {
        if (this.UserColor == null) {
            return ZirkelFrame.BrighterLightColors[this.getColorIndex()];
        }
        return this.UserLightColor.brighter();
    }

    @Override
    public Color getElementColor() {
        return this.getColor();
    }

    public boolean mustHide(ZirkelCanvas zc) {
        if (!this.Valid) {
            return true;
        }
        if (this.ColorIndex > 0 && zc.getShowColor() != 0 && zc.getShowColor() != this.ColorIndex) {
            return true;
        }
        if (this.JobTarget && this.Hidden) {
            return true;
        }
        return this.SuperHidden || this.testConditional("superhidden") || this.BreakHide || zc.hides(this) || this.isHidden() && !zc.showHidden();
    }

    public void setHidden(boolean flag) {
        this.Hidden = flag;
        if (!flag) {
            this.SuperHidden = false;
        }
    }

    public void setSuperHidden(boolean flag) {
        this.SuperHidden = flag;
    }

    public void toggleHidden() {
        boolean bl = this.Hidden = !this.Hidden;
        if (!this.Hidden) {
            this.SuperHidden = false;
        }
    }

    public boolean isHidden(boolean original) {
        if (!original && this.testConditional("visible")) {
            return false;
        }
        if (!original && (this.testConditional("hidden") || this.testConditional("superhidden"))) {
            return true;
        }
        return this.Hidden || this.SuperHidden;
    }

    public boolean isHidden() {
        return this.isHidden(false);
    }

    public boolean isSuperHidden(boolean original) {
        if (!original && this.testConditional("superhidden")) {
            return true;
        }
        return this.SuperHidden;
    }

    public boolean isSuperHidden() {
        return this.isSuperHidden(false);
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String n) {
        this.Name = "";
        if (this.Cn != null) {
            ConstructionObject o = this.Cn.find(n);
            while (o != null && o != this) {
                n = String.valueOf(n) + "*";
                o = this.Cn.find(n);
            }
        }
        this.Name = n;
    }

    public void setNameCheck(String n) throws ConstructionException {
        ConstructionObject o;
        boolean extend = false;
        this.Name = "";
        if (this.Cn != null && (o = this.Cn.find(n)) != null && o != this) {
            n = String.valueOf(n) + "*";
            o = this.Cn.find(n);
            extend = true;
        }
        this.Name = n;
        if (extend) {
            throw new ConstructionException(Zirkel.name("exception.double"));
        }
    }

    public void setNameWithNumber(String n) {
        this.Name = "";
        if (this.Cn != null) {
            ConstructionObject o = this.Cn.find(n);
            if (o != null) {
                while (o != null && o != this) {
                    this.setName();
                    n = this.Name;
                    this.Name = "";
                    o = this.Cn.find(n);
                }
                this.Name = n;
            } else {
                this.Name = n;
            }
        } else {
            this.Name = n;
        }
    }

    public void edit(ZirkelCanvas zc) {
        zc.repaint();
    }

    public void drawLabel(MyGraphics g, String s) {
        g.drawStringExtended(s, this.TX1, this.TY1);
        this.TX2 = this.TX1 + (double)g.stringWidth(s);
        this.TY2 = this.TY1 + (double)g.stringHeight(s);
    }

    public void setFont(MyGraphics g) {
        g.setFont(this.Large, this.Bold);
    }

    public void drawCenteredLabel(MyGraphics g, String s, ZirkelCanvas zc, double x, double y, double xo, double yo) {
        int ws = g.stringWidth(s);
        int hs = g.stringHeight(s);
        this.TX1 = zc.col(x + xo) - (double)(ws / 2);
        this.TY1 = zc.row(y + yo) - (double)(hs / 2);
        g.drawStringExtended(s, this.TX1, this.TY1);
        this.TX2 = this.TX1 + (double)ws;
        this.TY2 = this.TY1 + (double)hs;
    }

    public void drawLabel(MyGraphics g, String s, ZirkelCanvas zc, double x, double y, double vx, double vy, double xo, double yo) {
        double d2;
        int ws = g.stringWidth(s);
        int hs = g.stringHeight(s);
        double w = zc.dx(ws);
        double h = zc.dy(hs);
        double d1 = Math.abs(-w * vy + h * vx);
        double d22 = Math.abs(w * vy + h * vx);
        if (d22 > (d2 = d1)) {
            d2 = d22;
        }
        double dd = zc.dy(2.0 * zc.pointSize());
        this.TX1 = zc.col(x - vy * (d2 + 3.0 * dd) / 2.0 + xo) - (double)(ws / 2);
        this.TY1 = zc.row(y + vx * (d2 + 3.0 * dd) / 2.0 + yo) - (double)(hs / 2);
        g.drawStringExtended(s, this.TX1, this.TY1);
        this.TX2 = this.TX1 + (double)ws;
        this.TY2 = this.TY1 + (double)hs;
    }

    public void drawPointLabel(MyGraphics g, String s, ZirkelCanvas zc, double x, double y, double vx, double vy, double xo, double yo) {
        double d2;
        int ws = g.stringWidth(s);
        int hs = g.stringHeight(s);
        double w = zc.dx(ws);
        double h = zc.dy(hs);
        double d1 = Math.abs(-w * vy + h * vx);
        double d22 = Math.abs(w * vy + h * vx);
        if (d22 > (d2 = d1)) {
            d2 = d22;
        }
        double dd = zc.dy(2.0 * zc.pointSize());
        if (Math.abs(d2 * vx) > h + 2.0 * dd) {
            d2 = Math.abs((h + 2.0 * dd) / vx);
        }
        double xp = x - vy * d2 / 2.0;
        double yp = y + vx * d2 / 2.0;
        this.TX1 = zc.col(xp - vy * dd * 1.5 + xo) - (double)(ws / 2);
        this.TY1 = zc.row(yp + vx * dd * 1.5 + yo) - (double)(hs / 2);
        g.drawStringExtended(s, this.TX1, this.TY1);
        this.TX2 = this.TX1 + (double)ws;
        this.TY2 = this.TY1 + (double)hs;
    }

    public static Color translate(String s, Color cdef) {
        int red = 0;
        int green = 0;
        int blue = 0;
        if (s.startsWith("#") && s.length() == 7) {
            red = Integer.parseInt(s.substring(1, 3), 16);
            green = Integer.parseInt(s.substring(3, 5), 16);
            blue = Integer.parseInt(s.substring(5, 7), 16);
        } else {
            StringParser p = new StringParser(s);
            p.replace(',', ' ');
            red = p.parseint();
            green = p.parseint();
            blue = p.parseint();
        }
        try {
            return new Color(red, green, blue);
        }
        catch (RuntimeException e2) {
            return cdef;
        }
    }

    public static String translate(Color c2) {
        return c2.getRed() + "," + c2.getGreen() + "," + c2.getBlue();
    }

    public void save(XmlWriter xml) {
        xml.startTagStart(this.getTag());
        xml.printArg("name", this.Name);
        if (this.AliasES != null) {
            xml.printArg("alias", this.AliasES.toString());
        }
        xml.printArg("n", "" + this.NCount);
        if (this.ColorIndex != 0) {
            xml.printArg("color", "" + this.ColorIndex);
        }
        if (this.UserColor != null) {
            xml.printArg("usercolor", ConstructionObject.translate(this.UserColor));
        }
        if (this.ColorType == 1) {
            xml.printArg("type", "thick");
        }
        if (this.ColorType == 2) {
            xml.printArg("type", "thin");
        }
        if (this.ColorType == 3) {
            xml.printArg("type", "invisible");
        }
        if (this.SuperHidden) {
            xml.printArg("hidden", "super");
        } else if (this.Hidden) {
            xml.printArg("hidden", "true");
        }
        if (this.ShowName) {
            xml.printArg("showname", "true");
        }
        if (this.ShowValue) {
            xml.printArg("showvalue", "true");
        }
        if (this.Back) {
            xml.printArg("background", "true");
        }
        if (this.XcOffset != 0.0) {
            xml.printArg("xcoffset", "" + this.XcOffset);
        }
        if (this.YcOffset != 0.0) {
            xml.printArg("ycoffset", "" + this.YcOffset);
        }
        if (this.KeepClose) {
            xml.printArg("keepclose", "true");
        }
        if (this.Parameter) {
            xml.printArg("parameter", "true");
        }
        if (this.MainParameter) {
            xml.printArg("mainparameter", "true");
        }
        if (this.Target) {
            xml.printArg("target", "true");
        }
        if (this.Break) {
            if (this.HideBreak) {
                xml.printArg("hidebreak", "true");
            } else {
                xml.printArg("break", "true");
            }
        }
        if (this.Ticks > 0) {
            xml.printArg("ticks", "" + this.Ticks);
        }
        if (this.Solid && this.maybeTransparent() && this.isFilled()) {
            xml.printArg("solid", "true");
        }
        if (!this.Unit.equals("")) {
            xml.printArg("unit", this.Unit);
        }
        if (this.Bold) {
            xml.printArg("bold", "true");
        }
        if (this.Large) {
            xml.printArg("large", "true");
        }
        if (this instanceof PointonObject && this.isDecorative()) {
            xml.printArg("decorative", "true");
        }
        if (this instanceof PointObject) {
            if (this.ColorType == 0 && !this.FillBackground) {
                xml.printArg("fillbackground", "false");
            }
        } else if (this.FillBackground) {
            xml.printArg("fillbackground", "true");
        }
        if (this.haveConditionals()) {
            int i = 0;
            Enumeration e2 = this.Conditionals.elements();
            while (e2.hasMoreElements()) {
                Conditional c2 = (Conditional)e2.nextElement();
                xml.printArg("ctag" + i, c2.getTag());
                xml.printArg("cexpr" + i, c2.getExpression().toString());
                ++i;
            }
        }
        this.printArgs(xml);
        xml.startTagEnd();
        xml.print(this.Text);
        xml.endTag(this.getTag());
        xml.println();
    }

    public void printArgs(XmlWriter xml) {
    }

    public void updateText() {
    }

    public void setConstruction(Construction c2) {
        this.Cn = c2;
        this.inConstruction = true;
        this.setNameWithNumber(this.Name);
    }

    public boolean showName(boolean original) {
        if (!original && this.testConditional("showname")) {
            return true;
        }
        return this.ShowName || this.Indicated && this.ShowIndicatedName;
    }

    public boolean showName() {
        return this.showName(false);
    }

    public void setShowName(boolean f2) {
        this.ShowName = f2;
    }

    public boolean showValue(boolean original) {
        if (!original && this.testConditional("showvalue")) {
            return true;
        }
        return this.ShowValue;
    }

    public boolean showValue() {
        return this.showValue(false);
    }

    public void setShowValue(boolean f2) {
        this.ShowValue = f2;
    }

    public String getDisplayText() {
        String name = this.Name;
        if (this.AliasES != null) {
            name = this.AliasES.evaluate();
        } else if (name.indexOf("~") > 0) {
            name = name.substring(0, name.indexOf("~"));
        }
        if (this.showName()) {
            if (this.showValue()) {
                String value = this.getDisplayValue();
                if (value.equals("")) {
                    return name;
                }
                if (name.endsWith("$")) {
                    name = name.substring(0, name.length() - 1);
                }
                name = name.endsWith("_") && name.length() > 1 ? name.substring(0, name.length() - 1) : String.valueOf(name) + " = ";
                if (this.Unit.equals("")) {
                    return String.valueOf(name) + this.getDisplayValue();
                }
                return String.valueOf(name) + this.getDisplayValue() + this.Unit;
            }
            if (name.indexOf("~") > 0 && this.AliasES == null) {
                name = name.substring(0, name.indexOf("~"));
            }
            return name;
        }
        if (this.showValue()) {
            if (this.Unit.equals("")) {
                return this.getDisplayValue();
            }
            return String.valueOf(this.getDisplayValue()) + this.Unit;
        }
        return "";
    }

    public String replaceExpressions(String s) {
        boolean latex = s.startsWith("$");
        int searchpos = 0;
        while (s.indexOf("%", searchpos) >= 0) {
            int h1 = s.indexOf("%", searchpos);
            String s1 = s.substring(h1 + 1);
            int h2 = s1.indexOf("%");
            if (h2 == 0) {
                s = String.valueOf(s.substring(0, h1)) + "%" + s1.substring(1);
                ++searchpos;
                continue;
            }
            if (h2 < 0) break;
            String var = s1.substring(0, h2);
            boolean showeq = false;
            boolean forceplus = false;
            if (var.startsWith("~")) {
                var = var.substring(1);
                showeq = true;
            } else if (var.startsWith("+")) {
                var = var.substring(1);
                forceplus = true;
            }
            ConstructionObject o = this.getConstruction().find(var);
            String repl = "";
            if (o != null) {
                DL.add(o);
            }
            try {
                if (showeq) {
                    repl = o.getEquation();
                } else if (o != null) {
                    double x = this.round(o.getValue());
                    if (forceplus && x >= 0.0) {
                        repl = "+";
                    }
                    repl = x == Math.floor(x + 0.1) ? String.valueOf(repl) + (int)x : String.valueOf(repl) + x;
                } else {
                    Expression ex = new Expression(var, this.getConstruction(), this);
                    if (ex.isValid()) {
                        Enumeration e2 = ex.getDepList().elements();
                        while (e2.hasMoreElements()) {
                            DL.add((ConstructionObject)e2.nextElement());
                        }
                    }
                    double x = this.round(ex.getValue());
                    if (forceplus && x >= 0.0) {
                        repl = "+";
                    }
                    repl = x == Math.floor(x + 0.1) ? String.valueOf(repl) + (int)x : String.valueOf(repl) + x;
                }
            }
            catch (Exception ex) {
                repl = latex ? "\\circ" : "???";
            }
            s = String.valueOf(s.substring(0, h1)) + repl + s1.substring(h2 + 1);
            searchpos = h1 + repl.length();
        }
        return s;
    }

    public void addDepInExpressions(String s) {
        this.replaceExpressions(s);
    }

    public String translateExpressions(String s) {
        boolean latex = s.startsWith("$");
        int searchpos = 0;
        while (s.indexOf("%", searchpos) >= 0) {
            int h1 = s.indexOf("%", searchpos);
            String s1 = s.substring(h1 + 1);
            int h2 = s1.indexOf("%");
            if (h2 == 0) {
                s = String.valueOf(s.substring(0, h1)) + "%" + s1.substring(1);
                ++searchpos;
                continue;
            }
            if (h2 < 0) break;
            String var = s1.substring(0, h2);
            boolean showeq = false;
            boolean forceplus = false;
            String repl = "";
            if (var.startsWith("~")) {
                var = var.substring(1);
                showeq = true;
                repl = "+";
            } else if (var.startsWith("+")) {
                var = var.substring(1);
                forceplus = true;
                repl = "~";
            }
            ConstructionObject o = this.getConstruction().find(var);
            if (o != null) {
                o = o.getTranslation();
            }
            if (showeq) {
                repl = String.valueOf(repl) + o.getName();
            } else if (o != null) {
                repl = String.valueOf(repl) + o.getName();
            } else {
                Expression ex = new Expression(var, this.getConstruction(), this);
                if (ex.isValid()) {
                    ex.translate();
                    repl = String.valueOf(repl) + ex.toString();
                } else {
                    return s;
                }
            }
            s = String.valueOf(s.substring(0, h1)) + "%" + repl + "%" + s1.substring(h2 + 1);
            searchpos = h1 + repl.length() + 2;
        }
        return s;
    }

    public String getDisplayValue() {
        return "";
    }

    public String getSizeDisplay() {
        return String.valueOf(this.getDisplayValue()) + this.getUnit();
    }

    public double round(double x) {
        return this.round(x, ZirkelCanvas.EditFactor);
    }

    public double roundDisplay(double x) {
        return this.round(x, ZirkelCanvas.LengthsFactor);
    }

    public double round(double x, double Rounder) {
        return (double)Math.round(x * Rounder) / Rounder;
    }

    public void setcOffset(double x, double y) {
        this.XcOffset = x;
        this.YcOffset = y;
    }

    public double xcOffset() {
        return this.XcOffset;
    }

    public double ycOffset() {
        return this.YcOffset;
    }

    public void setOffset(int x, int y) {
        this.XOffset = x;
        this.YOffset = y;
    }

    public boolean isKeepClose() {
        return this.KeepClose;
    }

    public void setKeepClose(double x, double y) {
        this.KeepClose = true;
        this.XcOffset = x;
        this.YcOffset = y;
    }

    public void setKeepClose(boolean flag) {
        if (this.KeepClose && !flag) {
            this.XcOffset = 0.0;
            this.YcOffset = 0.0;
        }
        this.KeepClose = flag;
    }

    public boolean canKeepClose() {
        return false;
    }

    public void translateOffset(ZirkelCanvas zc) {
        if (this.XOffset != 0 || this.YOffset != 0) {
            this.XcOffset = zc.dx(this.XOffset);
            this.YcOffset = zc.dy(-this.YOffset);
            this.YOffset = 0;
            this.XOffset = 0;
        }
    }

    public int getColorType(boolean original) {
        if (!original && this.testConditional("thin")) {
            return 2;
        }
        if (!original && this.testConditional("thick")) {
            return 1;
        }
        if (!original && this.testConditional("normal")) {
            return 0;
        }
        return this.ColorType;
    }

    public int getColorType() {
        return this.getColorType(false);
    }

    public void setColorType(int type) {
        this.ColorType = type;
    }

    public boolean isParameter() {
        return this.Parameter || this.MainParameter;
    }

    public boolean isMainParameter() {
        return this.MainParameter;
    }

    public void clearParameter() {
        this.Parameter = false;
        this.MainParameter = false;
    }

    public void setMainParameter() {
        Enumeration e2 = this.secondaryParams();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setParameter();
        }
        this.MainParameter = true;
    }

    public void setParameter() {
        this.Parameter = true;
    }

    public Enumeration<ConstructionObject> depending() {
        DL.reset();
        if (this.haveConditionals()) {
            Enumeration e2 = this.Conditionals.elements();
            while (e2.hasMoreElements()) {
                Conditional c2 = (Conditional)e2.nextElement();
                Enumeration ex = c2.getExpression().getDepList().elements();
                while (ex.hasMoreElements()) {
                    DL.add((ConstructionObject)ex.nextElement());
                }
            }
        }
        if (this.AliasES != null) {
            this.AliasES.addDep(this);
        }
        return DL.elements();
    }

    public boolean dependsOn(ConstructionObject o) {
        Enumeration<ConstructionObject> e2 = this.depending();
        while (e2.hasMoreElements()) {
            ConstructionObject o1 = e2.nextElement();
            if (o1 != o) continue;
            return true;
        }
        return false;
    }

    public Enumeration secondaryParams() {
        DL.reset();
        return DL.elements();
    }

    public ConstructionObject[] getDepArray() {
        this.depending();
        return DL.getArray();
    }

    public Enumeration depset(ConstructionObject o1) {
        DL.add(o1);
        return DL.elements();
    }

    public Enumeration depset(ConstructionObject o1, ConstructionObject o2) {
        DL.add(o1);
        DL.add(o2);
        return DL.elements();
    }

    public Enumeration depset(ConstructionObject o1, ConstructionObject o2, ConstructionObject o3) {
        DL.add(o1);
        DL.add(o2);
        DL.add(o3);
        return DL.elements();
    }

    public void setFlag(boolean flag) {
        this.Flag = flag;
    }

    public boolean isFlag() {
        return this.Flag;
    }

    public void setRekFlag(boolean flag) {
        this.RekFlag = flag;
    }

    public boolean isRekFlag() {
        return this.RekFlag;
    }

    public void setTarget(boolean flag) {
        this.Target = flag;
    }

    public boolean isTarget() {
        return this.Target;
    }

    public void setKeep(boolean flag) {
        this.Keep = flag;
    }

    public boolean isKeep() {
        return this.Keep;
    }

    public boolean equals(ConstructionObject o) {
        return false;
    }

    public boolean equals(double x, double y) {
        return Math.abs(x - y) < 1.0E-8;
    }

    public void setJobTarget(boolean flag, boolean check) {
        if (flag) {
            this.OldColorIndex = this.ColorIndex;
            this.setColor(-1);
        } else if (this.JobTarget) {
            this.setColor(this.OldColorIndex);
        }
        this.JobTarget = flag;
        this.NoCheckTarget = check;
    }

    public boolean isJobTarget() {
        return this.JobTarget;
    }

    public boolean isNoCheckTarget() {
        return this.NoCheckTarget;
    }

    public void updateCircleDep() {
    }

    public void clearCircleDep() {
    }

    public ConstructionObject copy() {
        ConstructionObject o = null;
        try {
            o = (ConstructionObject)this.clone();
            this.setTranslation(o);
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o;
    }

    public Construction getConstruction() {
        return this.Cn;
    }

    public double getValue() throws ConstructionException {
        throw new NoValueException(this.Valid);
    }

    public void setDefaults() {
        this.setShowName(this.Cn.ShowNames);
        this.setShowValue(this.Cn.ShowValues);
        if (this.Cn.DefaultUserColor == null) {
            this.setColor(this.Cn.DefaultColor);
        } else {
            this.setColor(this.Cn.DefaultUserColor);
        }
        this.setColorType(this.Cn.DefaultColorType);
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
    }

    public void setTargetDefaults() {
        this.setShowName(this.Cn.ShowNames);
        this.setShowValue(this.Cn.ShowValues);
        this.setColor(this.Cn.DefaultColor);
        this.setColorType(this.Cn.DefaultColorType);
    }

    public boolean contains(PointObject p) {
        return false;
    }

    public boolean canFix() {
        return false;
    }

    public void setFixed(String o) {
    }

    public boolean isBack(boolean original) {
        if (!original && this.testConditional("background")) {
            return true;
        }
        return this.Back;
    }

    public boolean isBack() {
        return this.isBack(false);
    }

    public void setBack(boolean flag) {
        this.Back = flag;
    }

    public void setInConstruction(boolean flag) {
        this.inConstruction = flag;
    }

    public boolean isInConstruction() {
        return this.inConstruction;
    }

    public void laterBind(Construction c2) {
    }

    public void laterTranslate(Construction c2) {
    }

    public void setFilled(boolean flag) {
    }

    public boolean isFilled() {
        return false;
    }

    public boolean isFilledForSelect() {
        return this.isFilled();
    }

    public boolean getObtuse() {
        return this.Obtuse;
    }

    public void setObtuse(boolean flag) {
        this.Obtuse = flag;
    }

    public String getDescription() {
        return "";
    }

    public void round() {
    }

    public boolean isFixed() {
        return false;
    }

    public boolean isBreak() {
        return this.Break;
    }

    public void setBreak(boolean flag) {
        this.Break = flag;
        this.HideBreak = false;
    }

    public boolean isHideBreak() {
        return this.HideBreak;
    }

    public void setHideBreak(boolean flag) {
        this.HideBreak = flag;
        this.Break = flag;
    }

    public boolean isSolid(boolean original) {
        if (!original && this.testConditional("solid")) {
            return true;
        }
        return this.Solid;
    }

    public boolean isSolid() {
        return this.isSolid(false);
    }

    public void setSolid(boolean solid) {
        this.Solid = solid;
    }

    public boolean maybeTransparent() {
        return false;
    }

    public boolean locallyLike(ConstructionObject o) {
        return false;
    }

    @Override
    public int compare(SortObject o) {
        ConstructionObject ob = (ConstructionObject)o;
        if (ob.Value < this.Value) {
            return 1;
        }
        if (ob.Value == this.Value) {
            return 0;
        }
        return -1;
    }

    public void setSelectable(boolean flag) {
        this.Selectable = flag;
    }

    public void snap(ZirkelCanvas zc) {
    }

    public String getUnit() {
        return this.Unit;
    }

    public void setUnit(String s) {
        this.Unit = s;
    }

    public boolean hasUnit() {
        return true;
    }

    public boolean isBreakHide() {
        return this.BreakHide;
    }

    public void setBreakHide(boolean flag) {
        this.BreakHide = flag;
    }

    public String getEquation() {
        return this.getDisplayValue();
    }

    public String helpDisplayValue(boolean start, double x, String tag) {
        String s = "";
        if (Math.abs(x) < 1.0E-10) {
            return s;
        }
        if (x < 0.0) {
            s = "-";
        } else if (!start) {
            s = "+";
        }
        x = Math.abs(x);
        if (Math.abs(x - 1.0) > 1.0E-10) {
            s = String.valueOf(s) + this.roundDisplay(x);
        }
        if (tag.equals("")) {
            return s;
        }
        if (s.equals("") || s.equals("-")) {
            return String.valueOf(s) + tag;
        }
        return String.valueOf(s) + "*" + tag;
    }

    public String helpDisplayNumber(boolean start, double x) {
        String s = "";
        if (Math.abs(x) < 1.0E-10) {
            return s;
        }
        if (x < 0.0) {
            s = "-";
        } else if (!start) {
            s = "+";
        }
        x = Math.abs(x);
        return String.valueOf(s) + this.roundDisplay(x);
    }

    public boolean visible(ZirkelCanvas zc) {
        return this.selected() || this.ColorType != 3 || zc.showHidden();
    }

    public boolean isBold() {
        return this.Bold;
    }

    public void setBold(boolean bold) {
        this.Bold = bold;
    }

    public boolean isLarge() {
        return this.Large;
    }

    public void setLarge(boolean large) {
        this.Large = large;
    }

    public void addConditional(String tag, Expression expr) {
        Conditional c2 = new Conditional(tag, expr);
        if (this.Conditionals == null) {
            this.Conditionals = new Vector();
        }
        this.Conditionals.addElement(c2);
    }

    public Expression getConditional(String tag) {
        if (this.Conditionals == null) {
            return null;
        }
        Enumeration e2 = this.Conditionals.elements();
        while (e2.hasMoreElements()) {
            Conditional c2 = (Conditional)e2.nextElement();
            if (!c2.getTag().equals(tag)) continue;
            return c2.getExpression();
        }
        return null;
    }

    public boolean haveConditional(String tag) {
        Expression ex = this.getConditional(tag);
        return ex != null;
    }

    public boolean testConditional(String tag) {
        Expression ex = this.getConditional(tag);
        if (ex == null) {
            return false;
        }
        try {
            if (ex.getValue() != 0.0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void clearConditionals() {
        this.Conditionals = null;
    }

    public void translateConditionals() {
        if (this.Conditionals != null) {
            Enumeration e2 = this.Conditionals.elements();
            this.clearConditionals();
            while (e2.hasMoreElements()) {
                Conditional c2 = (Conditional)e2.nextElement();
                String expr = c2.getExpression().toString();
                Expression enew = new Expression(expr, this.getConstruction(), this);
                enew.translate();
                this.addConditional(c2.getTag(), enew);
            }
        }
        if (this.AliasES != null) {
            this.setAlias(this.AliasES.toString());
            this.AliasES.translate();
        }
    }

    public boolean haveConditionals() {
        return this.Conditionals != null;
    }

    public void checkConditionals() throws ConstructionException {
        if (this.Conditionals == null) {
            return;
        }
        Enumeration e2 = this.Conditionals.elements();
        while (e2.hasMoreElements()) {
            Conditional c2 = (Conditional)e2.nextElement();
            if (!c2.getExpression().isValid()) {
                throw new ConstructionException(c2.getExpression().getErrorText());
            }
            c2.getExpression().getValue();
        }
    }

    public double getZ() throws ConstructionException {
        Expression e2 = this.getConditional("z");
        if (e2 == null) {
            throw new ConstructionException("");
        }
        return e2.getValue();
    }

    public boolean canDisplayName() {
        return true;
    }

    public int getNCount() {
        return this.NCount;
    }

    public void setNCount(int count) {
        this.NCount = count;
    }

    public String getAlias() {
        if (this.AliasES == null) {
            return null;
        }
        return this.AliasES.toString();
    }

    public void setAlias(String s) {
        this.AliasES = s == null ? null : new ExpressionString(s, this);
    }

    @Override
    public String getElementString(int state) {
        String s = "";
        switch (state) {
            case 0: {
                s = String.valueOf(this.getName()) + " : " + FileName.chop(this.getText(), 80);
                break;
            }
            case 2: {
                s = String.valueOf(this.getName()) + " : " + FileName.chop(this.getSizeDisplay(), 80);
                break;
            }
            case 1: {
                s = String.valueOf(this.getName()) + " : " + FileName.chop(this.getEquation(), 80);
            }
        }
        if (this.isSuperHidden()) {
            s = "( " + s + " )";
        }
        if (this.isHideBreak()) {
            s = "** " + s;
        } else if (this.isBreak()) {
            s = "* " + s;
        }
        if (!this.valid()) {
            s = "? " + s;
        }
        if (this instanceof MoveableObject && ((MoveableObject)((Object)this)).moveable()) {
            s = "> " + s;
        }
        return s;
    }

    @Override
    public String getElementString() {
        return this.getElementString(0);
    }

    public boolean isSpecialParameter() {
        return this.SpecialParameter;
    }

    public void setSpecialParameter(boolean flag) {
        this.SpecialParameter = flag;
    }

    public static PointObject getPointObject(Expression E) {
        if (E == null) {
            return null;
        }
        ConstructionObject o = E.getObject();
        if (o == null || !(o instanceof PointObject)) {
            return null;
        }
        return (PointObject)o;
    }

    public MyVector getVector() {
        if (this.MVInUse) {
            return new MyVector();
        }
        if (this.MV == null) {
            this.MV = new MyVector();
        }
        this.MVInUse = true;
        return this.MV;
    }

    public void discardMV() {
        this.MVInUse = false;
        this.MV.removeAllElements();
    }

    public boolean isDecorative() {
        return this.Decorative;
    }

    public void setDecorative(boolean decorative) {
        this.Decorative = decorative;
    }

    public boolean isFillBackground() {
        return this.canFillBackground() && this.FillBackground;
    }

    public void setFillBackground(boolean flag) {
        if (this.canFillBackground()) {
            this.FillBackground = flag;
        }
    }

    public boolean canFillBackground() {
        return true;
    }

    public boolean canBeReplacedBy(ConstructionObject o) {
        return false;
    }

    public boolean editAt(double x, double y, ZirkelCanvas zc) {
        return true;
    }

    public int getTicks() {
        return this.Ticks;
    }

    public void setTicks(int ticks) {
        this.Ticks = ticks;
    }

    public boolean canHaveTicks() {
        return false;
    }
}

