/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.Zirkel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BracketExpression;
import rene.zirkel.expression.ElementaryExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.MinusExpression;
import rene.zirkel.expression.TopExpression;

class BasicExpression {
    BasicExpression E;
    static final int MINUS = -1;
    static final int PLUS = 1;

    BasicExpression() {
    }

    public static BasicExpression scan(ExpressionText t) throws ConstructionException {
        if (t.next() == '-') {
            t.advance();
            return BasicExpression.scan(t, -1);
        }
        if (t.next() == '+') {
            t.advance();
            return BasicExpression.scan(t, 1);
        }
        if (t.next() == '(') {
            return new BracketExpression(BasicExpression.scanBracket(t));
        }
        return ElementaryExpression.scan(t);
    }

    public static BasicExpression scan(ExpressionText t, int sign) throws ConstructionException {
        if (sign == -1) {
            if (t.next() == '(') {
                return new MinusExpression(BasicExpression.scanBracket(t));
            }
            return new MinusExpression(ElementaryExpression.scan(t));
        }
        if (t.next() == '(') {
            return BasicExpression.scanBracket(t);
        }
        return ElementaryExpression.scan(t);
    }

    public static BasicExpression scanBracket(ExpressionText t) throws ConstructionException {
        t.advance();
        BasicExpression E = TopExpression.scan(t);
        if (t.next() != ')') {
            throw new ConstructionException(Zirkel.name("exception.bracket"));
        }
        t.advance();
        return E;
    }

    public double getValue() throws ConstructionException {
        throw new ConstructionException("");
    }

    public void translate() {
    }

    public boolean isNumber() {
        return false;
    }

    public void reset() {
    }

    public boolean isLogical() {
        return false;
    }
}

