/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SegmentObject;

public class ParallelObject
extends PrimitiveLineObject {
    protected PrimitiveLineObject L;
    static Count N = new Count();

    public ParallelObject(Construction c2, PrimitiveLineObject l, PointObject p) {
        super(c2);
        this.P1 = p;
        this.L = l;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Parallel";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(ParallelObject.text2(Zirkel.name("text.parallel"), this.P1.getName(), this.L.getName()));
    }

    public void validate() {
        if (!this.P1.valid() || !this.L.valid()) {
            this.Valid = false;
        } else if (this.L instanceof SegmentObject && ((SegmentObject)this.L).getLength() == 0.0) {
            this.Valid = false;
        } else {
            this.Valid = true;
            this.X1 = this.P1.getX();
            this.Y1 = this.P1.getY();
            this.DX = this.L.getDX();
            this.DY = this.L.getDY();
        }
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("point", this.P1.getName());
        xml.printArg("line", this.L.getName());
        super.printArgs(xml);
    }

    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.L);
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.L = (PrimitiveLineObject)this.L.getTranslation();
    }

    public boolean contains(PointObject p) {
        return p == this.P1;
    }

    public boolean hasUnit() {
        return false;
    }
}

