/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.CircleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.SegmentObject;

public class SetFixedCircle
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    FixedCircleObject C;
    PointObject P1;
    PointObject P2;

    public SetFixedCircle(ZirkelCanvas zc, FixedCircleObject c2, ObjectConstructor oc) {
        this.C = c2;
        this.OC = oc;
        c2.setSelected(true);
        zc.repaint();
    }

    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P1 == null) {
            ConstructionObject o = zc.selectWithSelector(e2.getX(), e2.getY(), this);
            if (o == null) {
                return;
            }
            if (o instanceof PointObject) {
                this.P1 = (PointObject)o;
                this.P1.setSelected(true);
                this.showStatus(zc);
                zc.repaint();
                return;
            }
            this.C.setFixed(o.getName());
            this.C.setDragable(false);
            this.C.updateText();
            this.reset(zc);
        } else {
            this.P2 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P2 == null) {
                return;
            }
            this.C.setFixed("d(" + this.P1.getName() + "," + this.P2.getName() + ")");
            this.reset(zc);
        }
    }

    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicateWithSelector(e2.getX(), e2.getY(), this);
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Zirkel.name("message.setfixedcircle.first"));
        } else {
            zc.showStatus(Zirkel.name("message.setfixedcircle.second"));
        }
    }

    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        this.showStatus(zc);
        zc.repaint();
        zc.check();
    }

    public boolean useSmartBoard() {
        return this.P1 != null;
    }

    public boolean isAdmissible(ZirkelCanvas zc, ConstructionObject o) {
        return (o instanceof PointObject || o instanceof SegmentObject || o instanceof FixedCircleObject || o instanceof CircleObject || o instanceof ExpressionObject) && !zc.getConstruction().dependsOn(o, this.C);
    }
}

