// listing.13.7.js
// Wątek roboczy pobierający tweety

// funkcja zwrotna do parsowania pobranych tweetów
function getResult(data) {

   // zmienna przechowująca największy identyfikator z listy tweetów
   var maxId = 0;

   // sprawdź, czy są tweety, które należy parsować
   if (data.length>0) {

      // zmienne dotyczące powiadomień
      var tIcon = '';
      var tTitle = '';
      var tBody = '';

      // przejdź w pętli przez zbiór wyników w odwrotnej kolejności
      for (var i=(data.length-1); i>=0; i--) {

         // pobierz obrazek profilu, nazwę do wyświetlenia i tweet
         tIcon = data[i].user.profile_image_url;
         tTitle = data[i].user.screen_name;
         tBody = data[i].text;

         // zwróć informację o tweecie z powrotem do głównego wątku w celu wyświetlenia tweeta
         postMessage({msgType:'TWEET',icon:tIcon,title:tTitle,body:tBody});

         // zapisz id_str jako największy identyfikator, aby nie pokazywać tweetów ponownie
         maxId = data[i].id_str;
      }
   }

   // poinformuj główny wątek, że w tej pętli to wszystko, co było do zrobienia
   postMessage({msgType:'END',lastTweetId:maxId});
}

// przechwyć komunikat z głównego wątku
onmessage = function(event) {

   // pobierz identyfikator ostatniego tweeta
   var lastId = event.data;
   var qString = '';

   // sprawdź, czy identyfikator ostatniego tweeta to identyfikator istniejącego tweeta
   if (lastId != 0) {
      // jeśli to identyfikator istniejącego tweeta, użyj since_id
      qString = '&since_id='+lastId;
   } else {
      // brak wcześniej przeczytanych tweetów, więc pobierz maksymalnie trzy
      qString = '&count=3';
   }

   // użyj importScripts jako metody JSONP zamiast znacznika script
   // obecnie wyświetlane są tweety dla screen name mającego wartość HelionPL, ale możesz to zmienić
   // na jakiegokolwiek użytkownika Twittera, którego tweety chciałbyś wyświetlać
   importScripts('http://api.twitter.com/1/statuses/user_timeline.json?screen_name=HelionPL'+qString+'&callback=getResult');

}
