#!/usr/bin/env python

import asyncore
from websocket import WebSocketServer


class BroadcastHandler(object):
    """
    Klasa BroadcastHandler przekazuje przychodzace ciagi znakow do wszystkich polaczonych klientow.
    """

    def __init__(self, conn):
        self.conn = conn

    def dispatch(self, data):
        for session in self.conn.server.sessions:
            session.send(data)


if __name__ == "__main__":
    print "Uruchomienie serwera rozglaszajacego"
    WebSocketServer(port=8080, handlers={"/broadcast": BroadcastHandler})
    asyncore.loop()
