/* mightygumball.js */
/*
 * pobiera zawartość pliku JSON za pomocą Ajax-a 
 *
 */

window.onload = init;

function init() {
	getSales();
}

//
// Ta funkcja korzysta z obiektu XMLHttpRequest w wersji 1., więc zastosuj ją,
// jeżeli używasz IE, Opery lub naprawdę starych wersji przeglądarek Safari,
// Firefox lub Chrome.
//
function getSales_XHRv1() {
	// zmień adres URL, tak aby odpowiadał lokalizacji, w której umieściłeś
	// plik sales.json.
	var url = "http://localhost/html5/rozdzial6/sales.json";
	var request = new XMLHttpRequest();
	request.open("GET", url);
	request.onreadystatechange = function() {
		if (request.readyState == 4 && request.status == 200) {
			updateSales(request.responseText);
		}
	};
	request.send(null);
}

//
// Dzięki wykorzystaniu obiektu XMLHttpRequest w wersji 2. (zaimplementowanej
// w nowych wersjach przeglądarek Firefox, Safari i Chrome) możesz kontrolować
// postęp pobierania danych i sprawdzać zdarzenie "load" w funkcji zwrotnej
// onload, zamiast sprawdzać je w onreadystatechange.
//
function getSales() {
	// zmień adres URL, tak aby odpowiadał lokalizacji, w której umieściłeś
	// plik sales.json
	var url = "http://localhosjt/html5/rozdzial6/sales.json";
	var request = new XMLHttpRequest();
	request.open("GET", url);
	request.onload = function() {
		if (request.status == 200) {
			updateSales(request.responseText);
		}
	};
	request.send(null);
}

function updateSales(responseText) {
	var salesDiv = document.getElementById("sales");	
	var sales = JSON.parse(responseText);
	for (var i = 0; i < sales.length; i++) {
		var sale = sales[i];
		var div = document.createElement("div");
		div.setAttribute("class", "saleItem");
		div.innerHTML = sale.name + " – liczba sprzedanych gum: " + sale.sales;
		salesDiv.appendChild(div);
	}
}

