/* 
 * mandellib.js
 *
 *
 * ------ Kod gotowy do użycia: zmienne globalne ---- 
 */
var canvas;
var ctx;

var i_max = 1.5;
var i_min = -1.5;
var r_min = -2.5;
var r_max = 1.5;

var max_iter = 1024;
var escape = 100;
var palette = [];


/* 
 * ------- Kod gotowy do użycia --------
 *
 */

//
// opakowuje dane, które musimy przesłać do wątku
//
function createTask(row) {
	var task = {
		row: row,				// numer wiersza do wyznaczenia
		width: rowData.width,   // szerokość obiektu ImageData do wypełnienia
		generation: generation, // generacja (stopień powiększenia)
		r_min: r_min,
		r_max: r_max,
		i: i_max + (i_min - i_max) * row / canvas.height,
		max_iter: max_iter,
		escape: escape
	};
	return task;
}
//
// Ta funkcja mapuje liczby od 0 do max_iter na
// 256 wartości, które wypełnia paletą kolorów (r, g, b). 
// Kolory znajdujące się obok siebie są do siebie zbliżone
// i różnią się nieznacznie wartościami poszczególnych
// składowych r, g i b. Algorytm działa prawidłowo
// dla max_iter > 256.
//
//
function makePalette() {
    function wrap(x) {
        x = ((x + 256) & 0x1ff) - 256;
        if (x < 0) x = -x;
        return x;
    }
    for (i = 0; i <= this.max_iter; i++) {
        palette.push([wrap(7*i), wrap(5*i), wrap(11*i)]);
    }
}





//
// Funkcja drawRow mapuje wartości z tablicy przesłanej przez wątek
// 	na kolory pikseli umieszczanych w wierszu obrazu.
//
function drawRow(workerResults) {
    var values = workerResults.values;	// Tablica wartości odesłanych przez wątek
    var pixelData = rowData.data;		// Piksele z obiekcie ImageData
										// Zmienna pixelData zawiera *referencję* do rowData.data!
										// 	 Zmiany w pixelData wpływają na rowData.data!!!
    for (var i = 0; i < rowData.width; i++) {  // dla każdego piksela w wierszu
		var red = i * 4;
		var green = i * 4 + 1;
		var blue = i * 4 + 2;
		var alpha = i * 4 + 3;

        pixelData[alpha] = 255; // ustawiamy brak przezroczystości

		// jeśli wartość z tablicy jest ujemna, ustawiamy kolor na czarny
        if (values[i] < 0) {
            pixelData[red] = pixelData[green] = pixelData[blue] = 0;
        } else {
			//
			// mapuje liczbę odczytaną z tablicy values przesłanej przez wątek
			// na kolor z palety
			//
            var color = this.palette[values[i]];

			//
			// każdy kolor jest opisany składowymi r, g i b, więc ustawiamy
			// je dla piksela.
			//
            pixelData[red] = color[0];
            pixelData[green] = color[1];
            pixelData[blue] = color[2];
        }
    }
	//
	// rysuje wiersz na płótnie
	// workerData.row to numer wiersza, nad którym pracujemy
	// rowData zawiera dane, które zaktualizowaliśmy!
	// zaczynamy od kolumny 0, więc x, y = 0
	//
    ctx.putImageData(this.rowData, 0, workerResults.row);
}


//
// Funkcja setupGraphics inicjuje wartości niektórych zmiennych używanych
// 	 w obliczeniach zbioru Mandelbrota oraz ustawia szerokość i wysokość
//	 płótna zgodnie z wymiarami okna przeglądarki.
//
function setupGraphics() {

	canvas = document.getElementById("fractal");
	ctx = canvas.getContext("2d");

	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;
	var width = ((i_max - i_min) * canvas.width / canvas.height);
	var r_mid = (r_max + r_min) / 2;
	r_min = r_mid - width/2;
	r_max = r_mid + width/2;

	rowData = ctx.createImageData(canvas.width, 1);

	makePalette();
}
