/***
 * Plik przykadowy z ksiki "HTML5 i CSS3. Standardy przyszoci",
 * wydanej przez Wydawnictwo Helion S.A.
 * Kod rdowy jest chroniony prawem autorskim. Kodu nie mona uywa jako materiaw pomocniczych, 
 * w trakcie szkole, w ksikach, artykuach itp. W razie wtpliwoci prosimy o kontakt z wydawnictwem.
 * Wydawnictwo nie gwarantuje bezbdnego dziaania przykadowego kodu.
 * Wicej informacji na temat ksiki znajduje si na stronie wydawnictwa pod adresem http://helion.pl.
***/
// Obsuga strukturalnych elementw HTML5 dla IE 6, 7 i 8
document.createElement("header");
document.createElement("footer");
document.createElement("section");
document.createElement("aside");
document.createElement("article");
document.createElement("nav");

function supportsHistory(){
  return !!(window.history && window.history.pushState);  
}
if(supportsHistory()){
  window.history.pushState( {tab: "#welcome"}, '#welcome');
  window.onpopstate = function(event) {  
    if(event.state){
      var tab = (event.state["tab"]);
      $(".visible")
        .removeClass("visible")
        .addClass("hidden")
        .hide();
      $(tab)
        .removeClass("hidden")
        .addClass("visible")
        .show();
    }
  };
};


$(function(){
  
  
  
  $("#services, #about, #contact").hide().addClass("hidden"); 
  $("#welcome").addClass("visible");
  
  $("nav ul").click(function(event){ 
    target = $(event.target);
    if(target.is("a")){   
      event.preventDefault();
      if ( $(target.attr("href")).hasClass("hidden") ){  
      
        if(supportsHistory()){
          var tab = $(target).attr("href");  
          var stateObject = {tab: tab};
          window.history.pushState(stateObject, tab);  
        };
      
        $(".visible").removeClass("visible").addClass("hidden").hide();
        $(target.attr("href")).removeClass("hidden").addClass("visible").show();
      };
    };  
  });
  
});

