/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import java.util.StringTokenizer;
import rene.dialogs.Warning;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.graphics.PolygonDrawer;
import rene.zirkel.graphics.PolygonFiller;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.Evaluator;
import rene.zirkel.objects.FunctionEditDialog;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class FunctionObject
extends ConstructionObject
implements PointonObject,
Evaluator {
    Expression EX = null;
    Expression EY = null;
    Expression VarMin = null;
    Expression VarMax = null;
    Expression DVar = null;
    double[] X = new double[]{0.0};
    String[] Var = new String[]{"x"};
    boolean Filled = false;
    Expression Center = null;
    protected int Type = 0;
    public static final int SQUARE = 0;
    public static final int DIAMOND = 1;
    public static final int CIRCLE = 2;
    public static final int DOT = 3;
    public static final int CROSS = 4;
    public static final int DCROSS = 5;
    protected boolean Special = false;
    PolygonFiller PF = null;
    double C1;
    double C2;
    int C;
    int R;
    int W;
    int H;
    static double[] x = new double[4];
    static double[] y = new double[4];
    public boolean EditAborted;

    public FunctionObject(Construction c2) {
        super(c2);
        this.VarMin = new Expression("-10", c2, this);
        this.VarMax = new Expression("10", c2, this);
        this.DVar = new Expression("0.1", c2, this);
        this.validate();
        this.updateText();
    }

    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    public boolean isFilled() {
        return this.Filled;
    }

    public String getTag() {
        return "Function";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        if (this.EX != null && this.EY != null) {
            this.setText(FunctionObject.text2(Zirkel.name("text.function"), this.EX.toString(), this.EY.toString()));
        } else {
            this.setText(FunctionObject.text2(Zirkel.name("text.function"), "", ""));
        }
    }

    public void validate() {
        this.Valid = this.EX != null && this.EY != null ? this.EX.isValid() && this.EY.isValid() && this.VarMin.isValid() && this.VarMax.isValid() && this.DVar.isValid() : false;
    }

    public void setExpressions(String t, String ex, String ey) {
        StringTokenizer tok = new StringTokenizer(t);
        this.Var = new String[tok.countTokens()];
        this.X = new double[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.Var[i++] = tok.nextToken();
        }
        if (ex.equals("")) {
            ex = this.Var[0];
        }
        this.EX = new Expression(ex, this.getConstruction(), this, this.Var);
        this.EY = new Expression(ey, this.getConstruction(), this, this.Var);
        this.validate();
    }

    public void setRange(String min, String max, String d2) {
        this.VarMin = new Expression(min, this.getConstruction(), this);
        this.VarMax = new Expression(max, this.getConstruction(), this);
        this.DVar = new Expression(d2, this.getConstruction(), this);
    }

    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return this.Var[0];
    }

    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "0";
    }

    public void paint(MyGraphics g, ZirkelCanvas zc) {
        double y1;
        double x1;
        double d2;
        double varmax;
        double varmin;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        boolean special = this.Special;
        boolean reverse = false;
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            d2 = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
                reverse = true;
            }
            if (d2 < 0.0) {
                d2 = -d2;
            }
            if (d2 < (varmax - varmin) / 1000.0) {
                d2 = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return;
        }
        this.X[0] = varmin;
        if (this.isStrongSelected() && g instanceof MyGraphics13) {
            PolygonDrawer pm = new PolygonDrawer(g, this);
            pm.useAsMarker();
            x1 = 0.0;
            y1 = 0.0;
            while (true) {
                try {
                    x1 = this.EX.getValue();
                    y1 = this.EY.getValue();
                    if (Math.abs(zc.col(x1)) + Math.abs(zc.col(y1)) > 100000.0) {
                        this.finish(g, zc);
                        this.C1 = this.X[0];
                        if (pm != null) {
                            pm.finishPolygon();
                        }
                    } else {
                        if (!special || this.isFilled()) {
                            if (special && this.isFilled() && pm.hasStarted()) {
                                if (reverse) {
                                    pm.drawTo(pm.c(), zc.row(y1));
                                    pm.drawTo(zc.col(x1), zc.row(y1));
                                } else {
                                    pm.drawTo(zc.col(x1), pm.r());
                                    pm.drawTo(zc.col(x1), zc.row(y1));
                                }
                            }
                            pm.drawTo(zc.col(x1), zc.row(y1));
                        } else {
                            ((MyGraphics13)g).drawMarkerLine(zc.col(x1), zc.row(y1), zc.col(x1), zc.row(y1));
                        }
                        this.C2 = this.X[0];
                    }
                }
                catch (Exception e3) {
                    this.finish(g, zc);
                    this.C1 = this.X[0];
                    pm.finishPolygon();
                }
                if (this.X[0] >= varmax) break;
                this.X[0] = this.X[0] + d2;
                if (!(this.X[0] > varmax)) continue;
                this.X[0] = varmax;
            }
            pm.finishPolygon();
        }
        this.X[0] = varmin;
        g.setColor(this);
        PolygonDrawer pd = null;
        if (!special || this.isFilled()) {
            pd = new PolygonDrawer(g, this);
        }
        if (this.isFilled()) {
            if (this.PF == null) {
                this.PF = new PolygonFiller(g, this);
            }
            this.PF.start();
            this.PF.setGraphics(g);
        }
        this.C1 = this.X[0];
        x1 = 0.0;
        y1 = 0.0;
        while (true) {
            try {
                x1 = this.EX.getValue();
                y1 = this.EY.getValue();
                if (Math.abs(zc.col(x1)) + Math.abs(zc.col(y1)) > 100000.0) {
                    this.finish(g, zc);
                    this.C1 = this.X[0];
                    if (pd != null) {
                        pd.finishPolygon();
                    }
                } else {
                    if (this.isFilled()) {
                        if (this.PF.length() == 0) {
                            this.C1 = this.X[0];
                        }
                        if (special) {
                            if (pd.hasStarted()) {
                                if (reverse) {
                                    this.PF.drawTo(pd.c(), zc.row(y1));
                                    this.PF.drawTo(zc.col(x1), zc.row(y1));
                                } else {
                                    this.PF.drawTo(zc.col(x1), pd.r());
                                    this.PF.drawTo(zc.col(x1), zc.row(y1));
                                }
                            } else {
                                this.PF.drawTo(zc.col(x1), zc.row(y1));
                            }
                        } else {
                            this.PF.drawTo(zc.col(x1), zc.row(y1), this.X[0] < varmax);
                        }
                    }
                    if (pd != null) {
                        if (special && this.isFilled() && pd.hasStarted()) {
                            if (reverse) {
                                pd.drawTo(pd.c(), zc.row(y1));
                                pd.drawTo(zc.col(x1), zc.row(y1));
                            } else {
                                pd.drawTo(zc.col(x1), pd.r());
                                pd.drawTo(zc.col(x1), zc.row(y1));
                            }
                        }
                        pd.drawTo(zc.col(x1), zc.row(y1));
                    } else {
                        PointObject.drawPoint(g, zc, this, x1, y1, this.Type);
                    }
                    this.C2 = this.X[0];
                }
            }
            catch (Exception e4) {
                this.finish(g, zc);
                this.C1 = this.X[0];
                pd.finishPolygon();
            }
            if (this.X[0] >= varmax) break;
            this.X[0] = this.X[0] + d2;
            if (!(this.X[0] > varmax)) continue;
            this.X[0] = varmax;
        }
        this.finish(g, zc);
        if (pd != null) {
            pd.finishPolygon();
        }
    }

    public void finish(MyGraphics g, ZirkelCanvas zc) {
        if (this.isFilled()) {
            if (this.getEX().equals(this.getVar())) {
                this.PF.drawTo(zc.col(this.C2), zc.row(0.0));
                this.PF.drawTo(zc.col(this.C1), zc.row(0.0));
            } else if (this.getCenter() != null) {
                this.PF.drawTo(zc.col(this.getCenter().getX()), zc.row(this.getCenter().getY()));
            } else {
                this.PF.drawTo(zc.col(0.0), zc.row(0.0));
            }
            this.PF.finishPolygon();
        }
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.X[0];
    }

    public double getValue(String var) throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        int i = 0;
        while (i < this.Var.length) {
            if (var.equals(this.Var[i])) {
                return this.X[i];
            }
            ++i;
        }
        return this.X[0];
    }

    public double getIntegral() throws ConstructionException {
        return this.getSum();
    }

    public String getDisplayValue() {
        if (this.getEX().equals(this.getVar())) {
            return this.EY.toString();
        }
        return "(" + this.EX.toString() + "," + this.EY.toString() + ")";
    }

    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        double d2;
        double varmax;
        double varmin;
        if (!this.displays(zc)) {
            return false;
        }
        int size = (int)zc.selectionSize();
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            d2 = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
            }
            if (d2 < 0.0) {
                d2 = -d2;
            }
            if (d2 < (varmax - varmin) / 1000.0) {
                d2 = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return false;
        }
        this.X[0] = varmin;
        double x = zc.x(cc);
        double y = zc.y(rr);
        boolean last = false;
        double x0 = 0.0;
        double y0 = 0.0;
        while (this.X[0] < varmax) {
            double y1;
            double x1;
            block13: {
                double h;
                block14: {
                    this.X[0] = this.X[0] + d2;
                    if (this.X[0] > varmax) {
                        this.X[0] = varmax;
                    }
                    x1 = this.EX.getValue();
                    y1 = this.EY.getValue();
                    if (Math.abs(zc.col(x1)) + Math.abs(zc.col(y1)) > 100000.0) {
                        throw new Exception("");
                    }
                    if (!last) break block13;
                    this.Value = Math.abs((double)cc - zc.col(x1)) + Math.abs((double)rr - zc.row(y1));
                    if (!(this.Value <= (double)size)) break block14;
                    return true;
                }
                double r = Math.sqrt(Math.abs(x1 - x0) * Math.abs(x1 - x0) + Math.abs(y1 - y0) * Math.abs(y1 - y0));
                if (!(r > 1.0E-5) || !((h = ((x - x0) * (x1 - x0) + (y - y0) * (y1 - y0)) / r) >= 0.0) || !(h <= r)) break block13;
                this.Value = Math.abs(((x - x0) * (y1 - y0) - (y - y0) * (x1 - x0)) / r) / zc.dx(1);
                if (!(this.Value <= (double)size)) break block13;
                return true;
            }
            try {
                x0 = x1;
                y0 = y1;
                last = true;
            }
            catch (Exception e3) {
                last = false;
            }
        }
        return false;
    }

    public void edit(ZirkelCanvas zc) {
        FunctionEditDialog d2;
        while (true) {
            Warning w;
            Frame F;
            d2 = new FunctionEditDialog(zc, this);
            d2.setVisible(true);
            this.EditAborted = false;
            if (d2.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (!this.EX.isValid()) {
                F = zc.getFrame();
                w = new Warning(F, this.EX.getErrorText(), Zirkel.name("warning"), true);
                w.center(F);
                w.setVisible(true);
                continue;
            }
            if (this.EY.isValid()) break;
            F = zc.getFrame();
            w = new Warning(F, this.EY.getErrorText(), Zirkel.name("warning"), true);
            w.center(F);
            w.setVisible(true);
        }
        this.validate();
        this.updateText();
        zc.getConstruction().updateCircleDep();
        zc.repaint();
        if (d2.wantsMore()) {
            new EditConditionals(zc.getFrame(), this);
            this.validate();
        }
    }

    public void printArgs(XmlWriter xml) {
        xml.printArg("x", this.EX.toString());
        xml.printArg("y", this.EY.toString());
        xml.printArg("var", this.getVar());
        xml.printArg("min", "" + this.VarMin);
        xml.printArg("max", "" + this.VarMax);
        xml.printArg("d", "" + this.DVar);
        if (this.Special) {
            xml.printArg("special", "true");
        }
        this.printType(xml);
        if (this.Filled) {
            xml.printArg("filled", "true");
        }
        if (this.getCenter() != null) {
            xml.printArg("center", this.getCenter().getName());
        }
    }

    public void setType(int type) {
        this.Type = type;
    }

    public int getType() {
        return this.Type;
    }

    public void printType(XmlWriter xml) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xml.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xml.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xml.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xml.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xml.printArg("shape", "dcross");
                }
            }
        }
    }

    public void translate() {
        try {
            this.EX = new Expression(this.EX.toString(), this.getConstruction(), this, this.Var);
            this.EY = new Expression(this.EY.toString(), this.getConstruction(), this, this.Var);
            this.VarMin = new Expression(this.VarMin.toString(), this.getConstruction(), this);
            this.VarMax = new Expression(this.VarMax.toString(), this.getConstruction(), this);
            this.DVar = new Expression(this.DVar.toString(), this.getConstruction(), this);
            ConstructionObject O = this.getTranslation();
            this.setTranslation(this);
            this.EX.translate();
            this.EY.translate();
            this.VarMin.translate();
            this.VarMax.translate();
            this.DVar.translate();
            if (this.getCenter() != null) {
                this.setCenter(this.getCenter().getName());
                this.Center.translate();
            }
            this.validate();
            this.setTranslation(O);
        }
        catch (Exception e2) {
            System.out.println();
            System.out.println(this.getName());
            System.out.println(e2);
            e2.printStackTrace();
        }
    }

    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    public boolean equals(ConstructionObject o) {
        return false;
    }

    public Enumeration depending() {
        DL.reset();
        this.addDepending(this.EX);
        this.addDepending(this.EY);
        this.addDepending(this.VarMin);
        this.addDepending(this.VarMax);
        this.addDepending(this.DVar);
        return DL.elements();
    }

    public void addDepending(Expression E) {
        if (E != null) {
            Enumeration e2 = E.getDepList().elements();
            while (e2.hasMoreElements()) {
                DL.add((ConstructionObject)e2.nextElement());
            }
        }
    }

    public boolean hasUnit() {
        return false;
    }

    public double evaluateF(double[] x) throws ConstructionException {
        int n = x.length;
        if (n > this.X.length) {
            n = this.X.length;
        }
        int i = 0;
        while (i < n) {
            this.X[i] = x[i];
            ++i;
        }
        i = n;
        while (i < this.X.length) {
            this.X[i] = 0.0;
            ++i;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    public double evaluateF(double x) throws ConstructionException {
        this.X[0] = x;
        int i = 1;
        while (i < this.X.length) {
            this.X[i] = 0.0;
            ++i;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    public void project(PointObject P) {
        double dvar;
        double varmax;
        double varmin;
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            dvar = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
            }
            if (dvar < (varmax - varmin) / 1000.0) {
                dvar = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return;
        }
        this.X[0] = varmin;
        double x = 0.0;
        double y = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double dmin = 0.0;
        boolean started = false;
        while (true) {
            try {
                double x1 = this.EX.getValue();
                double y1 = this.EY.getValue();
                if (!started) {
                    dmin = Math.sqrt((P.getX() - x1) * (P.getX() - x1) + (P.getY() - y1) * (P.getY() - y1));
                    x0 = x = x1;
                    y0 = y = y1;
                    started = true;
                } else {
                    double h = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
                    double g = (P.getX() - x0) * (x1 - x0) + (P.getY() - y0) * (y1 - y0);
                    if (g < 0.0) {
                        g = 0.0;
                    }
                    if (g > h) {
                        g = h;
                    }
                    double x2 = x0 + g / h * (x1 - x0);
                    double y2 = y0 + g / h * (y1 - y0);
                    double d2 = Math.sqrt((P.getX() - x2) * (P.getX() - x2) + (P.getY() - y2) * (P.getY() - y2));
                    if (d2 < dmin) {
                        dmin = d2;
                        x = x2;
                        y = y2;
                    }
                    x0 = x1;
                    y0 = y1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.X[0] >= varmax) break;
            this.X[0] = this.X[0] + dvar;
            if (!(this.X[0] > varmax)) continue;
            this.X[0] = varmax;
        }
        if (started) {
            P.setXY(x, y);
        }
    }

    public double getSum() {
        double dvar;
        double varmax;
        double varmin;
        boolean reverse = false;
        boolean parametric = !this.getEX().equals(this.getVar());
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            dvar = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
                reverse = true;
            }
            if (dvar < 0.0) {
                dvar = -dvar;
            }
            if (dvar < (varmax - varmin) / 1000.0) {
                dvar = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return 0.0;
        }
        this.X[0] = varmin;
        double x0 = 0.0;
        double y0 = 0.0;
        boolean started = false;
        double sum = 0.0;
        while (true) {
            try {
                double x1 = this.EX.getValue();
                double y1 = this.EY.getValue();
                if (parametric) {
                    double x = 0.0;
                    double y = 0.0;
                    if (this.getCenter() != null) {
                        x = this.getCenter().getX();
                        y = this.getCenter().getY();
                    }
                    if (started) {
                        sum += ((x0 - x) * (y1 - y) - (y0 - y) * (x1 - x)) / 2.0;
                    }
                } else if (started) {
                    sum = this.Special ? (reverse ? (sum += (x1 - x0) * y1) : (sum += (x1 - x0) * y0)) : (sum += (x1 - x0) * (y0 + y1) / 2.0);
                }
                x0 = x1;
                y0 = y1;
                started = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.X[0] >= varmax) break;
            this.X[0] = this.X[0] + dvar;
            if (!(this.X[0] > varmax)) continue;
            this.X[0] = varmax;
        }
        return sum;
    }

    public double getLength() {
        double dvar;
        double varmax;
        double varmin;
        boolean reverse = false;
        boolean parametric = !this.getEX().equals(this.getVar());
        try {
            varmin = this.VarMin.getValue();
            varmax = this.VarMax.getValue();
            dvar = this.DVar.getValue();
            if (varmin > varmax) {
                double h = varmin;
                varmin = varmax;
                varmax = h;
                reverse = true;
            }
            if (dvar < 0.0) {
                dvar = -dvar;
            }
            if (dvar < (varmax - varmin) / 1000.0) {
                dvar = (varmax - varmin) / 1000.0;
            }
        }
        catch (Exception e2) {
            this.Valid = false;
            return 0.0;
        }
        this.X[0] = varmin;
        double x0 = 0.0;
        double y0 = 0.0;
        boolean started = false;
        double sum = 0.0;
        while (true) {
            try {
                double x1 = this.EX.getValue();
                double y1 = this.EY.getValue();
                if (started) {
                    sum += Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
                }
                started = true;
                x0 = x1;
                y0 = y1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.X[0] >= varmax) break;
            this.X[0] = this.X[0] + dvar;
            if (!(this.X[0] > varmax)) continue;
            this.X[0] = varmax;
        }
        return sum;
    }

    public boolean isSpecial() {
        return this.Special;
    }

    public void setSpecial(boolean f2) {
        this.Special = f2;
    }

    public void project(PointObject P, double alpha) {
        this.project(P);
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean canDisplayName() {
        return false;
    }

    public void setCenter(String s) {
        if (this.Cn == null) {
            return;
        }
        this.Center = new Expression("@\"" + s + "\"", this.Cn, this);
    }

    public boolean isFilledForSelect() {
        return false;
    }

    public PointObject getCenter() {
        try {
            return (PointObject)this.Center.getObject();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String getVar() {
        String vars = this.Var[0];
        int i = 1;
        while (i < this.Var.length) {
            vars = String.valueOf(vars) + " " + this.Var[i];
            ++i;
        }
        return vars;
    }

    public boolean canInteresectWith(ConstructionObject o) {
        return true;
    }

    public boolean canBeReplacedBy(ConstructionObject o) {
        return o instanceof FunctionObject;
    }
}

