/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;

public class PolygonDrawer {
    MyGraphics G;
    ConstructionObject O;
    double C;
    double R;
    double C1;
    double R1;
    boolean HaveToFinish;
    public static int step = 9;
    public boolean Marker = false;
    public boolean Started;
    boolean Solid;

    public PolygonDrawer(MyGraphics g, ConstructionObject o) {
        this.G = g;
        this.O = o;
        this.Started = false;
    }

    public void startPolygon(double c2, double r) {
        this.C = c2;
        this.R = r;
        this.HaveToFinish = false;
        this.Started = true;
    }

    public void drawTo(double c2, double r, boolean dodraw) {
        if (!this.Started) {
            this.startPolygon(c2, r);
            return;
        }
        if (dodraw || (c2 - this.C) * (c2 - this.C) + (r - this.R) * (r - this.R) > (double)step) {
            if (this.Marker) {
                ((MyGraphics13)this.G).drawMarkerLine(this.C, this.R, c2, r);
            } else {
                this.G.drawLine(this.C, this.R, c2, r, this.O);
            }
            this.C = c2;
            this.R = r;
            this.HaveToFinish = false;
        } else {
            this.C1 = c2;
            this.R1 = r;
            this.HaveToFinish = true;
        }
    }

    public void drawTo(double c2, double r) {
        this.drawTo(c2, r, false);
    }

    public void finishPolygon() {
        if (this.HaveToFinish) {
            if (this.Marker) {
                ((MyGraphics13)this.G).drawMarkerLine(this.C, this.R, this.C1, this.R1);
            } else {
                this.G.drawLine(this.C, this.R, this.C1, this.R1, this.O);
            }
            this.HaveToFinish = false;
        }
        this.Started = false;
    }

    public boolean hasStarted() {
        return this.Started;
    }

    public double c() {
        return this.C;
    }

    public double r() {
        return this.R;
    }

    public void useAsMarker() {
        this.Marker = true;
        step = 18;
    }
}

