/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import rene.util.xml.XmlTree;
import rene.zirkel.construction.ConstructionException;

public class PointCoordinates {
    double xre;
    double xim;
    double yre;
    double yim;
    double zre;
    double zim;
    double x;
    double y;
    static double[] h = new double[2];
    boolean homog = false;

    public static PointCoordinates read(XmlTree tree) throws ConstructionException {
        PointCoordinates pc = new PointCoordinates();
        for (XmlTree t1 : tree) {
            if (t1.isTag("vec3d")) {
                for (XmlTree t : t1) {
                    if (t.isTag("x")) {
                        PointCoordinates.readValue(t);
                        pc.xre = h[0];
                        pc.xim = h[1];
                        continue;
                    }
                    if (t.isTag("y")) {
                        PointCoordinates.readValue(t);
                        pc.yre = h[0];
                        pc.yim = h[1];
                        continue;
                    }
                    if (t.isTag("z")) {
                        PointCoordinates.readValue(t);
                        pc.zre = h[0];
                        pc.zim = h[1];
                        continue;
                    }
                    throw new ConstructionException("Illegal vec3d tag " + t.getTag().name());
                }
                pc.homog = true;
                continue;
            }
            throw new ConstructionException("Illegal coordinate tag " + t1.getTag().name());
        }
        pc.computeXY();
        return pc;
    }

    void computeXY() {
        if (this.homog) {
            double r = this.zre * this.zre + this.zim * this.zim;
            this.x = (this.xre * this.zre + this.xim * this.zim) / r;
            this.y = (this.yre * this.zre + this.yim * this.zim) / r;
        } else {
            this.x = this.xre;
            this.y = this.yre;
        }
    }

    public static void readValue(XmlTree tree) throws ConstructionException {
        PointCoordinates.h[1] = 0.0;
        PointCoordinates.h[0] = 0.0;
        for (XmlTree t1 : tree) {
            if (t1.isTag("complex")) {
                for (XmlTree t : t1) {
                    if (t.isTag("re")) {
                        PointCoordinates.h[0] = PointCoordinates.readNumber(t);
                        continue;
                    }
                    if (t.isTag("im")) {
                        PointCoordinates.h[1] = PointCoordinates.readNumber(t);
                        continue;
                    }
                    throw new ConstructionException("Illegal tag in complex!");
                }
                continue;
            }
            throw new ConstructionException("Illegal tag in vec3d!");
        }
    }

    public static double readNumber(XmlTree tree) throws ConstructionException {
        try {
            return Double.parseDouble(tree.getText());
        }
        catch (Exception e2) {
            throw new ConstructionException(tree.getText());
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }
}

