/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.objects.Evaluator;

public class Romberg {
    private static double sumUp(Evaluator F, double x, double h, int n) throws ConstructionException {
        double sum = F.evaluateF(x);
        int i = 1;
        while (i <= n) {
            sum += F.evaluateF(x + (double)i * h);
            ++i;
        }
        return sum;
    }

    public static double compute(Evaluator F, double a2, double b2, int nstart, double eps, int maxiter) throws ConstructionException {
        double tlast;
        double[] t = new double[maxiter];
        int n = nstart;
        double h = (b2 - a2) / (double)n;
        double tlastbutone = tlast = (t[0] = (F.evaluateF(a2) + F.evaluateF(b2) + 2.0 * Romberg.sumUp(F, a2 + h, h, n - 2)) * h / 2.0);
        double old = t[0];
        int i = 1;
        while (i < maxiter) {
            t[i] = tlast / 2.0 + Romberg.sumUp(F, a2 + (h /= 2.0), 2.0 * h, (n *= 2) / 2 - 1) * h;
            tlastbutone = tlast;
            tlast = t[i];
            double q = 4.0;
            int j = i - 1;
            while (j >= 0) {
                t[j] = t[j + 1] + (t[j + 1] - t[j]) / (q - 1.0);
                q *= 4.0;
                --j;
            }
            double res = t[0];
            if (Math.abs((res - old) / res) < eps) {
                return res;
            }
            old = res;
            ++i;
        }
        return tlast;
    }
}

