/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ParallelConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PlumbObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class PlumbConstructor
extends ParallelConstructor {
    public PrimitiveLineObject create(Construction c2, PrimitiveLineObject l, PointObject p) {
        return new PlumbObject(c2, l, p);
    }

    public void showStatus(ZirkelCanvas zc) {
        if (this.L == null) {
            zc.showStatus(Zirkel.name("message.plumb.first", "Plumb Line: Choose a line!"));
        } else {
            zc.showStatus(Zirkel.name("message.plumb.second", "Plumb Line: Choose a Point!"));
        }
    }

    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Plumb")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("point") || !tag.hasParam("line")) {
            throw new ConstructionException("Plumb parameters missing!");
        }
        try {
            PointObject p1 = (PointObject)c2.find(tag.getValue("point"));
            PrimitiveLineObject p2 = (PrimitiveLineObject)c2.find(tag.getValue("line"));
            PlumbObject o = new PlumbObject(c2, p2, p1);
            if (tag.hasParam("valid")) {
                o.setRestricted(false);
            }
            this.setName(tag, o);
            this.set(tree, o);
            if (tag.hasParam("partial")) {
                o.setPartial(true);
            }
            c2.add(o);
            this.setConditionals(tree, c2, o);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Plumb parameters illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.plumb");
    }

    public String getTag() {
        return "Plumb";
    }

    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 2) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[0]);
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.notfound")) + " " + params[1]);
        }
        if (!(P1 instanceof PrimitiveLineObject)) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[0]);
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(String.valueOf(Zirkel.name("exception.type")) + " " + params[1]);
        }
        PlumbObject s = new PlumbObject(c2, (PrimitiveLineObject)P1, (PointObject)P2);
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
        c2.add(s);
        s.setDefaults();
    }
}

