package com.packtpub.hibernatesearch.domain;

import javax.persistence.Embeddable;

import org.hibernate.search.annotations.Field;

/**
 * Osadzalny obiekt (lub "komponent" w tradycyjnym argonie Hibernate), przechowujcy opini uytkownika o aplikacji. 
 * Opinia skada si z nazwy uytkownika prezentujcego opini, liczby gwiazdek (maksimum pi) oznaczajcych ocen aplikacji,
 * oraz komentarza.
 * 
 * Adnotacja @Embeddable informuje Hibernate, e czas ycia obiektu jest zaleny od czasu ycia obiektu w ktrym si zawiera.
 * Innymi sowy, gdy aplikacja zostanie skasowana, razem z ni zostan skasowane komentarze jej dotyczce.
 *
 * Poniewa ta klasa nie jest adnotowana za pomoc @Indexed, Hibernate Search nie utworzy dla niej indeksu Lucene.
 * Wszystkie informacje wskazane do indeksowania trafi do indeksu Lucene obiektu w ktrym si zawiera. 
 */
@Embeddable
public class CustomerReview {

	/**
	 * Nazwa uytkownika osoby wysyajcej komentarz. Adnotacja @Column jest zbdna dla osadzalnych obiektw, 
	 * jednak adnotacja Hibernate Search @Field jest nadal uywana by zmapowa pole na indeks Lucene dowolnej encji, w ktrej 
	 * obiekt zosta osadzony (np. App).
	 */	
	@Field
	private String username;
	
	/**
	 * Ocena w skali od 1 do 5 (np. "4 z 5 gwiazdek"). Nie planujemy wyszukiwania na podstawie tej wartoci, wic nie uyjemy 
	 * adnotacji @Column ani @Field.
	 */
	private int stars;
	
	/**
	 * Komentarz dotyczcy aplikacji.  Adnotacja @Column jest zbdna dla osadzalnych obiektw, 
	 * jednak adnotacja Hibernate Search @Field jest nadal uywana by zmapowa pole na indeks Lucene dowolnej encji, w ktrej 
	 * obiekt zosta osadzony (np. App).
	 */	
	@Field
	private String comments;

	/**
	 * Domylny pusty konstruktor.
	 */
	public CustomerReview() {
	}
	
	/**
	 * Wygodny konstruktor, ustawiajcy wszystkie wartoci pl jednoczenie.
	 */
	public CustomerReview(String username, int stars, String comments) {
		this.username = username;
		this.stars = stars;
		this.comments = comments;
	}

	//
	// GETTERY I SETTERY
	//
	
	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public int getStars() {
		return stars;
	}

	public void setStars(int stars) {
		this.stars = stars;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}
	
}
