package com.packtpub.hibernatesearch.domain;

/**
 * Osadzalny obiekt (lub "komponent" w tradycyjnym argonie Hibernate), przechowujcy opini uytkownika o aplikacji. 
 * Opinia skada si z nazwy uytkownika prezentujcego opini, liczby gwiazdek (maksimum pi) oznaczajcych ocen aplikacji,
 * oraz komentarza.
 * 
 * Ten wariant aplikacji jest mapowany do bazy danych za pomoc klasycznego podejcia opartego na plikach XML.
 * W Mavenowej strukturze projektu wszystkie pliki XML s umieszczone w "src/main/resources".  Hibernate 
 * automatycznie przeglda plik "hibernate.cfg.xml", ktry odwouje si do "com/packtpub/hibernatesearch/domain/App.hbm.xml"
 * by zaadowa informacje o mappowaniu encji App (ktra zawiera w sobie obiekty typu CustomerReview). Poniewa CustomerReview
 * nie jest penoprawn encj, nie posiada wasnego pliku "hbm.xml. Hibernate konfiguruje go uywajc elementu XML
 * <composite-element> w pliku mapujcym encj zawierajc wbudowane obiekty (np. "App.hbm.xml").
 * 
 * Cykl ycia obiektw tego typu jest uzaleniony od obiektw w ktrych si zawieraj. Innymi sowy, jeeli aplikacja zostanie 
 * skasowana, razem z ni zostan skasowane komentarze uytkownikw. 
 * 
 * Poniewa ta wbudowana klasa nie jest adnotowana za pomoc @Indexed, Hibernate Search nie utworzy dedykowanego indeksu Lucene  
 * dla niej.  Wszystkie indeksowane informacje dla tej klasy znajd si w indeksie Lucene encji zawierajcej obiekty tej klasy (np. App). 
 */
public class CustomerReview {

	/**
	 * Nazwa uytkownika osoby wysyajcej komentarz.  Adnotacja Hibernate Search @Field jest uywana by zmapowa pole na indeks Lucene 
	 * dowolnej encji, w ktrej obiekt zosta osadzony (np. App).
	 */	
  private String username;

	/**
	 * Ocena w skali od 1 do 5 (np. "4 z 5 gwiazdek"). Nie planujemy wyszukiwania na podstawie tej wartoci, wic nie uyjemy 
	 * adnotacji @Column ani @Field.
	 */
	private int stars;
	
	/**
	 * Komentarz dotyczcy aplikacji.  Adnotacja Hibernate Search @Field jest uywana by zmapowa pole na indeks Lucene 
	 * dowolnej encji, w ktrej obiekt zosta osadzony (np. App).
	 */	
	private String comments;

	/**
	 * Domylny pusty konstruktor.
	 */
	public CustomerReview() {
	}
	
	/**
	 * Wygodny konstruktor, ustawiajcy wszystkie wartoci pl jednoczenie.  
	 */
	public CustomerReview(String username, int stars, String comments) {
		this.username = username;
		this.stars = stars;
		this.comments = comments;
	}

	//
	// GETTERY I SETTERY
	//
	
	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public int getStars() {
		return stars;
	}

	public void setStars(int stars) {
		this.stars = stars;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}
	
}
