package com.packtpub.hibernatesearch.util;

import javax.servlet.ServletContextEvent;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.packtpub.hibernatesearch.domain.App;

/**
 * Klasa pomocniczna uywana do zapenienia wbudowanej bazy H2 testowymi danymi podczas startu aplikacji. 
 * Dziki ustawieniom w pliku "web.xml", metoda "contextInitialized" bdzie automatycznie wywoana podczas 
 * startu kontenera servletw.
 */
public class StartupDataLoader implements javax.servlet.ServletContextListener {
	
	Logger logger = LoggerFactory.getLogger(StartupDataLoader.class);

	/**
	 * Nie powinna by uywana bezporednio. Uyj openSession().
	 */
	private static SessionFactory sessionFactory;
	
	/**
	 * Konstruowanie nowej SessionFactory Hibernate dla kadego dania HTTP powodowaoby problemy wydajnociowe. Poniewa
	 * servlety Javy musz by wspbiene, nie moemy zadeklarowa by SessionFactory bya publiczn statyczn zmienn.
	 * Ta metoda udostpnia wspbieny dostp do SessionFactory, dziki czemu metoda zapeniajca baz danych przykadowymi danymi 
	 * i servlet wyszukujcy mog otwiera poczenia do bazy danych bardziej wydajnie. 
	 * 
	 * @return Session
	 */
	public static synchronized Session openSession() {
		if(sessionFactory == null) {
			Configuration configuration = new Configuration();
			configuration.configure();
			ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings(configuration.getProperties()).buildServiceRegistry();
			sessionFactory = configuration.buildSessionFactory(serviceRegistry);			
		}
		return sessionFactory.openSession();
	}

	/**
	 * Ta metoda jest uruchamiana automatycznie gdy uruchomiony zostaje mechanizm servletw.
	 */
	public void contextInitialized(ServletContextEvent event) {

		//
		// Utwrz sesj Hibernate i rozpocznij now transakcj bazodanow.
		//
		Session session = openSession();
		session.beginTransaction();
		
		//
		// Utwrz i zapisz 12 testowyc aplikacji
		//
		App app1 = new App("Chmura!", "cloud.jpg", "Aplikacja Chmura! jest miejscem, w ktrym dziej si cuda. Firmy dziaaj w chmurach. Programici nie potrzebuj administratorw, jedzenia i picia w zasadzie te nie. Moesz oglda telewizj na tablecie, siedza na kanapie; nie musisz w ogle patrze na telewizor! cignij aplikacj Chmura! z chmury i dowiadcz tej cudownej potgi!");
		session.save(app1);
		logger.info("Zapisuj " + app1.getName());

		App app2 = new App("Zamykacz transakcji", "pointing.jpg", "Wysokoenergetyczna aplikacja wspomagajca energicznych sprzedawcw. Twrz pene energii kalendarze i arkusze. Gdy jeste w miecie i energicznie nawizujesz kontakty, chcesz prezentowa swe naenergetyzowane foldery, pokazujce, e te masz w sobie mnstwo energii.");
		session.save(app2);
		logger.info("Zapisuj " + app2.getName());

		App app3 = new App("Midzynarodowy turniej pikarski", "ball.jpg", "Ta maa aplikacja oferuje Ci rado gry w pik non, poza tym, e grasz na ekranie dotykowym, zamiast biega i kopa albo w ogle si rusza. Poza tym zapewnia podobne wraenia.");
		session.save(app3);
		logger.info("Zapisuj " + app3.getName());
		
		App app4 = new App("Kolejna gra o krysztaach", "brilliant.jpg", "Olniewajca aplikacja, w ktrej czysz krysztay tego samego koloru, by znikny. Co jak Tetris. W sumie przypomina tuzin innych gier, w ktrych czysz krysztay tego samego koloru.");
		session.save(app4);
		logger.info("Zapisuj " + app4.getName());
		
		App app5 = new App("Temperwka", "pencil.jpg", "Ostrz owki, wkadajc je do gniazda Bluetooth i wciskajc przycisk. Ta aplikacja wyciska ze sprztu wszystko!");
		session.save(app5);
		logger.info("Zapisuj " + app5.getName());
		
		App app6 = new App("Namierzacz zszywaczy", "stapler.jpg", "Czy kto cigle poycza sobie Twj zszywacz? To typowy problem w biurach. Nasza aplikacja biznesowa sprawi, e ju nigdy nie bdziesz musia si zastanawia, gdzie podziewa si Twj zszywacz.");
		session.save(app6);
		logger.info("Zapisuj " + app6.getName());
		
		App app7 = new App("Sfrustrowane Flamingi", "flamingo.jpg", "Maa aplikacja pozwalajca na ciskanie wielkimi ptakami na lewo i prawo bez powodu. Chyba nie zastanawiasz si czemu s sfrustrowane?");
		session.save(app7);
		logger.info("Zapisuj " + app7.getName());
		
		App app8 = new App("Wideokonferencje Grype", "laptop.jpg", "Dzwo za darmo lokalnie i za granic, rwnie z transmisj obrazu, uywajc domowego poczenia internetowego i naszego produktu. W sumie nasz aplikacja zadziaa jeszcze lepiej jeli skorzystasz z poczenia internetowego Twojego pracodawcy!");
		session.save(app8);
		logger.info("Zapisuj " + app8.getName());
		
		App app9 = new App("Czytnik E-Bookw", "book.jpg", "Nasza aplikacja sprawi, e bdziesz mg czyta ksiki na komputerze albo na dowolnym urzdzeniu mobilnym.  Polecamy \"Hibernate Search by Example\".");
		session.save(app9);
		logger.info("Zapisuj " + app9.getName());
		
		App app10 = new App("Przegldarka pod kopu", "orangeswirls.jpg", "Ta cudowna aplikacja pozwala nam ledzi Twoj aktywno w Internecie. Moemy odgadn, gdzie mieszkasz, co jade dzisiaj na niadanie albo jakie s Twoje najwiksze sekrety. Aha, w aplikacj jest jeszcze wbudowana przegldarka stron WWW.");
		session.save(app10);
		logger.info("Zapisuj " + app10.getName());
		
		App app11 = new App("Internetowe radio Atena", "jamming.jpg", "Suchaj swoich ulubionych piosenek w radiu internetowym! Kiedy polubisz jaki utwr, nasza aplikacja zagra Ci wicej podobnych kompozycji. A przynajmniej zagra wicej piosenek ... eby by szczerym, czasem wcale nie s takie podobne  :(");
		session.save(app11);
		logger.info("Zapisuj " + app11.getName());
		
		App app12 = new App("Mapa podry", "compass.jpg", "Potrzebujesz wskazwek, by dotrze do celu?  Nasza aplikacja GPS na pewno wygeneruje wystarczajco duo propozycji, by dotar do celu!  Prdzej czy pniej.");
		session.save(app12);
		logger.info("Zapisuj " + app12.getName());
		
		session.getTransaction().commit();
		
		//
		// Zamknij i wyczy sesj Hibernate
		//
		session.close();
	} 

	/**
	 * Ta metoda jest wywoywana gdy mechanizm servletw jest wyczany. Zamyka Hibernate SessionFactory jeeli jeszcze jest otwarta.
	 */
	public void contextDestroyed(ServletContextEvent event) {
		if(!sessionFactory.isClosed()) {
			sessionFactory.close();
		}
	}

}
