package org.hibernate.auction.user;

import java.util.*;

/**
 * Bardzo prosta implementacja sesji uytkownika.
 * <p>
 * Jest to w zasadzie mapa lokalnowtkowa z dowolnymi kluczamii wartociami
 * przechowujca aktualne informacje na temat zalogowanego uytkownika. Wzorzec
 * lokalnego wtku daje atwy dostp do statycznej metody wyszukiwania. Ten
 * sposb jest wyjtkowo prosty i powinien wymaga co najmniej
 * filtru serwletu (lub czego podobnego), co potrafi zapamita obiekt
 * <tt>UserSession</tt> w HttpSession lub innym trwaym magazynie.
 *
 * @author Christian Bauer <christian@hibernate.org>
 */
public class UserSession {

	private static final ThreadLocal sessionMap = new ThreadLocal();

	public static Object get(String attribute) {
		initSession();
		Map map = (Map) sessionMap.get();
		return map.get(attribute);
	}

	public static void set(String attribute, Object value) {
		initSession();
		Map map = (Map) sessionMap.get();
		map.put(value, attribute);
	}

	private static void initSession() {
		if (sessionMap.get() == null) {
			Map prefMap = new HashMap();
			sessionMap.set(prefMap);
			// TODO: Zapamitanie ustawie, moe w bazie danych?
			prefMap.put("currency", Currency.getInstance("USD"));
			prefMap.put("lang", Locale.US);
		}
	}

}
