package org.hibernate.auction.test;

import org.hibernate.auction.model.*;
import org.hibernate.auction.persistence.HibernateUtil;
import org.hibernate.auction.dao.*;

import java.math.BigDecimal;
import java.util.*;
/**
 * Nie jest to rzeczywisty test tylko sprawdzenia inicjacji danych.
 *
 * @author Christian Bauer <christian@hibernate.org>
 */
public abstract class TestCaseWithData extends TestCase {

	// Przechowuj referencje do obiektw dziedzinowych.
	Category cars;
	Category carsLuxury;
	Category carsSUV;

	User u1;
	User u2;
	User u3;

	Item auctionOne;
	Item auctionTwo;
	Item auctionThree;
	Item auctionFour;

	// ********************************************************** //

	/**
	 * Utwrz dane testowe dla testw.
	 *
	 * @throws Exception
	 */
	protected void initData() throws Exception {

		// Przygotowanie obiektw DAO.
		CategoryDAO catDAO = new CategoryDAO();
		UserDAO userDAO = new UserDAO();
		ItemDAO itemDAO = new ItemDAO();
		CommentDAO commentDAO = new CommentDAO();

		// Kategorie
		cars = new Category("Autoa");
		carsLuxury = new Category("Auta luksusowe");
		cars.addChildCategory(carsLuxury);
		carsSUV = new Category("SUVy");
		cars.addChildCategory(carsSUV);
		catDAO.makePersistent(cars);

		// Uytkownicy
		u1 = new User("Christian", "Bauer", "turin", "abc123", "christian@hibernate.org");
		u1.setAddress(new Address("Foo", "12345", "Bar"));
		u1.setAdmin(true);
		u2= new User("Gavin", "King", "gavin", "abc123", "gavin@hibernate.org");
		u2.setAddress(new Address("Foo", "12345", "Bar"));
		u3= new User("Max", "Andersen", "max", "abc123", "max@hibernate.org");
		u3.setAddress(new Address("Foo", "12345", "Bar"));
		userDAO.makePersistent(u1);
		userDAO.makePersistent(u2);
		userDAO.makePersistent(u3);

		// Szczegy patnoci.
		BillingDetails ccOne = new CreditCard("Christian  Bauer", u1, "1234567890",
		                                        CreditCardType.MASTERCARD, "10", "2005");
		BillingDetails accOne = new BankAccount("Christian Bauer", u1, "234234234234",
		                                        "FooBar Rich Bank", "foobar123foobaz");
		u1.addBillingDetails(ccOne);
		u1.addBillingDetails(accOne);

		// Przedmioty
		Calendar inThreeDays = GregorianCalendar.getInstance();
		inThreeDays.roll(Calendar.DAY_OF_YEAR, 3);
		Calendar inFiveDays = GregorianCalendar.getInstance();
		inFiveDays.roll(Calendar.DAY_OF_YEAR, 5);
		Calendar nextWeek = GregorianCalendar.getInstance();
		nextWeek.roll(Calendar.WEEK_OF_YEAR, true);

		auctionOne = new Item("Przedmiot pierwszy", "Przedmiot z kategorii aut luksusowych.",
		        u2,
		        new MonetaryAmount(new BigDecimal("1.99"), Currency.getInstance(Locale.US)),
		        new MonetaryAmount(new BigDecimal("50.33"), Currency.getInstance(Locale.US)),
		        new Date(), inThreeDays.getTime());
		auctionOne.setPendingForApproval();
		auctionOne.approve(u1);
		itemDAO.makePersistent(auctionOne);
		new CategorizedItem(u1.getUsername(), carsLuxury, auctionOne);

		auctionTwo = new Item("Przedmiot drugi", "Inny przedmiot z kategorii aut luksusowych.",
				u2,
		        new MonetaryAmount(new BigDecimal("2.22"), Currency.getInstance(Locale.US)),
		        new MonetaryAmount(new BigDecimal("100.88"), Currency.getInstance(Locale.US)),
		        new Date(), inFiveDays.getTime());
		itemDAO.makePersistent(auctionTwo);
		new CategorizedItem(u1.getUsername(), carsLuxury, auctionTwo);

		auctionThree = new Item("Przedmiot trzeci", "Nie kieruj SUVem.",
				u2,
		        new MonetaryAmount(new BigDecimal("3.11"), Currency.getInstance(Locale.US)),
		        new MonetaryAmount(new BigDecimal("300.55"), Currency.getInstance(Locale.US)),
		        new Date(), inThreeDays.getTime());
		itemDAO.makePersistent(auctionThree);
		new CategorizedItem(u1.getUsername(), carsSUV, auctionThree);

		auctionFour = new Item("Przedmiotczwarty", "Naprawd, to nie jest luksusowy SUV.",
				u1,
		        new MonetaryAmount(new BigDecimal("4.55"), Currency.getInstance(Locale.US)),
		        new MonetaryAmount(new BigDecimal("40.99"), Currency.getInstance(Locale.US)),
		        new Date(), nextWeek.getTime());
		itemDAO.makePersistent(auctionFour);
		new CategorizedItem(u1.getUsername(), carsLuxury, auctionFour);
		new CategorizedItem(u1.getUsername(), carsSUV, auctionFour);

		// Oferty
		Bid bidOne1 = new Bid(new MonetaryAmount(new BigDecimal("12.12"), Currency.getInstance(Locale.US)),
		        auctionOne, u3);
		org.hibernate.auction.model.Bid bidOne2 = new Bid(new MonetaryAmount(new BigDecimal("13.13"), Currency.getInstance(Locale.US)),
		        auctionOne, u1);
		Bid bidOne3 = new Bid(new MonetaryAmount(new BigDecimal("14.14"), Currency.getInstance(Locale.US)),
		        auctionOne, u3);

		auctionOne.addBid(bidOne1);
		auctionOne.addBid(bidOne2);
		auctionOne.addBid(bidOne3);

		// Oferta wygrywajca
		auctionOne.setSuccessfulBid(bidOne3);

		// Komentarze
		Comment commentOne = new Comment(Rating.EXCELLENT, "Wspaniale.", u3, auctionOne);
		Comment commentTwo = new Comment(Rating.LOW, "Sabiutko.", u1, auctionThree);
		commentDAO.makePersistent(commentOne);
		commentDAO.makePersistent(commentTwo);

		HibernateUtil.commitTransaction();
		HibernateUtil.closeSession();

	}

	// ********************************************************** //

	public TestCaseWithData(String x) {
		super(x);
	}

}
