package org.hibernate.auction.test;

import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.auction.persistence.HibernateUtil;


public abstract class TestCase extends junit.framework.TestCase {

	public TestCase(String s) {
		super(s);
	}

	protected void runTest() throws Throwable {
		try {
			System.out.println("Wykonuj test...");
			super.runTest();
		} catch (Throwable e) {
			HibernateUtil.rollbackTransaction();
			throw e;
		} finally{
			HibernateUtil.closeSession();
		}
	}

	protected void setUp() throws Exception {
		super.setUp();
		SchemaExport ddlExport = new SchemaExport(HibernateUtil.getConfiguration());
		ddlExport.create(false, true);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		SchemaExport ddlExport = new SchemaExport(HibernateUtil.getConfiguration());
		ddlExport.drop(false, true);
	}

}
