package org.hibernate.auction.persistence;

import net.sf.hibernate.*;
import net.sf.hibernate.cfg.Configuration;
import org.apache.commons.logging.*;

/**
 * Bardzo prosta klasa pomocnicza przechowujca SessionFactory jako singleton.
 * <p>
 * Jedynym zadaniem tej klasy pomocniczej jest uatwienie dostpu do 
 * obiektu <tt>SessionFactory</tt>. Inicjalizuje obiekt <tt>SessionFactory</tt>
 * w momencie zaadowania klasy (inicjalizacja statyczna), co uatwie tworzenie obiektw
 * <tt>Session</tt>s. Uyteczna tylko w prostych aplikacjach.
 *
 * @author christian@hibernate.org
 */
public class HibernateUtilSimple {

	private static Log log = LogFactory.getLog(HibernateUtil.class);

	private static final SessionFactory sessionFactory;

	// Tworzy obiekt SessionFactory na podstawie domylnych plikw konfiguracyjnych.
	static {
		try {
			sessionFactory = new Configuration().configure().buildSessionFactory();
		} catch (Throwable ex) {
			// Musimy wyapywa Throwable, bo w przeciwnym razie nie zapalibymy
			// NoClassDefFoundError ai innych podklas Error.
			log.error("Nieudane utworzenie SessionFactory.", ex);
			throw new ExceptionInInitializerError(ex);
		}
	}

	public static Session getSession()
		throws HibernateException {
		return sessionFactory.openSession();
	}
}
